/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.LocationUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.TreeType;
import org.bukkit.entity.LivingEntity;

public class Commandtree
extends EssentialsCommand {
    public Commandtree() {
        super("tree");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        TreeType tree;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        if (args[0].equalsIgnoreCase("birch")) {
            tree = TreeType.BIRCH;
        } else if (args[0].equalsIgnoreCase("redwood")) {
            tree = TreeType.REDWOOD;
        } else if (args[0].equalsIgnoreCase("tree")) {
            tree = TreeType.TREE;
        } else if (args[0].equalsIgnoreCase("redmushroom")) {
            tree = TreeType.RED_MUSHROOM;
        } else if (args[0].equalsIgnoreCase("brownmushroom")) {
            tree = TreeType.BROWN_MUSHROOM;
        } else if (args[0].equalsIgnoreCase("jungle")) {
            tree = TreeType.SMALL_JUNGLE;
        } else if (args[0].equalsIgnoreCase("junglebush")) {
            tree = TreeType.JUNGLE_BUSH;
        } else if (args[0].equalsIgnoreCase("swamp")) {
            tree = TreeType.SWAMP;
        } else {
            throw new NotEnoughArgumentsException();
        }
        Location loc = LocationUtil.getTarget((LivingEntity)user.getBase());
        Location safeLocation = LocationUtil.getSafeDestination(loc);
        boolean success = user.getWorld().generateTree(safeLocation, tree);
        if (success) {
            user.sendMessage(I18n._("treeSpawned", new Object[0]));
        } else {
            user.sendMessage(I18n._("treeFailure", new Object[0]));
        }
    }
}

