/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsToggleCommand;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;

public class Commandfly
extends EssentialsToggleCommand {
    public Commandfly() {
        super("fly", "essentials.fly.others");
    }

    @Override
    protected void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        this.toggleOtherPlayers(server, sender, args);
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length == 1) {
            Boolean toggle = this.matchToggleArgument(args[0]);
            if (toggle == null && user.isAuthorized(this.othersPermission)) {
                this.toggleOtherPlayers(server, (CommandSender)user.getBase(), args);
            } else {
                this.togglePlayer((CommandSender)user.getBase(), user, toggle);
            }
        } else if (args.length == 2 && user.isAuthorized(this.othersPermission)) {
            this.toggleOtherPlayers(server, (CommandSender)user.getBase(), args);
        } else {
            this.togglePlayer((CommandSender)user.getBase(), user, null);
        }
    }

    @Override
    void togglePlayer(CommandSender sender, User user, Boolean enabled) {
        if (enabled == null) {
            enabled = !user.getAllowFlight();
        }
        user.setFallDistance(0.0f);
        user.setAllowFlight(enabled);
        if (!user.getAllowFlight()) {
            user.setFlying(false);
        }
        user.sendMessage(I18n._("flyMode", I18n._(enabled != false ? "enabled" : "disabled", new Object[0]), user.getDisplayName()));
        if (!sender.equals(user.getBase())) {
            sender.sendMessage(I18n._("flyMode", I18n._(enabled != false ? "enabled" : "disabled", new Object[0]), user.getDisplayName()));
        }
    }
}

