/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.commands.QuietAbortException;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class Commandfeed
extends EssentialsCommand {
    public Commandfeed() {
        super("feed");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length > 0 && user.isAuthorized("essentials.feed.others")) {
            if (args[0].trim().length() < 2) {
                throw new PlayerNotFoundException();
            }
            if (!user.isAuthorized("essentials.feed.cooldown.bypass")) {
                user.healCooldown();
            }
            this.feedOtherPlayers(server, (CommandSender)user.getBase(), args[0]);
            return;
        }
        if (!user.isAuthorized("essentials.feed.cooldown.bypass")) {
            user.healCooldown();
        }
        try {
            this.feedPlayer((CommandSender)user.getBase(), user.getBase());
        }
        catch (QuietAbortException e) {
            // empty catch block
        }
        user.sendMessage(I18n._("feed", new Object[0]));
    }

    @Override
    protected void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        this.feedOtherPlayers(server, sender, args[0]);
    }

    private void feedOtherPlayers(Server server, CommandSender sender, String name) throws PlayerNotFoundException {
        boolean skipHidden = sender instanceof Player && !this.ess.getUser(sender).isAuthorized("essentials.vanish.interact");
        boolean foundUser = false;
        List matchedPlayers = server.matchPlayer(name);
        for (Player matchPlayer : matchedPlayers) {
            User player = this.ess.getUser(matchPlayer);
            if (skipHidden && player.isHidden()) continue;
            foundUser = true;
            try {
                this.feedPlayer(sender, matchPlayer);
            }
            catch (QuietAbortException e) {}
        }
        if (!foundUser) {
            throw new PlayerNotFoundException();
        }
    }

    private void feedPlayer(CommandSender sender, Player player) throws QuietAbortException {
        int amount = 30;
        FoodLevelChangeEvent flce = new FoodLevelChangeEvent((HumanEntity)player, 30);
        this.ess.getServer().getPluginManager().callEvent((Event)flce);
        if (flce.isCancelled()) {
            throw new QuietAbortException();
        }
        player.setFoodLevel(flce.getFoodLevel() > 20 ? 20 : flce.getFoodLevel());
        player.setSaturation(10.0f);
        if (!sender.equals(player)) {
            sender.sendMessage(I18n._("feedOther", player.getDisplayName()));
        }
    }
}

