/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commandtpaall
extends EssentialsCommand {
    public Commandtpaall() {
        super("tpaall");
    }

    @Override
    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            if (sender instanceof Player) {
                this.teleportAAllPlayers(server, sender, this.ess.getUser(sender));
                return;
            }
            throw new NotEnoughArgumentsException();
        }
        User target = this.getPlayer(server, sender, args, 0);
        this.teleportAAllPlayers(server, sender, target);
    }

    private void teleportAAllPlayers(Server server, CommandSender sender, User target) {
        sender.sendMessage(I18n._("teleportAAll", new Object[0]));
        for (Player onlinePlayer : server.getOnlinePlayers()) {
            User player = this.ess.getUser(onlinePlayer);
            if (target == player || !player.isTeleportEnabled() || sender.equals(target.getBase()) && target.getWorld() != player.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !target.isAuthorized("essentials.worlds." + target.getWorld().getName())) continue;
            try {
                player.requestTeleport(target, true);
                player.sendMessage(I18n._("teleportHereRequest", target.getDisplayName()));
                player.sendMessage(I18n._("typeTpaccept", new Object[0]));
                if (this.ess.getSettings().getTpaAcceptCancellation() == 0L) continue;
                player.sendMessage(I18n._("teleportRequestTimeoutInfo", this.ess.getSettings().getTpaAcceptCancellation()));
            }
            catch (Exception ex) {
                this.ess.showError(sender, ex, this.getName());
            }
        }
    }
}

