/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;

public class Commandlightning
extends EssentialsCommand {
    public Commandlightning() {
        super("lightning");
    }

    @Override
    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        User user = null;
        if (sender instanceof Player) {
            user = this.ess.getUser((Player)sender);
            if (args.length < 1 || user != null && !user.isAuthorized("essentials.lightning.others")) {
                user.getWorld().strikeLightning(user.getTargetBlock(null, 600).getLocation());
                return;
            }
        }
        int power = 5;
        if (args.length > 1) {
            try {
                power = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (args[0].trim().length() < 2) {
            throw new PlayerNotFoundException();
        }
        List matchedPlayers = server.matchPlayer(args[0]);
        for (Player matchPlayer : matchedPlayers) {
            User matchUser = this.ess.getUser(matchPlayer);
            sender.sendMessage(I18n._("lightningUse", matchPlayer.getDisplayName()));
            LightningStrike strike = matchPlayer.getWorld().strikeLightningEffect(matchPlayer.getLocation());
            if (!matchUser.isGodModeEnabled()) {
                matchPlayer.damage((double)power, (Entity)strike);
            }
            if (!this.ess.getSettings().warnOnSmite()) continue;
            matchUser.sendMessage(I18n._("lightningSmited", new Object[0]));
        }
    }
}

