/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class Commandkill
extends EssentialsCommand {
    public Commandkill() {
        super("kill");
    }

    @Override
    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        if (args[0].trim().length() < 2) {
            throw new NotEnoughArgumentsException("You need to specify a player to kill.");
        }
        List matchedPlayers = server.matchPlayer(args[0]);
        for (Player matchPlayer : matchedPlayers) {
            if (sender instanceof Player && this.ess.getUser(matchPlayer).isAuthorized("essentials.kill.exempt") && !this.ess.getUser(sender).isAuthorized("essentials.kill.force")) {
                throw new Exception(I18n._("killExempt", matchPlayer.getDisplayName()));
            }
            EntityDamageEvent ede = new EntityDamageEvent((Entity)matchPlayer, sender instanceof Player && ((Player)sender).getName().equals(matchPlayer.getName()) ? EntityDamageEvent.DamageCause.SUICIDE : EntityDamageEvent.DamageCause.CUSTOM, Short.MAX_VALUE);
            server.getPluginManager().callEvent((Event)ede);
            if (ede.isCancelled() && sender instanceof Player && !this.ess.getUser(sender).isAuthorized("essentials.kill.force")) continue;
            matchPlayer.damage(32767.0);
            if (matchPlayer.getHealth() > 0.0) {
                matchPlayer.setHealth(0.0);
            }
            sender.sendMessage(I18n._("kill", matchPlayer.getDisplayName()));
        }
    }
}

