/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commandext
extends EssentialsCommand {
    public Commandext() {
        super("ext");
    }

    @Override
    protected void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        this.extinguishPlayers(server, sender, args[0]);
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            user.setFireTicks(0);
            user.sendMessage(I18n._("extinguish", new Object[0]));
            return;
        }
        if (args[0].trim().length() < 2) {
            throw new PlayerNotFoundException();
        }
        this.extinguishPlayers(server, (CommandSender)user.getBase(), args[0]);
    }

    private void extinguishPlayers(Server server, CommandSender sender, String name) throws Exception {
        boolean skipHidden = sender instanceof Player && !this.ess.getUser(sender).isAuthorized("essentials.vanish.interact");
        boolean foundUser = false;
        List matchedPlayers = server.matchPlayer(name);
        for (Player matchPlayer : matchedPlayers) {
            User player = this.ess.getUser(matchPlayer);
            if (skipHidden && player.isHidden()) continue;
            foundUser = true;
            matchPlayer.setFireTicks(0);
            sender.sendMessage(I18n._("extinguishOthers", matchPlayer.getDisplayName()));
        }
        if (!foundUser) {
            throw new PlayerNotFoundException();
        }
    }
}

