/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.signs.SignException;
import net.ess3.api.IEssentials;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class SignFree
extends EssentialsSign {
    public SignFree() {
        super("Free");
    }

    @Override
    protected boolean onSignCreate(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException {
        try {
            this.getItemStack(sign.getLine(1), 1, ess);
        }
        catch (SignException ex) {
            sign.setLine(1, "\u00a7c<item>");
            throw new SignException(ex.getMessage(), ex);
        }
        return true;
    }

    @Override
    protected boolean onSignInteract(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException {
        ItemStack item = this.getItemStack(sign.getLine(1), 1, ess);
        if (item.getType() == Material.AIR) {
            throw new SignException(I18n._("cantSpawnItem", "Air"));
        }
        item.setAmount(item.getType().getMaxStackSize());
        Inventory invent = ess.getServer().createInventory((InventoryHolder)player.getBase(), 36);
        for (int i = 0; i < 36; ++i) {
            invent.addItem(new ItemStack[]{item});
        }
        player.openInventory(invent);
        Trade.log("Sign", "Free", "Interact", username, null, username, new Trade(item, ess), sign.getBlock().getLocation(), ess);
        return true;
    }
}

