/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.craftbukkit;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class InventoryWorkaround {
    private InventoryWorkaround() {
    }

    private static int firstPartial(Inventory inventory, ItemStack item, int maxAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] stacks = inventory.getContents();
        for (int i = 0; i < stacks.length; ++i) {
            ItemStack cItem = stacks[i];
            if (cItem == null || cItem.getAmount() >= maxAmount || !cItem.isSimilar(item)) continue;
            return i;
        }
        return -1;
    }

    public static Map<Integer, ItemStack> addAllItems(Inventory inventory, ItemStack ... items) {
        Inventory fakeInventory = Bukkit.getServer().createInventory(null, inventory.getType());
        fakeInventory.setContents(inventory.getContents());
        Map<Integer, ItemStack> overFlow = InventoryWorkaround.addItems(fakeInventory, items);
        if (overFlow.isEmpty()) {
            InventoryWorkaround.addItems(inventory, items);
            return null;
        }
        return InventoryWorkaround.addItems(fakeInventory, items);
    }

    public static Map<Integer, ItemStack> addItems(Inventory inventory, ItemStack ... items) {
        return InventoryWorkaround.addOversizedItems(inventory, 0, items);
    }

    public static Map<Integer, ItemStack> addOversizedItems(Inventory inventory, int oversizedStacks, ItemStack ... items) {
        int i;
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        ItemStack[] combined = new ItemStack[items.length];
        block0: for (i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getAmount() < 1) continue;
            for (int j = 0; j < combined.length; ++j) {
                if (combined[j] == null) {
                    combined[j] = items[i].clone();
                    continue block0;
                }
                if (!combined[j].isSimilar(items[i])) continue;
                combined[j].setAmount(combined[j].getAmount() + items[i].getAmount());
                continue block0;
            }
        }
        block2: for (i = 0; i < combined.length; ++i) {
            ItemStack item = combined[i];
            if (item == null || item.getType() == Material.AIR) continue;
            while (true) {
                int partialAmount;
                int maxAmount;
                int firstPartial;
                if ((firstPartial = InventoryWorkaround.firstPartial(inventory, item, maxAmount = oversizedStacks > item.getType().getMaxStackSize() ? oversizedStacks : item.getType().getMaxStackSize())) == -1) {
                    int firstFree = inventory.firstEmpty();
                    if (firstFree == -1) {
                        leftover.put(i, item);
                        continue block2;
                    }
                    if (item.getAmount() > maxAmount) {
                        ItemStack stack = item.clone();
                        stack.setAmount(maxAmount);
                        inventory.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - maxAmount);
                        continue;
                    }
                    inventory.setItem(firstFree, item);
                    continue block2;
                }
                ItemStack partialItem = inventory.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= maxAmount) {
                    partialItem.setAmount(amount + partialAmount);
                    continue block2;
                }
                partialItem.setAmount(maxAmount);
                item.setAmount(amount + partialAmount - maxAmount);
            }
        }
        return leftover;
    }
}

