/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Locale;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commandnick
extends EssentialsCommand {
    public Commandnick() {
        super("nick");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        if (!this.ess.getSettings().changeDisplayName()) {
            throw new Exception(I18n._("nickDisplayName", new Object[0]));
        }
        if (args.length > 1 && user.isAuthorized("essentials.nick.others")) {
            this.setNickname(server, this.getPlayer(server, user, args, 0), this.formatNickname(user, args[1]));
            user.sendMessage(I18n._("nickChanged", new Object[0]));
        } else {
            this.setNickname(server, user, this.formatNickname(user, args[0]));
        }
    }

    @Override
    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        if (!this.ess.getSettings().changeDisplayName()) {
            throw new Exception(I18n._("nickDisplayName", new Object[0]));
        }
        if ((args[0].equalsIgnoreCase("*") || args[0].equalsIgnoreCase("all")) && args[1].equalsIgnoreCase("off")) {
            this.resetAllNicknames(server);
        } else {
            this.setNickname(server, this.getPlayer(server, args, 0, true, false), this.formatNickname(null, args[1]));
        }
        sender.sendMessage(I18n._("nickChanged", new Object[0]));
    }

    private String formatNickname(User user, String nick) {
        if (user == null) {
            return FormatUtil.replaceFormat(nick);
        }
        return FormatUtil.formatString(user, "essentials.nick", nick);
    }

    private void resetAllNicknames(Server server) {
        for (Player player : server.getOnlinePlayers()) {
            try {
                this.setNickname(server, this.ess.getUser(player), "off");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void setNickname(Server server, User target, String nick) throws Exception {
        if (!nick.matches("^[a-zA-Z_0-9\u00a7]+$")) {
            throw new Exception(I18n._("nickNamesAlpha", new Object[0]));
        }
        if (nick.length() > this.ess.getSettings().getMaxNickLength()) {
            throw new Exception(I18n._("nickTooLong", new Object[0]));
        }
        if (target.getName().equalsIgnoreCase(nick)) {
            target.setNickname(nick);
            target.setDisplayNick();
            target.sendMessage(I18n._("nickNoMore", new Object[0]));
        } else if ("off".equalsIgnoreCase(nick)) {
            target.setNickname(null);
            target.setDisplayNick();
            target.sendMessage(I18n._("nickNoMore", new Object[0]));
        } else {
            for (Player onlinePlayer : server.getOnlinePlayers()) {
                if (target.getBase() == onlinePlayer) continue;
                String displayName = onlinePlayer.getDisplayName().toLowerCase(Locale.ENGLISH);
                String name = onlinePlayer.getName().toLowerCase(Locale.ENGLISH);
                String lowerNick = nick.toLowerCase(Locale.ENGLISH);
                if (!lowerNick.equals(displayName) && !lowerNick.equals(name)) continue;
                throw new Exception(I18n._("nickInUse", new Object[0]));
            }
            target.setNickname(nick);
            target.setDisplayNick();
            target.sendMessage(I18n._("nickSet", target.getDisplayName() + "\u00a77."));
        }
    }
}

