/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commandmsg
extends EssentialsCommand {
    public Commandmsg() {
        super("msg");
    }

    @Override
    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        String senderName;
        if (args.length < 2 || args[0].trim().length() < 2 || args[1].trim().isEmpty()) {
            throw new NotEnoughArgumentsException();
        }
        String message = Commandmsg.getFinalArg(args, 1);
        if (sender instanceof Player) {
            User user = this.ess.getUser(sender);
            if (user.isMuted()) {
                throw new Exception(I18n._("voiceSilenced", new Object[0]));
            }
            message = FormatUtil.formatMessage(user, "essentials.msg", message);
        } else {
            message = FormatUtil.replaceFormat(message);
        }
        String translatedMe = I18n._("me", new Object[0]);
        Console replyTo = sender instanceof Player ? this.ess.getUser((Player)sender) : Console.getConsoleReplyTo();
        String string = senderName = sender instanceof Player ? ((Player)sender).getDisplayName() : "Console";
        if (args[0].equalsIgnoreCase("Console")) {
            sender.sendMessage(I18n._("msgFormat", translatedMe, "Console", message));
            CommandSender cs = Console.getCommandSender(server);
            cs.sendMessage(I18n._("msgFormat", senderName, translatedMe, message));
            replyTo.setReplyTo(cs);
            Console.getConsoleReplyTo().setReplyTo(sender);
            return;
        }
        boolean skipHidden = sender instanceof Player && !this.ess.getUser(sender).isAuthorized("essentials.vanish.interact");
        boolean foundUser = false;
        List matchedPlayers = server.matchPlayer(args[0]);
        for (Player matchPlayer : matchedPlayers) {
            User matchedUser = this.ess.getUser(matchPlayer);
            if (skipHidden && matchedUser.isHidden()) continue;
            foundUser = true;
            if (matchedUser.isAfk()) {
                sender.sendMessage(I18n._("userAFK", matchPlayer.getDisplayName()));
            }
            sender.sendMessage(I18n._("msgFormat", translatedMe, matchPlayer.getDisplayName(), message));
            if (sender instanceof Player && matchedUser.isIgnoredPlayer(this.ess.getUser(sender))) continue;
            matchedUser.sendMessage(I18n._("msgFormat", senderName, translatedMe, message));
            replyTo.setReplyTo((CommandSender)matchPlayer);
            matchedUser.setReplyTo(sender);
        }
        if (!foundUser) {
            throw new PlayerNotFoundException();
        }
    }
}

