/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.IConf;
import com.earth2me.essentials.perm.PermissionsHandler;
import com.earth2me.essentials.register.payment.Methods;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;

public class EssentialsPluginListener
implements Listener,
IConf {
    private final transient IEssentials ess;

    public EssentialsPluginListener(IEssentials ess) {
        this.ess = ess;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginEnable(PluginEnableEvent event) {
        if (event.getPlugin().getName().equals("EssentialsChat")) {
            this.ess.getSettings().setEssentialsChatActive(true);
        }
        this.ess.getPermissionsHandler().checkPermissions();
        this.ess.getAlternativeCommandsHandler().addPlugin(event.getPlugin());
        this.ess.getPaymentMethod();
        if (!Methods.hasMethod()) {
            this.ess.getPaymentMethod();
            if (Methods.setMethod(this.ess.getServer().getPluginManager())) {
                Logger logger = this.ess.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Payment method found (");
                this.ess.getPaymentMethod();
                StringBuilder stringBuilder2 = stringBuilder.append(Methods.getMethod().getLongName()).append(" version: ");
                this.ess.getPaymentMethod();
                logger.log(Level.INFO, stringBuilder2.append(Methods.getMethod().getVersion()).append(")").toString());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginDisable(PluginDisableEvent event) {
        PermissionsHandler permHandler;
        if (event.getPlugin().getName().equals("EssentialsChat")) {
            this.ess.getSettings().setEssentialsChatActive(false);
        }
        if ((permHandler = this.ess.getPermissionsHandler()) != null) {
            permHandler.checkPermissions();
        }
        this.ess.getAlternativeCommandsHandler().removePlugin(event.getPlugin());
        if (this.ess.getPaymentMethod() != null) {
            this.ess.getPaymentMethod();
            if (Methods.hasMethod()) {
                this.ess.getPaymentMethod();
                if (Methods.checkDisabled(event.getPlugin())) {
                    this.ess.getPaymentMethod();
                    Methods.reset();
                    this.ess.getLogger().log(Level.INFO, "Payment method was disabled. No longer accepting payments.");
                }
            }
        }
    }

    @Override
    public void reloadConfig() {
        this.ess.getPermissionsHandler().setUseSuperperms(this.ess.getSettings().useBukkitPermissions());
        this.ess.getPermissionsHandler().checkPermissions();
    }
}

