/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.commands.QuietAbortException;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.potion.PotionEffect;

public class Commandheal
extends EssentialsCommand {
    public Commandheal() {
        super("heal");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length > 0 && user.isAuthorized("essentials.heal.others")) {
            if (args[0].trim().length() < 2) {
                throw new PlayerNotFoundException();
            }
            if (!user.isAuthorized("essentials.heal.cooldown.bypass")) {
                user.healCooldown();
            }
            this.healOtherPlayers(server, (CommandSender)user.getBase(), args[0]);
            return;
        }
        if (!user.isAuthorized("essentials.heal.cooldown.bypass")) {
            user.healCooldown();
        }
        this.healPlayer(user.getBase());
    }

    @Override
    public void run(Server server, CommandSender sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        this.healOtherPlayers(server, sender, args[0]);
    }

    private void healOtherPlayers(Server server, CommandSender sender, String name) throws Exception {
        boolean skipHidden = sender instanceof Player && !this.ess.getUser(sender).isAuthorized("essentials.vanish.interact");
        boolean foundUser = false;
        List matchedPlayers = server.matchPlayer(name);
        for (Player matchPlayer : matchedPlayers) {
            User player = this.ess.getUser(matchPlayer);
            if (skipHidden && player.isHidden()) continue;
            foundUser = true;
            try {
                this.healPlayer(matchPlayer);
                sender.sendMessage(I18n._("healOther", matchPlayer.getDisplayName()));
            }
            catch (QuietAbortException e) {}
        }
        if (!foundUser) {
            throw new PlayerNotFoundException();
        }
    }

    private void healPlayer(Player player) throws Exception {
        if (player.getHealth() == 0.0) {
            throw new Exception(I18n._("healDead", new Object[0]));
        }
        double amount = player.getMaxHealth() - player.getHealth();
        EntityRegainHealthEvent erhe = new EntityRegainHealthEvent((Entity)player, amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
        this.ess.getServer().getPluginManager().callEvent((Event)erhe);
        if (erhe.isCancelled()) {
            throw new QuietAbortException();
        }
        double newAmount = player.getHealth() + erhe.getAmount();
        if (newAmount > player.getMaxHealth()) {
            newAmount = player.getMaxHealth();
        }
        player.setHealth(newAmount);
        player.setFoodLevel(20);
        player.setFireTicks(0);
        player.sendMessage(I18n._("heal", new Object[0]));
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
    }
}

