<?php

namespace Tech\Container;

use Psr\Container\ContainerInterface;

class Container implements ContainerInterface
{
    private array $items;

    public function __construct()
    {
        $this->items[self::class] = $this;
    }

    public function get($key)
    {
        if (!$this->has($key)) {
            throw new NotFoundException(sprintf('%s key not found in the container.', $key));
        }

        return $this->items[$key];
    }

    public function has($key): bool
    {
        return isset($this->items[$key]);
    }

    public function set(&$value, string $key = null): self
    {
        if (gettype($value) !== 'object') {
            throw new InvalidTypeException(sprintf('Cannot set an instance of %s in the container.', gettype($value)));
        }

        $key ??= get_class($value);

        $this->items[$key] = $value;

        return $this;
    }
}