<?php

namespace App;

use ReflectionClass;
use App\Controller\TestController;
use Tech\Container\Container;
use Tech\Http\Foundation\Request;
use Tech\Http\Foundation\Response;
use Tech\Http\Router\Router;

class App
{
    protected Container $contaier;
    protected Request $request;

    public function __invoke(): self
    {
        return $this;
    }

    public function __construct()
    {
        $this->createContainer();
        $this->createRouter();
    }

    protected function createContainer(): void
    {
        if (!isset($this->contaier)) {
            $this->contaier = new Container();
            $this->contaier->set($this);
        }
    }

    protected function createRouter(): void
    {
        if (!$this->contaier->has(Router::class)) {
            $router = (new Router())
                ->get('/test', TestController::class, 'show')
            ;

            $this->contaier->set($router);
        }
    }

    public function run(): void
    {
        $this->request = Request::create();
        $this->contaier->set($this->request);

        /** @var Router $router */
        $router = $this->contaier->get(Router::class);

        $route = $router->resolve($this->request);
        $this->instantiate($route->getController());

        /** @var Response $response */
        $response = $this->callMethod($route->getController(), $route->getAction());
        $response->render();
    }

    public function callMethod(string $className, string $methodName)
    {
        $instance = $this->contaier->has($className) ? $this->contaier->get($className) : $this->instantiate($className);
        $class = new ReflectionClass(get_class($instance));
        $method = $class->getMethod($methodName);

        $parameters = [];
        foreach ($method->getParameters() as $parameter) {
            $parameterClass = $parameter->getClass();

            if ($this->contaier->has($parameterClass->getName())) {
                $parameters[] = $this->contaier->get($parameterClass->getName());
            } else {
                $parameters[] = $this->instantiate($parameterClass->getName());
            }
        }

        return $method->invokeArgs($instance, $parameters);
    }

    public function instantiate(string $className): object
    {
        $class = new ReflectionClass($className);

        if ($class->getConstructor()) {
            $parameters = [];
            foreach ($class->getConstructor()->getParameters() as $parameter) {
                $parameterClass = $parameter->getClass();

                if ($this->contaier->has($parameterClass->getName())) {
                    $parameters[] = $this->contaier->get($parameterClass->getName());
                } else {
                    $parameters[] = $this->instantiate($parameterClass->getName());
                }
            }

            $instance = $class->newInstance($parameters);
        } else {
            $instance = $class->newInstance();
        }

        $this->contaier->set($instance);

        return $instance;
    }
}
