<?php

namespace Tech\Http\Foundation;

use InvalidArgumentException;
use Tech\Http\Constants\Status;

class Response
{
    private int $statusCode;
    private $content;
    private array $headers;

    public function __construct(
        int $statusCode = Status::NO_CONTENT,
        $content = null,
        array $headers = []
    ) {
        $this->statusCode = $statusCode;
        $this->content = $content;
        $this->headers = $headers;
    }

    public function setStatusCode(int $code): self
    {
        if (!in_array($code, Status::all())) {
            throw new InvalidArgumentException('Unsupported HTTP status code provided.');
        }

        $this->statusCode = $code;

        return $this;
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }

    public function setContent($content): self
    {
        $this->content = $content;

        return $this;
    }

    public function getContent()
    {
        return $this->content;
    }

    public function setHeaders(array $headers): self
    {
        $this->headers = $headers;

        return $this;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    public function render(): void
    {
        foreach ($this->headers as $header) {
            header($header, false);
        }

        header('Content-type: application/json', true, $this->statusCode);

        echo json_encode($this->content);
    }
}
