<?php

namespace Tech\Http\Constants;

class Status extends ConstantsList
{
    public const CONTINUE = 100;
    public const SWITCHING_PROTOCOLS = 101;
    public const PROCESSING = 102;
    public const EARLY_HINTS = 103;

    public const OK = 200;
    public const CREATED = 201;
    public const ACCEPTED = 202;
    public const NON_AUTHORITATIVE_INFORMATION = 203;
    public const NO_CONTENT = 204;
    public const RESET_CONTENT = 205;
    public const PARTIAL_CONTENT = 206;
    public const MULTI_STATUS = 207;
    public const ALREADY_REPORTED = 208;
    public const IM_USED = 226;

    public const MULTIPLE_CHOICES = 300;
    public const MOVED_PERMANENTLY = 301;
    public const FOUND = 302;
    public const SEE_OTHER = 303;
    public const NOT_MODIFIED = 304;
    public const USE_PROXY = 305;
    public const SWITCH_PROXY = 306;
    public const TEMPORARY_REDIRECT = 307;
    public const PERMANENT_REDIRECT = 308;

    public const BAD_REQUEST = 400;
    public const UNAUTHORIZED = 401;
    public const PAYMENT_REQUIRED = 402;
    public const FORBIDDEN = 403;
    public const NOT_FOUND = 404;
    public const METHOD_NOT_ALLOWED = 405;
    public const NOT_ACCEPTABLE = 406;
    public const PROXY_AUTHENTICATION_REQUIRED = 407;
    public const REQUEST_TIMEOUT = 408;
    public const CONFLICT = 409;
    public const GONE = 410;
    public const LENGTH_REQUIRED = 411;
    public const PRECONDITION_FAILED = 412;
    public const PAYLOAD_TOO_LARGE = 413;
    public const URI_TOO_LONG = 414;
    public const UNSUPPORTED_MEDIA_TYPE = 415;
    public const RANGE_NOT_SATISFIABLE = 416;
    public const EXPECTATION_FAILED = 417;
    public const IM_A_TEAPOT = 418;
    public const MISDIRECTED_REQUEST = 421;
    public const UNPROCESSABLE_ENTITY = 422;
    public const LOCKED = 423;
    public const FAILED_DEPENDENCY = 424;
    public const TOO_EARLY = 425;
    public const UPGRADE_REQUIRED = 426;
    public const PRECONDITION_REQUIRED = 428;
    public const TOO_MANY_REQUESTS = 429;
    public const REQUEST_HEADER_FIELDS_TOO_LARGE = 431;
    public const UNAVAILABLE_FOR_LEGAL_REASONS = 451;

    public const INTERNAL_SERVER_ERROR = 500;
    public const NOT_IMPLEMENTED = 501;
    public const BAD_GATEWAY = 502;
    public const SERVICE_UNAVAILABLE = 503;
    public const GATEWAY_TIMEOUT = 504;
    public const HTTP_VERSION_NOT_SUPPORTED = 505;
    public const VARIANT_ALSO_NEGOTIATES = 506;
    public const INSUFFICIENT_STORAGE = 507;
    public const LOOP_DETECTED = 508;
    public const NOT_EXTENDED = 510;
    public const NETWORK_AUTHORIZATION_REQUIRED = 511;

    public const MESSAGE = [
        100 => 'Continue.',
        101 => 'Switching protocols.',
        102 => 'Processing.',
        103 => 'Early hints.',

        200 => 'OK.',
        201 => 'Created.',
        202 => 'Accepted.',
        203 => 'Non-authoritative information.',
        204 => 'No content.',
        205 => 'Reset content.',
        206 => 'Partial content.',
        207 => 'Multi-status.',
        208 => 'Already reported.',
        226 => 'IM used.',

        300 => 'Multiple choices.',
        301 => 'Moved permanently.',
        302 => 'Found.',
        303 => 'See other.',
        304 => 'Not modified.',
        305 => 'Use proxy.',
        306 => 'Switch proxy.',
        307 => 'Temporary redirect.',
        308 => 'Permanent redirect.',

        400 => 'Bad request',
        401 => 'Unauthorized.',
        402 => 'Payment required.',
        403 => 'Forbidden.',
        404 => 'Not found.',
        405 => 'Method not allowed.',
        406 => 'Not acceptable.',
        407 => 'Proxy authentication required.',
        408 => 'Request timeout.',
        409 => 'Conflict.',
        410 => 'Gone.',
        411 => 'Length required.',
        412 => 'Precondition failed.',
        413 => 'Payload too large.',
        414 => 'URI too long.',
        415 => 'Unsupported media type.',
        416 => 'Range not satisfiable.',
        417 => 'Expectation failed.',
        418 => 'I\'m a teapot.',
        421 => 'Misdirected request.',
        422 => 'Unprocessable entity.',
        423 => 'Locked.',
        424 => 'Failed dependency.',
        425 => 'Too early.',
        426 => 'Upgrade required.',
        428 => 'Precondition required.',
        429 => 'Too many requests.',
        431 => 'Request header fields too large.',
        451 => 'Unavailable for legal reasons.',

        500 => 'Internal server error.',
        501 => 'Not implemented.',
        502 => 'Bad gateway.',
        503 => 'Service unavailable.',
        504 => 'Gateway timeout.',
        505 => 'HTTP version not supported.',
        506 => 'Variant also negotiates.',
        507 => 'Insufficient storage.',
        508 => 'Loop detected.',
        510 => 'Not extended.',
        511 => 'Network authorization required.',
    ];
}