<?php

namespace Tech\Http\Exception;

use Tech\Http\Constants\Status;

class HttpException extends \RuntimeException
{
    public function __construct(int $code, string $message = '', \Throwable $previous = null)
    {
        if (empty($message)) {
            $message = Status::MESSAGE[$code];
        }

        parent::__construct($message, $code, $previous);
    }
}