<?php

namespace Tech\Annotation;

use ReflectionClass;

class AnnotationRegistry
{
    private array $items;

    public function get(string $key): AnnotationInterface
    {
        if (!$this->has($key)) {
            throw new AnnotationException(sprintf('%s annotation not found in the registry.', $key));
        }

        return $this->items[$key];
    }

    public function has(string $key): bool
    {
        return isset($this->items[$key]);
    }

    public function set(&$value): self
    {
        if (!in_array(AnnotationInterface::class, class_implements($value))) {
            throw new AnnotationException(sprintf(
                'Cannot set %s in annotation registry, as it does not implement AnnotationInterface.',
                get_class($value)
            ));
        }

        $key = (new ReflectionClass(get_class($value)))->getShortName();
        $this->items[$key] = $value;

        return $this;
    }
}
