<?php

namespace Tech\Http\Foundation;

class Request
{
    private string $uri;
    private string $method;
    private array $headers;
    private array $query;
    private array $request;
    private ?string $content;

    public static function create(): Request
    {
        $request = new static;

        $request->uri = $_SERVER['REQUEST_URI'];
        $request->method = $_SERVER['REQUEST_METHOD'];
        $request->headers = getallheaders();
        $request->query = $_GET;
        $request->request = $_POST;
        $request->content = file_get_contents('php://input') ?: null;

        return $request;
    }

    public function getUri(): string
    {
        return $this->uri;
    }

    public function getMethod(): string
    {
        return $this->method;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    public function getQuery(): array
    {
        return $this->query;
    }

    public function getRequest(): array
    {
        return $this->request;
    }

    public function getContent(): ?string
    {
        return $this->content;
    }
}