<?php

namespace App\Controller;

use App\Service\TestService;
use Tech\Annotation\AnnotationReader;
use Tech\Http\Foundation\Response;

class TestController
{
    /**
     * @param TestService $service
     * @return Response
     * @throws \ReflectionException
     * @Annotation()
     * @Route("Router", "modyga")
     */
    public function show(TestService $service)
    {
        AnnotationReader::read(new \ReflectionMethod(get_class($this), 'show'));
        return new Response(200, $service->test());
    }
}
