/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.proxy;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.oredict.OreDictionary;

public class CommonProxy {
    public void addBiome(Collection<WorldType> worldTypes, BiomeGenBase biome) {
        for (WorldType worldType : worldTypes) {
            worldType.addNewBiome(biome);
        }
    }

    public void addGrassPlant(Block block, int metadata, int weight) {
        MinecraftForge.addGrassPlant((Block)block, (int)metadata, (int)weight);
    }

    public void addName(Object object, String name) {
        LanguageRegistry.addName((Object)object, (String)name);
    }

    public void addRecipe(IRecipe recipe) {
        CraftingManager.func_77594_a().func_77592_b().add(recipe);
    }

    public void addSmelting(int itemID, int metadata, ItemStack itemstack, float experience) {
        FurnaceRecipes.func_77602_a().addSmelting(itemID, metadata, itemstack, experience);
    }

    public void addSmelting(ItemStack input, ItemStack output, float experience) {
        this.addSmelting(input.field_77993_c, input.func_77960_j(), output, experience);
    }

    public void addStringLocalization(String key, String lang, String value) {
        LanguageRegistry.instance().addStringLocalization(key, lang, value);
    }

    public int findGlobalUniqueEntityId() {
        return EntityRegistry.findGlobalUniqueEntityId();
    }

    public Logger getFMLLogger() {
        return FMLLog.getLogger();
    }

    public Optional<ItemStack> getGrassSeed(World world) {
        return Optional.fromNullable((Object)ForgeHooks.getGrassSeed((World)world));
    }

    public ArrayList<ItemStack> getOres(String name) {
        return OreDictionary.getOres((String)name);
    }

    public String getStringLocalization(String key) {
        return LanguageRegistry.instance().getStringLocalization(key);
    }

    public boolean isModLoaded(String modID) {
        return Loader.isModLoaded((String)modID);
    }

    public void loadLocalization(String filename, String locale) {
        LanguageRegistry.instance().loadLocalization(filename, locale, true);
    }

    public boolean postEventToBus(Event event) {
        return MinecraftForge.EVENT_BUS.post(event);
    }

    public void registerBlock(Block block) {
        GameRegistry.registerBlock((Block)block);
    }

    public void registerBlock(Block block, Class<? extends ItemBlock> itemclass) {
        GameRegistry.registerBlock((Block)block, itemclass);
    }

    public int registerBlockHandler(ISimpleBlockRenderingHandler handler) {
        return 0;
    }

    public void registerEntity(Class entityClass, String entityName, Object mod, int entityID, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((Class)entityClass, (String)entityName, (int)entityID, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public void registerEntityID(Class entityClass, String entityName, int entityID) {
        EntityRegistry.registerGlobalEntityID((Class)entityClass, (String)entityName, (int)entityID);
    }

    public void registerEventHandler(Object target) {
        MinecraftForge.EVENT_BUS.register(target);
    }

    public void registerFuelHandler(IFuelHandler fuelHandler) {
        GameRegistry.registerFuelHandler((IFuelHandler)((IFuelHandler)Preconditions.checkNotNull((Object)fuelHandler)));
    }

    public void registerOre(int id, Block ore) {
        OreDictionary.registerOre((int)id, (ItemStack)new ItemStack(ore));
    }

    public void registerOre(int id, Item ore) {
        OreDictionary.registerOre((int)id, (ItemStack)new ItemStack(ore));
    }

    public void registerOre(int id, ItemStack ore) {
        OreDictionary.registerOre((int)id, (ItemStack)ore);
    }

    public void registerOre(String name, Block ore) {
        OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(ore));
    }

    public void registerOre(String name, Item ore) {
        OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(ore));
    }

    public void registerOre(String name, ItemStack ore) {
        OreDictionary.registerOre((String)name, (ItemStack)ore);
    }

    public void registerOreInAllSubblocks(String name, Block ore) {
        OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(ore, 1, Short.MAX_VALUE));
    }

    public void registerRenderInformation() {
    }

    public void registerScarecrowRendering() {
    }

    public void registerWorldGenerator(IWorldGenerator worldGenerator) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator);
    }

    public void removeBiome(BiomeGenBase biome) {
        WorldType.field_77137_b.removeBiome((BiomeGenBase)Preconditions.checkNotNull((Object)biome));
        WorldType.field_77135_d.removeBiome(biome);
    }

    public void setBlockHarvestLevel(Block block, String toolClass, int harvestLevel) {
        MinecraftForge.setBlockHarvestLevel((Block)block, (String)toolClass, (int)harvestLevel);
    }

    public void setBurnProperties(int id, int encouragement, int flammability) {
        Block.setBurnProperties((int)id, (int)encouragement, (int)flammability);
    }
}

