/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenFirTree
extends WorldGenerator {
    public WorldGenFirTree(boolean par1) {
        super(par1);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int below = world.func_72798_a(x, y - 1, z);
        int height = rand.nextInt(8) + 24;
        if (!TreeSoilRegistry.isValidSoil(below) || y >= 256 - height - 1) {
            return false;
        }
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        int j = 1 + rand.nextInt(12);
        int l = 2 + rand.nextInt(6);
        for (int i1 = y; i1 <= y + 1 + height; ++i1) {
            if (i1 < 0 || i1 >= 256) {
                return false;
            }
            int k1 = 1;
            k1 = i1 - y < j ? 0 : l;
            for (int x1 = x - k1; x1 <= x + k1; ++x1) {
                for (int z1 = z - k1; z1 <= z + k1; ++z1) {
                    int id = world.func_72798_a(x1, i1, z1);
                    if (Block.field_71973_m[id] == null || Block.field_71973_m[id].isLeaves(world, x1, i1, z1)) continue;
                    return false;
                }
            }
        }
        world.func_94575_c(x, y - 1, z, Block.field_71979_v.field_71990_ca);
        int l1 = rand.nextInt(2);
        int j2 = 1;
        boolean flag1 = false;
        for (int i3 = 0; i3 <= height - j; ++i3) {
            int k3 = y + height - i3;
            for (int i4 = x - l1; i4 <= x + l1; ++i4) {
                int k4 = i4 - x;
                for (int l4 = z - l1; l4 <= z + l1; ++l4) {
                    int i5 = l4 - z;
                    Block block = Block.field_71973_m[world.func_72798_a(i4, k3, l4)];
                    if (Math.abs(k4) == l1 && Math.abs(i5) == l1 && l1 > 0 || block != null && !block.canBeReplacedByLeaves(world, i4, k3, l4)) continue;
                    this.func_76485_a(world, i4, k3, l4, TreeBlock.LEAVES.getID(), TreeBlock.LEAVES.getMetadata());
                }
            }
            if (l1 >= j2) {
                l1 = flag1 ? 1 : 0;
                flag1 = true;
                if (++j2 <= l) continue;
                j2 = l;
                continue;
            }
            ++l1;
        }
        int j3 = rand.nextInt(3);
        for (int l3 = 0; l3 < height - j3; ++l3) {
            int id = world.func_72798_a(x, y + l3, z);
            if (Block.field_71973_m[id] != null && !Block.field_71973_m[id].isLeaves(world, x, y + l3, z)) continue;
            this.func_76485_a(world, x, y + l3, z, TreeBlock.TRUNK.getID(), TreeBlock.TRUNK.getMetadata());
        }
        return true;
    }

    private static enum TreeBlock {
        LEAVES(new ItemStack((Block)Block.field_71952_K, 1, 1)),
        TRUNK(new ItemStack(Block.field_71951_J, 1, 1));

        private ItemStack stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_FIR.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_FIR.get();
            }
            if (Element.LOG_FIR.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_FIR.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(ItemStack stack) {
            this.stack = stack;
        }

        public int getID() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.field_77993_c;
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.func_77960_j();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

