/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.biome;

import extrabiomes.lib.DecorationSettings;
import java.util.Map;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;

class CustomBiomeDecorator
extends BiomeDecorator {
    private CustomBiomeDecorator() {
        super(null);
    }

    private CustomBiomeDecorator(Builder builder) {
        super(builder.biome);
        this.field_76833_y = builder.waterlilyPerChunk;
        this.field_76832_z = builder.treesPerChunk;
        this.field_76802_A = builder.flowersPerChunk;
        this.field_76803_B = builder.grassPerChunk;
        this.field_76804_C = builder.deadBushPerChunk;
        this.field_76798_D = builder.mushroomsPerChunk;
        this.field_76799_E = builder.reedsPerChunk;
        this.field_76800_F = builder.cactiPerChunk;
        this.field_76801_G = builder.sandPerChunk;
        this.field_76805_H = builder.sandPerChunk2;
        this.field_76806_I = builder.clayPerChunk;
        this.field_76807_J = builder.bigMushroomsPerChunk;
    }

    static class Builder {
        private final BiomeGenBase biome;
        private int waterlilyPerChunk = 0;
        private int treesPerChunk = 0;
        private int flowersPerChunk = 2;
        private int grassPerChunk = 1;
        private int deadBushPerChunk = 0;
        private int mushroomsPerChunk = 0;
        private int reedsPerChunk = 0;
        private int cactiPerChunk = 0;
        private int sandPerChunk = 1;
        private int sandPerChunk2 = 3;
        private int clayPerChunk = 1;
        private int bigMushroomsPerChunk = 0;

        Builder(BiomeGenBase biome) {
            this.biome = biome;
        }

        Builder loadSettings(DecorationSettings dec) {
            Map<DecorationSettings.Decoration, Integer> settings = dec.getSettings();
            if (settings.containsKey((Object)DecorationSettings.Decoration.BIGMUSHROOMS)) {
                this.bigMushroomsPerChunk(settings.get((Object)DecorationSettings.Decoration.BIGMUSHROOMS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.CACTI)) {
                this.cactiPerChunk(settings.get((Object)DecorationSettings.Decoration.CACTI));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.CLAY)) {
                this.clayPerChunk(settings.get((Object)DecorationSettings.Decoration.CLAY));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.DEADBUSH)) {
                this.deadBushPerChunk(settings.get((Object)DecorationSettings.Decoration.DEADBUSH));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.FLOWERS)) {
                this.flowersPerChunk(settings.get((Object)DecorationSettings.Decoration.FLOWERS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.GRASS)) {
                this.grassPerChunk(settings.get((Object)DecorationSettings.Decoration.GRASS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.MUSHROOMS)) {
                this.mushroomsPerChunk(settings.get((Object)DecorationSettings.Decoration.MUSHROOMS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.REEDS)) {
                this.reedsPerChunk(settings.get((Object)DecorationSettings.Decoration.REEDS));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.SAND) && settings.containsKey((Object)DecorationSettings.Decoration.SAND2)) {
                this.sandPerChunk(settings.get((Object)DecorationSettings.Decoration.SAND), settings.get((Object)DecorationSettings.Decoration.SAND2));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.TREES)) {
                this.treesPerChunk(settings.get((Object)DecorationSettings.Decoration.TREES));
            }
            if (settings.containsKey((Object)DecorationSettings.Decoration.WATERLILY)) {
                this.waterlilyPerChunk(settings.get((Object)DecorationSettings.Decoration.WATERLILY));
            }
            return this;
        }

        Builder bigMushroomsPerChunk(int val) {
            this.bigMushroomsPerChunk = val;
            return this;
        }

        CustomBiomeDecorator build() {
            return new CustomBiomeDecorator(this);
        }

        Builder cactiPerChunk(int val) {
            this.cactiPerChunk = val;
            return this;
        }

        Builder clayPerChunk(int val) {
            this.clayPerChunk = val;
            return this;
        }

        Builder deadBushPerChunk(int val) {
            this.deadBushPerChunk = val;
            return this;
        }

        Builder flowersPerChunk(int val) {
            this.flowersPerChunk = val;
            return this;
        }

        Builder grassPerChunk(int val) {
            this.grassPerChunk = val;
            return this;
        }

        Builder mushroomsPerChunk(int val) {
            this.mushroomsPerChunk = val;
            return this;
        }

        Builder reedsPerChunk(int val) {
            this.reedsPerChunk = val;
            return this;
        }

        Builder sandPerChunk(int val, int val2) {
            this.sandPerChunk = val;
            this.sandPerChunk2 = val2;
            return this;
        }

        Builder treesPerChunk(int val) {
            this.treesPerChunk = val;
            return this;
        }

        Builder waterlilyPerChunk(int val) {
            this.waterlilyPerChunk = val;
            return this;
        }
    }
}

