/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.input.Keyboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIUtils {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    public static final String CONFIG_FILENAME = "TooManyItems.txt";
    public static final String NBT_FILENAME = "TMI.nbt";
    public static final int SPAWNER_ID = 52;
    public static final int MODE_SURVIVAL = 0;
    public static final int MODE_CREATIVE = 1;
    public static final int MODE_ADVENTURE = 2;
    public static final List<String> EMPTY_NAME = new ArrayList<String>(){
        {
            this.add("");
        }
    };
    public static final Random random = new Random();
    public static List<yd> availableItems = new ArrayList<yd>();

    public static File configFile() {
        return new File(ats.w().x, CONFIG_FILENAME);
    }

    public static File nbtFile() {
        return new File(ats.w().x, NBT_FILENAME);
    }

    public static void loadPreferences(TMIConfig tMIConfig) {
        try {
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            if (file.exists()) {
                String string;
                if (!TMIUtils.nbtFile().exists()) {
                    map.put("favorites", "");
                    for (int i = 0; i < 7; ++i) {
                        map.put("save" + (i + 1), "");
                    }
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(":", 2);
                    if (stringArray.length <= 1 || !map.containsKey(stringArray[0])) continue;
                    map.put(stringArray[0], stringArray[1]);
                }
                bufferedReader.close();
                if (!TMIUtils.nbtFile().exists()) {
                    for (int i = 0; i < tMIConfig.getNumSaves(); ++i) {
                        if (!map.containsKey("save" + (i + 1))) continue;
                        tMIConfig.decodeState(i, map.get("save" + (i + 1)));
                    }
                    System.out.println("Loading old favorites");
                    tMIConfig.decodeFavorites();
                }
            }
            TMIUtils.loadNBTFile(tMIConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void savePreferences(TMIConfig tMIConfig) {
        try {
            TMIUtils.saveNBTFile(tMIConfig);
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (String string : map.keySet()) {
                if (string.matches("favorites|save\\d")) continue;
                printWriter.println(string + ":" + map.get(string));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void saveNBTFile(TMIConfig tMIConfig) {
        try {
            bx bx2;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(TMIUtils.nbtFile()));
            cf cf2 = new cf();
            cf cf3 = new cf();
            List<yd> list = tMIConfig.getFavorites();
            for (yd cf4 : list) {
                bx2 = new bx();
                if (cf4 != null) {
                    cf4.b(bx2);
                }
                cf3.a((ck)bx2);
            }
            cf2.a((ck)cf3);
            for (int i = 0; i < 7; ++i) {
                if (TMIConfig.statesSaved[i]) {
                    yd[] ydArray = tMIConfig.getState(i);
                    bx2 = new cf();
                    for (int j = 0; j < ydArray.length; ++j) {
                        bx bx3 = new bx();
                        if (ydArray[j] != null) {
                            ydArray[j].b(bx3);
                        }
                        bx2.a((ck)bx3);
                    }
                    cf2.a((ck)bx2);
                    continue;
                }
                cf cf4 = new cf();
                cf2.a((ck)cf4);
            }
            TMIPrivateFields.writeTagList.invoke((Object)cf2, dataOutputStream);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void loadNBTFile(TMIConfig tMIConfig) {
        try {
            yd[] ydArray;
            ck ck2;
            File file = TMIUtils.nbtFile();
            if (!file.exists()) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            cf cf2 = new cf();
            TMIPrivateFields.readTagList.invoke((Object)cf2, dataInputStream, 1);
            int n = 0;
            if (cf2.c() > 0) {
                cf cf3 = (cf)cf2.b(0);
                ck2 = tMIConfig.getFavorites();
                ck2.clear();
                for (int i = 0; i < cf3.c(); ++i) {
                    ydArray = (yd[])cf3.b(i);
                    yd yd2 = new yd(0, 1, 0);
                    yd2.c((bx)ydArray);
                    ck2.add(yd2);
                }
            }
            for (int i = 1; i < cf2.c(); ++i) {
                cf cf4;
                n = i - 1;
                ck2 = cf2.b(i);
                if (!(ck2 instanceof cf) || (cf4 = (cf)ck2).c() <= 0 || n >= 7) continue;
                ydArray = tMIConfig.getState(n);
                for (int j = 0; j < cf4.c(); ++j) {
                    ck ck3 = cf4.b(j);
                    if (!(ck3 instanceof bx)) continue;
                    bx bx2 = (bx)ck3;
                    if (bx2.b("id")) {
                        ydArray[j] = new yd(0, 1, 0);
                        ydArray[j].c(bx2);
                        continue;
                    }
                    ydArray[j] = null;
                }
                TMIConfig.statesSaved[n] = true;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void loadItems(TMIConfig tMIConfig) {
        Object object;
        Serializable serializable;
        List<yd> list = availableItems;
        List<yb> list2 = tMIConfig.getEnchantableItems();
        boolean bl = TMIConfig.isMultiplayer();
        list.clear();
        list2.clear();
        try {
            serializable = Class.forName("com.eloraam.redpower.RedPowerBase");
            object = (aqw)((Class)serializable).getDeclaredField("blockMicro").get(null);
            Field field = aqw.class.getDeclaredField("cF");
            TMIItemInfo.setMaxDamageException(field.getInt(object), 32000);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        serializable = new ArrayList();
        block11: for (aqw aqw2 : yb.g) {
            Iterator<String> iterator;
            if (aqw2 == null) continue;
            if (aqw2.cv == TMIItemInfo.addItemOffset(127)) {
                if (!tMIConfig.areDamageVariantsShown()) continue;
                for (Object object2 : ns.a.keySet()) {
                    list.add(new yd(TMIItemInfo.addItemOffset(127), 64, ((Integer)object2).intValue()));
                }
                continue;
            }
            if (aqw2.cv == 52) {
                if (bl) {
                    list.add(new yd(52, 64, 0));
                    continue;
                }
                try {
                    iterator = TMIPrivateFields.getSpawnerEntityIdSet().iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        yd yd2 = new yd(52, 64, n);
                        TMICustomItems.nameStack(yd2, "\u00a7r" + ns.b((int)n) + " Spawner");
                        list.add(yd2);
                    }
                    list.addAll(TMICustomItems.tmiCustomSpawners());
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    list.add(new yd(52, 64, 0));
                }
                continue;
            }
            if (TMIItemInfo.isHidden(aqw2.cv)) continue;
            if (aqw2.c() > 0) {
                list2.add((yb)aqw2);
            }
            if (aqw2.cv < aqw.s.length && aqw.s[aqw2.cv] != null) {
                serializable.clear();
                aqw.s[aqw2.cv].a(aqw2.cv, (wv)null, (List)((Object)serializable));
                if (serializable.size() > 1) {
                    iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        yd yd3 = (yd)iterator.next();
                        yd3.b = yb.g[yd3.d].m();
                        list.add(yd3);
                    }
                    continue;
                }
            }
            iterator = new HashSet();
            int n = tMIConfig.areDamageVariantsShown() ? 15 : 0;
            int n2 = TMIItemInfo.getMaxDamageException(aqw2.cv);
            if (n2 > n) {
                n = n2;
            }
            boolean bl2 = false;
            for (int i = 0; i <= n; ++i) {
                if (aqw2.cv == 43 && i > 0 || aqw2.cv == 44 && i > 5 || aqw2.cv == 59 && (i != 7 || bl) || aqw2.cv == 104 && (i != 7 || bl) || aqw2.cv == 105 && (i != 7 || bl) || aqw2.cv == 115 && (i != 3 || bl) || aqw2.cv == 78 && i > 0 && bl || aqw2.cv == 125 && i > 0 || aqw2.cv == 126 && i > 3) continue;
                yd yd4 = new yd((yb)aqw2, aqw2.m(), i);
                try {
                    mr mr2 = aqw2.h(yd4);
                    String string = aqw2.d(yd4);
                    if (TMIUtils.itemDisplayName(yd4).equals("Unnamed")) {
                        if (i != 0) continue;
                        continue block11;
                    }
                    if (aqw2.cv < aqw.s.length && aqw.s[aqw2.cv] != null) {
                        try {
                            aqw.s[aqw2.cv].a(1, i);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    boolean bl3 = !bl && (aqw2.cv == 99 || aqw2.cv == 100) && i < 16;
                    String string2 = string + "@" + mr2.g();
                    if (((HashSet)((Object)iterator)).contains(string2) && !TMIItemInfo.isShown(aqw2.cv, i) && !bl3) continue;
                    list.add(yd4);
                    ((HashSet)((Object)iterator)).add(string2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            object = TMIItemInfo.potionValues.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                yd yd5 = new yd(TMIItemInfo.addItemOffset(117), 64, n);
                list.add(yd5);
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            if (!tMIConfig.isMultiplayer()) {
                list.addAll(TMICustomItems.tmiCustomPotions());
                list.addAll(TMICustomItems.tmiCustomFireworks());
            }
        }
        TMIUtils.filterItems(null, tMIConfig);
    }

    public static String deaccent(String string) {
        try {
            Class.forName("java.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return string;
        }
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(string2).replaceAll("");
    }

    public static void filterItems(String string, TMIConfig tMIConfig) {
        List<yd> list = availableItems;
        List<yd> list2 = tMIConfig.getItems();
        list2.clear();
        if (string == null || string.equals("")) {
            for (yd yd2 : list) {
                list2.add(yd2);
            }
        } else {
            string = TMIUtils.deaccent(string.toLowerCase());
            for (yd yd3 : list) {
                String string2;
                if (yd3 == null || (string2 = TMIUtils.itemDisplayName(yd3)) == null || !TMIUtils.deaccent(string2.toLowerCase()).contains(string)) continue;
                list2.add(yd3);
            }
        }
    }

    public static void safeReportException(Exception exception) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(".yyyyMMdd.HHmmss");
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(1));
            String string = "tmi" + stringBuffer.toString() + ".txt";
            File file = new File(ats.w().x, string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print("[code]TMI Version: 1.6.2 2013-07-30\n");
            exception.printStackTrace(printWriter);
            printWriter.println("[/code]");
            printWriter.close();
        }
        catch (Exception exception2) {
            System.out.println("Error during safeReportException:");
            exception2.printStackTrace();
        }
    }

    public static List<String> itemDisplayNameMultiline(yd yd2, boolean bl) {
        return TMIUtils.itemDisplayNameMultiline(yd2, bl, false);
    }

    public static List<String> itemDisplayNameMultiline(yd yd2, boolean bl, boolean bl2) {
        Object object;
        if (yd2 == null) {
            return EMPTY_NAME;
        }
        if (bl2) {
            bl = false;
        }
        List<String> list = null;
        if (TMIUtils.isValidItem(yd2)) {
            try {
                object = yd2.a((ue)ats.w().h, bl2);
                list = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list == null || list.size() == 0 || yd2.d == 52 && yd2.e == null) {
            list = new ArrayList<String>();
            list.add(TMIItemInfo.getFallbackName(yd2.d, yd2.j()));
            if (bl2) {
                bl = true;
            }
        }
        if (((String)(object = ((String)list.get(0)).trim())).length() == 0) {
            object = TMIItemInfo.getFallbackName(yd2.d, yd2.j());
            list.set(0, (String)object);
        }
        if (bl && yd2 != null) {
            object = (String)object + " " + yd2.d;
            if (yd2.j() != 0) {
                object = (String)object + " : " + yd2.j();
            }
            list.set(0, (String)object);
        }
        return list;
    }

    public static String itemDisplayName(yd yd2) {
        List<String> list = TMIUtils.itemDisplayNameMultiline(yd2, false);
        return list.get(0);
    }

    public static boolean isValidItem(yd yd2) {
        return yd2 == null || yd2.d >= 0 && yd2.d < yb.g.length && yb.g[yd2.d] != null;
    }

    public static yd getValidItem(yd yd2) {
        if (TMIUtils.isValidItem(yd2)) {
            return yd2;
        }
        return new yd(yb.g[52]);
    }

    public static String getValidItemDisplayName(yd yd2) {
        if (TMIUtils.isValidItem(yd2)) {
            return TMIUtils.itemDisplayName(yd2);
        }
        return "Undefined Item";
    }

    public static void setHeldItem(yd yd2) {
        TMIUtils.getPlayer().bn.b(yd2);
        ats.w().h.bn.b(yd2);
    }

    public static void deleteHeldItem() {
        TMIUtils.setHeldItem(null);
    }

    public static yd getHeldItem() {
        return ats.w().h.bn.o();
    }

    public static void giveStack(yd yd2, TMIConfig tMIConfig) {
        TMIUtils.giveStack(yd2, tMIConfig, yd2.b);
    }

    public static void giveStack(yd yd2, TMIConfig tMIConfig, int n) {
        yd yd3 = TMIUtils.copyStack(yd2);
        yd3.b = n;
        ats ats2 = ats.w();
        if (TMIConfig.isMultiplayer()) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(false);
            MessageFormat messageFormat = new MessageFormat(tMIConfig.getSettings().get("give-command"));
            messageFormat.setFormatByArgumentIndex(1, numberFormat);
            messageFormat.setFormatByArgumentIndex(2, numberFormat);
            messageFormat.setFormatByArgumentIndex(3, numberFormat);
            Object[] objectArray = new Object[]{ats2.h.bu, yd3.d, yd3.b, yd3.j()};
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(messageFormat.format(objectArray));
            for (int[] nArray : TMIUtils.getEnchantments(yd3)) {
                stringBuilder.append(" ");
                stringBuilder.append(nArray[0]);
                stringBuilder.append(":");
                stringBuilder.append(nArray[1]);
            }
            ats2.h.b(stringBuilder.toString());
        } else {
            TMIUtils.getPlayer().bn.a(yd3);
        }
    }

    public static yd copyStack(yd yd2) {
        return yd2 == null ? null : yd2.m();
    }

    public static void updateUnlimitedItems() {
        try {
            if (TMIConfig.isMultiplayer() || !TMIConfig.getInstance().isEnabled()) {
                return;
            }
            for (yd yd2 : TMIUtils.getPlayer().bn.a) {
                bx bx2;
                if (yd2 == null || yd2.e == null || !yd2.e.b("TooManyItems") || !(bx2 = yd2.e.l("TooManyItems")).b("Unlimited")) continue;
                if (TMIConfig.isTool(yd2.d)) {
                    yd2.b(0);
                    continue;
                }
                int n = TMIUtils.maxStackSize(yd2.d);
                if (n == 1) {
                    n = 64;
                }
                yd2.b = n;
            }
            yd yd3 = TMIUtils.getHeldItem();
            if (yd3 != null && yd3.b > 64) {
                yd3.b = -1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setStackDamage(yd yd2, int n) {
        try {
            TMIPrivateFields.stackDamage.setInt(yd2, n);
        }
        catch (Exception exception) {
            System.out.println("[TMI] Error setting stack damage");
            exception.printStackTrace();
        }
    }

    public static void deleteInventory() {
        List list = TMIUtils.getPlayer().bp.c;
        for (int i = 0; i < list.size(); ++i) {
            wd wd2 = (wd)list.get(i);
            if (wd2 == null) continue;
            wd2.c((yd)null);
        }
    }

    public static void deleteItemsOfType(yd yd2, awv awv2) {
        List list = TMIUtils.getPlayer().bp.c;
        for (int i = 0; i < list.size(); ++i) {
            yd yd3;
            wd wd2 = (wd)list.get(i);
            if (wd2 == null || (yd3 = wd2.d()) == null || yd3.d != yd2.d || yd3.j() != yd2.j()) continue;
            wd2.c((yd)null);
        }
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
    }

    public static int getGameMode() {
        try {
            return ((acd)TMIPrivateFields.gameMode.get(ats.w().c)).a();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
            return 0;
        }
    }

    public static void setGameMode(int n) {
        if (TMIConfig.isMultiplayer()) {
            ats.w().h.b("/gamemode " + n);
        } else {
            TMIUtils.getPlayer().a(acd.a((int)n));
        }
    }

    public static boolean isCreativeMode() {
        return ats.w().c.h();
    }

    public static void setCreativeMode(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            ats.w().h.b("/gamemode " + (bl ? "1" : "0"));
        } else {
            TMIUtils.getPlayer().a(bl ? acd.c : acd.b);
        }
    }

    public static boolean isCreativeSearchTab() {
        return false;
    }

    public static boolean isRaining() {
        return ats.w().f.x.p();
    }

    public static void setRaining(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            ats.w().h.b("/toggledownfall");
        } else {
            MinecraftServer.F().b[0].x.b(bl);
            MinecraftServer.F().b[0].x.g(bl ? 18000 : 180000);
        }
    }

    public static long getTime() {
        return ats.w().f.x.g();
    }

    public static void setTime(long l) {
        if (TMIConfig.isMultiplayer()) {
            ats.w().h.b("/time set " + l);
        } else {
            MinecraftServer.F().b[0].b(l);
        }
    }

    public static void setHourForward(int n) {
        long l = TMIUtils.getTime() / 24000L * 24000L;
        long l2 = l + 24000L + (long)(n * 1000);
        TMIUtils.setTime(l2);
    }

    public static void logWithTrace(String string) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static void logWithTrace(String string, int n) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length && i < n; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static boolean playerIsAlive() {
        return !ats.w().h.M;
    }

    public static void setPlayerHealth(float f) {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().g(f);
        }
    }

    public static void fillHunger() {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().bq.a(20);
            TMIUtils.getPlayer().bq.b(5.0f);
        }
    }

    public static void incrementDifficulty() {
        ats.w().u.a(auk.l, 1);
    }

    public static String getDifficultyString() {
        return ats.w().u.c(auk.l);
    }

    public static void suppressAchievementNotice() {
        try {
            for (Field field : ats.w().q.getClass().getDeclaredFields()) {
                if (!field.getName().equals("_gui_achievement_time")) continue;
                field.setAccessible(true);
                field.setInt(ats.w().q, 0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static int maxStackSize(int n) {
        return yb.g[n].m();
    }

    public static List<int[]> getEnchantments(yd yd2) {
        cf cf2;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (yd2 != null && (cf2 = yd2.r()) != null) {
            for (int i = 0; i < cf2.c(); ++i) {
                short s = ((bx)cf2.b(i)).d("id");
                short s2 = ((bx)cf2.b(i)).d("lvl");
                int[] nArray = new int[]{s, s2};
                arrayList.add(nArray);
            }
        }
        return arrayList;
    }

    public static boolean addEnchantment(yd yd2, int n, int n2) {
        if (n < aat.b.length && aat.b[n] != null) {
            yd2.a(aat.b[n], n2);
            return true;
        }
        return false;
    }

    public static bx getTagCompoundWithCreate(yd yd2, String string) {
        bx bx2;
        if (yd2.e == null) {
            yd2.e = new bx();
        }
        if (!yd2.e.b(string)) {
            bx2 = new bx();
            yd2.e.a(string, bx2);
        } else {
            bx2 = yd2.e.l(string);
        }
        return bx2;
    }

    public static ju getPlayer() {
        return MinecraftServer.F().af().f(ats.w().h.bu);
    }

    public static void fastTransfer(int n, int n2, ux ux2) {
        ats ats2 = ats.w();
        yd yd2 = TMIUtils.getHeldItem();
        ats2.c.a(ux2.d, n, n2, 0, (ue)ats2.h);
        int n3 = ux2.c.size() - 36;
        boolean bl = n < n3;
        int n4 = 0;
        int n5 = n3;
        int n6 = n3 - 1;
        int n7 = ux2.c.size();
        if (bl) {
            n4 = n3;
            n5 = ux2.c.size();
            n6 = -1;
            n7 = n3;
        }
        boolean bl2 = true;
        while (n4 < n5 && n6 < n7) {
            yd yd3;
            wd wd2 = (wd)ux2.c.get(n4);
            if (wd2 != null && (yd3 = wd2.d()) != null && yd3.d == yd2.d && yd3.j() == yd2.j()) {
                wd wd3 = bl2 ? (wd)ux2.c.get(n) : (wd)ux2.c.get(n6);
                if (wd3 == null) {
                    ++n6;
                    bl2 = false;
                    continue;
                }
                yd yd4 = wd3.d();
                if (yd4 == null) {
                    wd3.c(yd3);
                    wd2.c((yd)null);
                } else if (yd4.d == yd3.d && yd4.j() == yd3.j()) {
                    int n8 = yd3.b + yd4.b;
                    int n9 = yb.g[yd3.d].m();
                    int n10 = n8 - n9;
                    if (n10 > 0) {
                        yd4.b = n9;
                        yd3.b = n10;
                        ++n6;
                        bl2 = false;
                        continue;
                    }
                    yd4.b = n8;
                    wd2.c((yd)null);
                } else {
                    ++n6;
                    bl2 = false;
                    continue;
                }
            }
            ++n4;
        }
    }

    public static boolean isEnchantmentNormallyPossible(aat aat2, yb yb2) {
        return aat2.A.a(yb2) || yb2.cv == TMIItemInfo.addItemOffset(147);
    }

    public static boolean isEnchantmentNormallyPossible(aat aat2, yd yd2) {
        return aat2.A.a(yb.g[yd2.d]) || yd2.d == TMIItemInfo.addItemOffset(147);
    }

    public static List<aat> getPossibleEnchantments(yb yb2) {
        if (yb2.c() > 0) {
            ArrayList<aat> arrayList = new ArrayList<aat>();
            for (aat aat2 : aat.b) {
                if (aat2 == null || !aat2.A.a(yb2)) continue;
                arrayList.add(aat2);
            }
            return arrayList;
        }
        return new ArrayList<aat>();
    }

    public static void dumpItemList() {
        try {
            File file = new File(ats.w().x, "TMIItemList.txt");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (yd yd2 : TMIConfig.getInstance().getItems()) {
                printWriter.println("" + yd2.d + ":" + yd2.j() + " " + TMIUtils.getValidItemDisplayName(yd2));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }
}

