/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.updater;

public class ReleaseVersion
implements Comparable<ReleaseVersion> {
    private int _major;
    private int _minor;
    private int _patch;
    private int _rc;
    private int _beta;

    public ReleaseVersion(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0);
    }

    public ReleaseVersion(int n, int n2, int n3, int n4, int n5) {
        this._major = n;
        this._minor = n2;
        this._patch = n3;
        this._rc = n4;
        this._beta = n5;
    }

    public static ReleaseVersion parse(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string2 = string;
        String[] stringArray = string2.split("RC");
        if (stringArray.length > 1) {
            n4 = Integer.parseInt(stringArray[1]);
            string2 = stringArray[0];
        }
        if ((stringArray = string2.split("B")).length > 1) {
            n5 = Integer.parseInt(stringArray[1]);
            string2 = stringArray[0];
        }
        stringArray = string2.split("\\.");
        n = Integer.parseInt(stringArray[0]);
        n2 = Integer.parseInt(stringArray[1]);
        n3 = Integer.parseInt(stringArray[2]);
        return new ReleaseVersion(n, n2, n3, n4, n5);
    }

    public int major() {
        return this._major;
    }

    public int minor() {
        return this._minor;
    }

    public int patch() {
        return this._patch;
    }

    public int rc() {
        return this._rc;
    }

    public int beta() {
        return this._beta;
    }

    public boolean isStable() {
        return this._rc == 0 && this._beta == 0;
    }

    public boolean isRC() {
        return this._rc > 0;
    }

    public boolean isBeta() {
        return this._beta > 0;
    }

    @Override
    public int compareTo(ReleaseVersion releaseVersion) {
        if (this.major() != releaseVersion.major()) {
            return this.major() < releaseVersion.major() ? -1 : 1;
        }
        if (this.minor() != releaseVersion.minor()) {
            return this.minor() < releaseVersion.minor() ? -1 : 1;
        }
        if (this.patch() != releaseVersion.patch()) {
            return this.patch() < releaseVersion.patch() ? -1 : 1;
        }
        if (this.isStable() && !releaseVersion.isStable()) {
            return 1;
        }
        if (this.isRC() && releaseVersion.isBeta()) {
            return 1;
        }
        if (!this.isStable() && releaseVersion.isStable()) {
            return -1;
        }
        if (this.isBeta() && releaseVersion.isRC()) {
            return -1;
        }
        if (this.rc() != releaseVersion.rc()) {
            return this.rc() < releaseVersion.rc() ? -1 : 1;
        }
        if (this.beta() != releaseVersion.beta()) {
            return this.beta() < releaseVersion.beta() ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        String string = this._major + "." + this._minor + "." + this._patch;
        if (this._rc != 0) {
            string = string + "RC" + this._rc;
        }
        if (this._beta != 0) {
            string = string + "B" + this._beta;
        }
        return string;
    }
}

