/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.event.PaintEvent;
import ic2.api.event.RetextureEvent;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityWall;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockRare;
import ic2.core.util.Util;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;

public class BlockWall
extends BlockMultiID {
    public BlockWall(Configuration config, InternalName internalName) {
        super(config, internalName, Material.field_76246_e, ItemBlockRare.class);
        this.func_71848_c(3.0f);
        this.func_71894_b(30.0f);
        this.func_71884_a(field_71976_h);
        Ic2Items.constructionFoamWall = new ItemStack((Block)this);
        this.func_71849_a(null);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public String getTextureFolder() {
        return "cf";
    }

    @Override
    public String getTextureName(int index) {
        if (index >= 0 && index <= 15) {
            return InternalName.blockWall.name() + "." + Util.getColorName(index).name();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        TileEntity te = iBlockAccess.func_72796_p(x, y, z);
        if (te instanceof TileEntityWall) {
            Block referencedBlock;
            TileEntityWall wall = (TileEntityWall)te;
            if (wall.retextureRefId != null && wall.retextureRefId[side] != 0 && wall.retextureRefMeta != null && wall.retextureRefSide != null && (referencedBlock = Block.field_71973_m[wall.retextureRefId[side]]) != null) {
                try {
                    return referencedBlock.func_71858_a(wall.retextureRefSide[side], wall.retextureRefMeta[side]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return super.func_71895_b(iBlockAccess, x, y, z, side);
    }

    public int func_71925_a(Random r) {
        return 0;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityWall();
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int color) {
        if ((color = BlockColored.func_72239_d((int)color)) != world.func_72805_g(x, y, z)) {
            world.func_72921_c(x, y, z, color, 3);
            return true;
        }
        return false;
    }

    @ForgeSubscribe
    public void onPaint(PaintEvent event) {
        if (event.world.func_72798_a(event.x, event.y, event.z) != this.field_71990_ca) {
            return;
        }
        if (event.color != event.world.func_72805_g(event.x, event.y, event.z)) {
            event.world.func_72921_c(event.x, event.y, event.z, event.color, 3);
            event.painted = true;
        }
    }

    public ItemStack func_71880_c_(int i) {
        return null;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return Ic2Items.constructionFoam.func_77946_l();
    }

    @ForgeSubscribe
    public void onRetexture(RetextureEvent event) {
        TileEntity te = event.world.func_72796_p(event.x, event.y, event.z);
        if (te instanceof TileEntityWall && ((TileEntityWall)te).retexture(event.side, event.referencedBlockId, event.referencedMeta, event.referencedSide)) {
            event.applied = true;
        }
    }
}

