/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Api;
import extrabiomes.api.events.GetBiomeIDEvent;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.summa.worldgen.LegendOakGenerator;
import extrabiomes.module.summa.worldgen.MarshGenerator;
import extrabiomes.module.summa.worldgen.MountainDesertGenerator;
import extrabiomes.module.summa.worldgen.MountainRidgeGenerator;
import extrabiomes.module.summa.worldgen.VanillaFloraGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.ForgeSubscribe;

public enum BiomeHandler {
    INSTANCE;

    private static List<BiomeGenBase> biomes;

    public static void enableBiomes() {
        Set<WorldType> worldTypes = BiomeHelper.discoverWorldTypes();
        for (BiomeSettings setting : BiomeSettings.values()) {
            Optional<? extends BiomeGenBase> biome = setting.getBiome();
            if (!setting.isVanilla()) {
                if (setting.isEnabled() && biome.isPresent()) {
                    BiomeHelper.enableBiome(worldTypes, (BiomeGenBase)biome.get());
                } else {
                    LogHelper.fine("Custom biome %s disabled.", setting.toString());
                }
            } else if (!setting.isEnabled()) {
                Extrabiomes.proxy.removeBiome(BiomeHelper.settingToBiomeGenBase(setting));
                LogHelper.fine("Vanilla biome %s disabled.", biome.toString());
            }
            if (!setting.allowVillages() || !biome.isPresent()) continue;
            BiomeManager.addVillageBiome((BiomeGenBase)((BiomeGenBase)biome.get()), (boolean)true);
            LogHelper.fine("Village spawning enabled for custom biome %s.", setting.toString());
        }
    }

    public static void init() throws Exception {
        for (BiomeSettings biome : BiomeSettings.values()) {
            if (biome.getID() <= 0) continue;
            BiomeHelper.createBiome(biome);
        }
        Api.getExtrabiomesXLEventBus().register((Object)INSTANCE);
    }

    public static void registerWorldGenerators() {
        if (BiomeSettings.MARSH.getBiome().isPresent()) {
            Extrabiomes.proxy.registerWorldGenerator(new MarshGenerator());
        }
        if (BiomeSettings.MOUNTAINDESERT.getBiome().isPresent()) {
            Extrabiomes.proxy.registerWorldGenerator(new MountainDesertGenerator());
        }
        if (BiomeSettings.MOUNTAINRIDGE.getBiome().isPresent()) {
            Extrabiomes.proxy.registerWorldGenerator(new MountainRidgeGenerator());
        }
        Extrabiomes.proxy.registerWorldGenerator(new VanillaFloraGenerator());
        Extrabiomes.proxy.registerWorldGenerator(new LegendOakGenerator());
    }

    @ForgeSubscribe
    public void handleBiomeIDRequestsFromAPI(GetBiomeIDEvent event) {
        Optional settings = Optional.fromNullable((Object)((Object)BiomeSettings.valueOf(event.targetBiome.toUpperCase())));
        if (settings.isPresent()) {
            event.biomeID = ((BiomeSettings)((Object)settings.get())).getID();
        }
    }

    static {
        biomes = new ArrayList<BiomeGenBase>();
    }
}

