/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extrabiomes.Extrabiomes;
import extrabiomes.api.BiomeManager;
import extrabiomes.proxy.CommonProxy;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockCustomFlower
extends Block
implements IPlantable {
    private Icon autumnShrub;
    private Icon hydrangea;
    private Icon orange;
    private Icon purple;
    private Icon tinyCactus;
    private Icon root;
    private Icon toadstool;
    private Icon white;

    public BlockCustomFlower(int id, int index, Material material) {
        super(id, material);
        float var4 = 0.2f;
        this.func_71905_a(0.3f, 0.0f, 0.3f, 0.7f, 0.6f, 0.7f);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.addGrassPlant(this, BlockType.AUTUMN_SHRUB.metadata(), 2);
        proxy.addGrassPlant(this, BlockType.HYDRANGEA.metadata(), 2);
        proxy.addGrassPlant(this, BlockType.ORANGE.metadata(), 5);
        proxy.addGrassPlant(this, BlockType.PURPLE.metadata(), 5);
        proxy.addGrassPlant(this, BlockType.WHITE.metadata(), 5);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.autumnShrub = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "autumnshrub");
        this.hydrangea = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "hydrangea");
        this.orange = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "orangeflowers");
        this.purple = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "purpleflowers");
        this.tinyCactus = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "tinycactus");
        this.root = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "root");
        this.toadstool = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "toadstools");
        this.white = iconRegister.func_94245_a(Extrabiomes.TEXTURE_PATH + "whiteflowers");
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && this.canThisPlantGrowOnThisBlockID(world.func_72798_a(x, y - 1, z));
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        return super.func_71930_b(world, x, y, z) && this.canThisPlantGrowOnThisBlockID(world.func_72798_a(x, y - 1, z));
    }

    private boolean canThisPlantGrowOnThisBlockID(int id) {
        return id == Block.field_71980_u.field_71990_ca || id == Block.field_71979_v.field_71990_ca || id == Block.field_72050_aA.field_71990_ca || id == Block.field_71939_E.field_71990_ca || (byte)id == ((BiomeGenBase)BiomeManager.mountainridge.get()).field_76752_A;
    }

    private void checkFlowerChange(World world, int x, int y, int z) {
        if (!this.func_71854_d(world, x, y, z)) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_94575_c(x, y, z, 0);
        }
    }

    public int func_71899_b(int metadata) {
        return metadata;
    }

    public Icon func_71858_a(int side, int metadata) {
        if (metadata > 7) {
            metadata = 7;
        }
        switch (metadata) {
            case 0: {
                return this.autumnShrub;
            }
            case 1: {
                return this.hydrangea;
            }
            case 2: {
                return this.orange;
            }
            case 3: {
                return this.purple;
            }
            case 4: {
                return this.tinyCactus;
            }
            case 5: {
                return this.root;
            }
            case 6: {
                return this.toadstool;
            }
            case 7: {
                return this.white;
            }
        }
        return this.autumnShrub;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    public int getPlantID(World world, int x, int y, int z) {
        return this.field_71990_ca;
    }

    public int getPlantMetadata(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == BlockType.TINY_CACTUS.metadata()) {
            return EnumPlantType.Desert;
        }
        return EnumPlantType.Plains;
    }

    public int func_71857_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == BlockType.TINY_CACTUS.metadata()) {
            return super.func_71911_a_(world, x, y, z);
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)y + this.field_72022_cl, (double)(z + 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List itemList) {
        for (BlockType type : BlockType.values()) {
            itemList.add(new ItemStack((Block)this, 1, type.metadata()));
        }
    }

    public boolean func_71926_d() {
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        this.checkFlowerChange(world, x, y, z);
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        this.checkFlowerChange(world, x, y, z);
    }

    public static enum BlockType {
        AUTUMN_SHRUB(0),
        HYDRANGEA(1),
        ORANGE(2),
        PURPLE(3),
        TINY_CACTUS(4),
        ROOT(5),
        TOADSTOOL(6),
        WHITE(7);

        private final int metadata;

        private BlockType(int metadata) {
            this.metadata = metadata;
        }

        public int metadata() {
            return this.metadata;
        }
    }
}

