/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.biomes;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import extrabiomes.api.BiomeManager;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.summa.biome.WeightedRandomChooser;
import extrabiomes.module.summa.biome.WeightedWorldGenerator;
import extrabiomes.module.summa.worldgen.WorldGenAcacia;
import extrabiomes.module.summa.worldgen.WorldGenAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenBigAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenCustomSwamp;
import extrabiomes.module.summa.worldgen.WorldGenFirTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTreeHuge;
import extrabiomes.module.summa.worldgen.WorldGenRedwood;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenHugeTrees;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeManagerImpl
extends BiomeManager {
    private static final WorldGenerator ACACIA_TREE_GEN = new WorldGenAcacia(false);
    private static final WorldGenerator ALT_TAIGA_GEN = new WorldGenTaiga2(false);
    private static final WorldGenerator BIG_FIR_TREE_GEN = new WorldGenFirTreeHuge(false);
    private static final WorldGenerator BIG_OAK_TREE_GEN = new WorldGenBigTree(false);
    private static final WorldGenerator BIRCH_TREE_GEN = new WorldGenForest(false);
    private static final WorldGenerator CUSTOM_SWAMP_TREE_GEN = new WorldGenCustomSwamp();
    private static final WorldGenerator FERN_GEN = new WorldGenTallGrass(Block.field_71962_X.field_71990_ca, 2);
    private static final WorldGenerator FIR_TREE_GEN = new WorldGenFirTree(false);
    private static final WorldGenerator GRASS_GEN = new WorldGenTallGrass(Block.field_71962_X.field_71990_ca, 1);
    private static final WorldGenerator OAK_TREE_GEN = new WorldGenTrees(false);
    private static final WorldGenerator REDWOOD_TREE_GEN = new WorldGenRedwood(false);
    private static final WorldGenerator SHRUB_GEN = new WorldGenShrub(3, 0);
    private static final WorldGenerator SWAMP_TREE_GEN = new WorldGenSwamp();
    private static final WorldGenerator TAIGA_GEN = new WorldGenTaiga1();
    private static final Collection<BiomeGenBase> disableDefaultGrassBiomes = new ArrayList<BiomeGenBase>();
    private static final Map<BiomeManager.GenType, Multimap<BiomeGenBase, WeightedWorldGenerator>> weightedChoices = new EnumMap<BiomeManager.GenType, Multimap<BiomeGenBase, WeightedWorldGenerator>>(BiomeManager.GenType.class);

    private static void addAlpineTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), FIR_TREE_GEN, 100);
    }

    private static void addAutumnTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.BROWN), 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.BROWN), 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.ORANGE), 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.ORANGE), 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.PURPLE), 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.PURPLE), 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.YELLOW), 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.YELLOW), 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), BIG_OAK_TREE_GEN, 10);
    }

    private static void addBirchForestTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), OAK_TREE_GEN, 99);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), BIG_OAK_TREE_GEN, 1);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), BIRCH_TREE_GEN, 9900);
    }

    private static void addDefaultTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), BIG_OAK_TREE_GEN, 10);
    }

    private static void addExtremeJungleTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), BIG_OAK_TREE_GEN, 2);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), SHRUB_GEN, 9);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenerator(){

            public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
                WorldGenHugeTrees worldGen = new WorldGenHugeTrees(false, 10 + rand.nextInt(20), 3, 3);
                return worldGen.func_76484_a(world, rand, x, y, z);
            }
        }, 3);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenerator(){

            public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
                WorldGenTrees worldGen = new WorldGenTrees(false, 4 + rand.nextInt(7), 3, 3, true);
                return worldGen.func_76484_a(world, rand, x, y, z);
            }
        }, 6);
    }

    private static void addGrass(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        if (!disableDefaultGrassBiomes.contains(biome.get())) {
            BiomeManagerImpl.addWeightedGrassGenForBiome((BiomeGenBase)biome.get(), GRASS_GEN, 100);
        }
    }

    private static void addGrassandFerns(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedGrassGenForBiome((BiomeGenBase)biome.get(), FERN_GEN, 25);
        BiomeManagerImpl.addWeightedGrassGenForBiome((BiomeGenBase)biome.get(), GRASS_GEN, 75);
    }

    private static void addGreenSwampTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), SWAMP_TREE_GEN, 20);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), CUSTOM_SWAMP_TREE_GEN, 80);
    }

    private static void addMiniJungleTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), SWAMP_TREE_GEN, 100);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), OAK_TREE_GEN, 1);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), BIG_OAK_TREE_GEN, 99);
    }

    private static void addRainforestTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), BIRCH_TREE_GEN, 2);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), BIG_OAK_TREE_GEN, 49999);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), OAK_TREE_GEN, 149997);
    }

    private static void addRedwoodForestTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), REDWOOD_TREE_GEN, 100);
    }

    private static void addRedwoodLushTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), REDWOOD_TREE_GEN, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), FIR_TREE_GEN, 50);
    }

    private static void addSavannaTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), ACACIA_TREE_GEN, 100);
    }

    private static void addShrublandTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenerator(){

            public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
                WorldGenShrub worldGen = new WorldGenShrub(3, rand.nextInt(3));
                return worldGen.func_76484_a(world, rand, x, y, z);
            }
        }, 200);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), new WorldGenerator(){

            public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
                return false;
            }
        }, 100);
    }

    private static void addTaigaTrees(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), TAIGA_GEN, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), ALT_TAIGA_GEN, 100);
    }

    private static void addTemporateRainforest(Optional<? extends BiomeGenBase> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), BIG_FIR_TREE_GEN, 200);
        BiomeManagerImpl.addWeightedTreeGenForBiome((BiomeGenBase)biome.get(), FIR_TREE_GEN, 100);
    }

    private static void buildWeightedBiomeGrassList() {
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)alpine);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)autumnwoods);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)birchforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends BiomeGenBase>)extremejungle);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)forestedhills);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)forestedisland);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)glacier);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)greenhills);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)greenswamp);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)icewasteland);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)marsh);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)meadow);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends BiomeGenBase>)minijungle);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)mountaindesert);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)mountainridge);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)mountaintaiga);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)pineforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends BiomeGenBase>)rainforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends BiomeGenBase>)redwoodforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends BiomeGenBase>)redwoodlush);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)savanna);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)shrubland);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)snowforest);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)snowyrainforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends BiomeGenBase>)temperaterainforest);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)tundra);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)wasteland);
        BiomeManagerImpl.addGrass((Optional<? extends BiomeGenBase>)woodlands);
    }

    private static void buildWeightedBiomeTreeList() {
        BiomeManagerImpl.addAlpineTrees((Optional<? extends BiomeGenBase>)alpine);
        BiomeManagerImpl.addAutumnTrees((Optional<? extends BiomeGenBase>)autumnwoods);
        BiomeManagerImpl.addBirchForestTrees((Optional<? extends BiomeGenBase>)birchforest);
        BiomeManagerImpl.addExtremeJungleTrees((Optional<? extends BiomeGenBase>)extremejungle);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)forestedhills);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)forestedisland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)glacier);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)greenhills);
        BiomeManagerImpl.addGreenSwampTrees((Optional<? extends BiomeGenBase>)greenswamp);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)icewasteland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)marsh);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)meadow);
        BiomeManagerImpl.addMiniJungleTrees((Optional<? extends BiomeGenBase>)minijungle);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)mountaindesert);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)mountainridge);
        BiomeManagerImpl.addTaigaTrees((Optional<? extends BiomeGenBase>)mountaintaiga);
        BiomeManagerImpl.addTaigaTrees((Optional<? extends BiomeGenBase>)pineforest);
        BiomeManagerImpl.addRainforestTrees((Optional<? extends BiomeGenBase>)rainforest);
        BiomeManagerImpl.addRedwoodForestTrees((Optional<? extends BiomeGenBase>)redwoodforest);
        BiomeManagerImpl.addRedwoodLushTrees((Optional<? extends BiomeGenBase>)redwoodlush);
        BiomeManagerImpl.addSavannaTrees((Optional<? extends BiomeGenBase>)savanna);
        BiomeManagerImpl.addShrublandTrees((Optional<? extends BiomeGenBase>)shrubland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)snowforest);
        BiomeManagerImpl.addTemporateRainforest((Optional<? extends BiomeGenBase>)snowyrainforest);
        BiomeManagerImpl.addTemporateRainforest((Optional<? extends BiomeGenBase>)temperaterainforest);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)tundra);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)wasteland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends BiomeGenBase>)woodlands);
    }

    public static void disableDefaultGrassforBiomes(Collection<BiomeGenBase> biomes) {
        disableDefaultGrassBiomes.addAll(biomes);
    }

    public static void populateAPIBiomes() {
        alpine = BiomeSettings.ALPINE.getBiome();
        autumnwoods = BiomeSettings.AUTUMNWOODS.getBiome();
        birchforest = BiomeSettings.BIRCHFOREST.getBiome();
        extremejungle = BiomeSettings.EXTREMEJUNGLE.getBiome();
        forestedhills = BiomeSettings.FORESTEDHILLS.getBiome();
        forestedisland = BiomeSettings.FORESTEDISLAND.getBiome();
        glacier = BiomeSettings.GLACIER.getBiome();
        greenhills = BiomeSettings.GREENHILLS.getBiome();
        greenswamp = BiomeSettings.GREENSWAMP.getBiome();
        icewasteland = BiomeSettings.ICEWASTELAND.getBiome();
        marsh = BiomeSettings.MARSH.getBiome();
        meadow = BiomeSettings.MEADOW.getBiome();
        minijungle = BiomeSettings.MINIJUNGLE.getBiome();
        mountaindesert = BiomeSettings.MOUNTAINDESERT.getBiome();
        mountainridge = BiomeSettings.MOUNTAINRIDGE.getBiome();
        mountaintaiga = BiomeSettings.MOUNTAINTAIGA.getBiome();
        pineforest = BiomeSettings.PINEFOREST.getBiome();
        rainforest = BiomeSettings.RAINFOREST.getBiome();
        redwoodforest = BiomeSettings.REDWOODFOREST.getBiome();
        redwoodlush = BiomeSettings.REDWOODLUSH.getBiome();
        savanna = BiomeSettings.SAVANNA.getBiome();
        shrubland = BiomeSettings.SHRUBLAND.getBiome();
        snowforest = BiomeSettings.SNOWYFOREST.getBiome();
        snowyrainforest = BiomeSettings.SNOWYRAINFOREST.getBiome();
        temperaterainforest = BiomeSettings.TEMPORATERAINFOREST.getBiome();
        tundra = BiomeSettings.TUNDRA.getBiome();
        wasteland = BiomeSettings.WASTELAND.getBiome();
        woodlands = BiomeSettings.WOODLANDS.getBiome();
    }

    public BiomeManagerImpl() {
        ArrayListMultimap tree = ArrayListMultimap.create();
        weightedChoices.put(BiomeManager.GenType.TREE, (Multimap<BiomeGenBase, WeightedWorldGenerator>)tree);
        ArrayListMultimap grass = ArrayListMultimap.create();
        weightedChoices.put(BiomeManager.GenType.GRASS, (Multimap<BiomeGenBase, WeightedWorldGenerator>)grass);
        instance = Optional.of((Object)this);
    }

    @Override
    protected void addBiomeGen(BiomeManager.GenType genType, BiomeGenBase biome, WorldGenerator treeGen, int weight) {
        Multimap<BiomeGenBase, WeightedWorldGenerator> choices = weightedChoices.get((Object)genType);
        choices.put((Object)biome, (Object)new WeightedWorldGenerator(treeGen, weight));
    }

    public static void buildWeightedFloraLists() {
        BiomeManagerImpl.buildWeightedBiomeTreeList();
        BiomeManagerImpl.buildWeightedBiomeGrassList();
    }

    @Override
    protected Optional<? extends WorldGenerator> chooseBiomeRandomGen(BiomeManager.GenType genType, Random rand, BiomeGenBase biome) {
        Collection choicesForBiome;
        Optional randomItem;
        Optional choicesForGenType = Optional.fromNullable(weightedChoices.get((Object)genType));
        if (choicesForGenType.isPresent() && (randomItem = WeightedRandomChooser.getRandomItem(rand, choicesForBiome = ((Multimap)choicesForGenType.get()).get((Object)biome))).isPresent()) {
            return Optional.of((Object)((WeightedWorldGenerator)((Object)randomItem.get())).getWorldGen());
        }
        return Optional.absent();
    }

    @Override
    protected Collection<BiomeGenBase> getBiomeCollection() {
        return ImmutableSet.copyOf(BiomeHelper.getActiveBiomes());
    }

    @Override
    protected int getBiomeTotalWeight(BiomeManager.GenType genType, BiomeGenBase biome) {
        return WeightedRandomChooser.getTotalWeight(weightedChoices.get((Object)genType).get((Object)biome));
    }
}

