/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.fml;

import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.fml.IDResolverMapping;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import sharose.mods.idresolver.IDResolverBasic;

public class IDResolverMappingList
implements List {
    private ArrayList<IDResolverMapping> list;
    private static IDResolverMappingList instance;

    public static IDResolverMappingList instance() {
        if (instance == null) {
            new IDResolverMappingList();
        }
        return instance;
    }

    private IDResolverMappingList() {
        instance = this;
        this.list = new ArrayList();
        this.init();
    }

    private void init() {
        if (Loader.isModLoaded((String)TCSettings.idResolverModID)) {
            TCLog.info("ID Resolver has been detected.  Processing ID config...", new Object[0]);
            Properties idrKnownIDs = null;
            try {
                idrKnownIDs = (Properties)ObfuscationReflectionHelper.getPrivateValue(IDResolverBasic.class, null, (String[])new String[]{"knownIDs"});
            }
            catch (Throwable e) {
                TCLog.debug("Error getting knownIDs from ID Resolver: %s", e.getMessage());
                e.printStackTrace();
            }
            if (idrKnownIDs != null) {
                for (String key : idrKnownIDs.stringPropertyNames()) {
                    String value = idrKnownIDs.getProperty(key);
                    try {
                        if (!key.startsWith("ItemID.") && !key.startsWith("BlockID.")) continue;
                        IDResolverMapping mapping = new IDResolverMapping(key + "=" + value);
                        if (mapping.oldID != 0 && mapping.newID != 0 && !mapping.isStaticMapping()) {
                            this.add(mapping);
                            TCLog.debug("Adding entry: %s", key + "=" + value);
                            continue;
                        }
                        TCLog.debug("Ignoring entry: %s", key + "=" + value);
                    }
                    catch (Throwable e) {
                        TCLog.severe("Exception caught for line: %s", key + "=" + value);
                    }
                }
            }
        } else {
            TCLog.info("ID Resolver (Mod ID \"%s\") is not loaded.", TCSettings.idResolverModID);
        }
    }

    public boolean hasMappingForModAndID(String className, int oldID) {
        for (IDResolverMapping mapping : this.list) {
            if (!mapping.modClassName.equals(className) || mapping.oldID != oldID) continue;
            return true;
        }
        return false;
    }

    public IDResolverMapping getMappingForModAndOldID(String className, int oldID) {
        for (IDResolverMapping mapping : this.list) {
            if (!mapping.modClassName.equals(className) || mapping.oldID != oldID) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    public ArrayList<IDResolverMapping> toArrayList() {
        return (ArrayList)this.list.clone();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(Object e) {
        return this.list.add((IDResolverMapping)e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.list.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public Object set(int index, Object element) {
        return this.list.set(index, (IDResolverMapping)element);
    }

    public void add(int index, Object element) {
        this.list.add(index, (IDResolverMapping)element);
    }

    public Object remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.list.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

