/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksItemTreeCategory;
import invtweaks.InvTweaksItemTreeItem;
import invtweaks.api.IItemTree;
import invtweaks.api.IItemTreeCategory;
import invtweaks.api.IItemTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;

public class InvTweaksItemTree
implements IItemTree {
    public static final int MAX_CATEGORY_RANGE = 1000;
    public static final String UNKNOWN_ITEM = "unknown";
    private static final Logger log = InvTweaks.log;
    private Map<String, IItemTreeCategory> categories = new HashMap<String, IItemTreeCategory>();
    private Map<Integer, Vector<IItemTreeItem>> itemsById = new HashMap<Integer, Vector<IItemTreeItem>>(500);
    private static Vector<IItemTreeItem> defaultItems = null;
    private Map<String, Vector<IItemTreeItem>> itemsByName = new HashMap<String, Vector<IItemTreeItem>>(500);
    private String rootCategory;
    private List<OreDictInfo> oresRegistered = new ArrayList<OreDictInfo>();

    public InvTweaksItemTree() {
        this.reset();
    }

    public void reset() {
        if (defaultItems == null) {
            defaultItems = new Vector();
            defaultItems.add(new InvTweaksItemTreeItem(UNKNOWN_ITEM, -1, Short.MAX_VALUE, Integer.MAX_VALUE));
        }
        this.categories.clear();
        this.itemsByName.clear();
        this.itemsById.clear();
    }

    @Override
    public boolean matches(List<IItemTreeItem> list, String string) {
        if (list == null) {
            return false;
        }
        for (IItemTreeItem object : list) {
            if (object.getName() == null || !object.getName().equals(string)) continue;
            return true;
        }
        IItemTreeCategory iItemTreeCategory = this.getCategory(string);
        if (iItemTreeCategory != null) {
            for (IItemTreeItem iItemTreeItem : list) {
                if (!iItemTreeCategory.contains(iItemTreeItem)) continue;
                return true;
            }
        }
        return string.equals(this.rootCategory);
    }

    @Override
    public int getKeywordDepth(String string) {
        try {
            return this.getRootCategory().findKeywordDepth(string);
        }
        catch (NullPointerException nullPointerException) {
            log.severe("The root category is missing: " + nullPointerException.getMessage());
            return 0;
        }
    }

    @Override
    public int getKeywordOrder(String string) {
        List<IItemTreeItem> list = this.getItems(string);
        if (list != null && list.size() != 0) {
            return list.get(0).getOrder();
        }
        try {
            return this.getRootCategory().findCategoryOrder(string);
        }
        catch (NullPointerException nullPointerException) {
            log.severe("The root category is missing: " + nullPointerException.getMessage());
            return -1;
        }
    }

    @Override
    public boolean isKeywordValid(String string) {
        if (this.containsItem(string)) {
            return true;
        }
        IItemTreeCategory iItemTreeCategory = this.getCategory(string);
        return iItemTreeCategory != null;
    }

    @Override
    public Collection<IItemTreeCategory> getAllCategories() {
        return this.categories.values();
    }

    @Override
    public IItemTreeCategory getRootCategory() {
        return this.categories.get(this.rootCategory);
    }

    @Override
    public IItemTreeCategory getCategory(String string) {
        return this.categories.get(string);
    }

    @Override
    public boolean isItemUnknown(int n, int n2) {
        return this.itemsById.get(n) == null;
    }

    @Override
    public List<IItemTreeItem> getItems(int n, int n2) {
        Object object;
        List list = this.itemsById.get(n);
        ArrayList<IItemTreeItem> arrayList = new ArrayList<IItemTreeItem>();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (list != null && !list.isEmpty()) {
            for (IItemTreeItem iItemTreeItem : list) {
                if (iItemTreeItem.getDamage() == Short.MAX_VALUE || iItemTreeItem.getDamage() == n2) continue;
                arrayList.remove(iItemTreeItem);
            }
        }
        if (arrayList.isEmpty()) {
            IItemTreeItem iItemTreeItem;
            object = new InvTweaksItemTreeItem(String.format("%d-%d", n, n2), n, n2, 5000 + n * 16 + n2);
            iItemTreeItem = new InvTweaksItemTreeItem(Integer.toString(n), n, Short.MAX_VALUE, 5000 + n * 16);
            this.addItem(this.getRootCategory().getName(), (IItemTreeItem)object);
            this.addItem(this.getRootCategory().getName(), iItemTreeItem);
            arrayList.add((IItemTreeItem)object);
            arrayList.add(iItemTreeItem);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            object.remove();
        }
        return arrayList;
    }

    @Override
    public List<IItemTreeItem> getItems(String string) {
        return this.itemsByName.get(string);
    }

    @Override
    public IItemTreeItem getRandomItem(Random random) {
        return (IItemTreeItem)this.itemsByName.values().toArray()[random.nextInt(this.itemsByName.size())];
    }

    @Override
    public boolean containsItem(String string) {
        return this.itemsByName.containsKey(string);
    }

    @Override
    public boolean containsCategory(String string) {
        return this.categories.containsKey(string);
    }

    @Override
    public void setRootCategory(IItemTreeCategory iItemTreeCategory) {
        this.rootCategory = iItemTreeCategory.getName();
        this.categories.put(this.rootCategory, iItemTreeCategory);
    }

    @Override
    public IItemTreeCategory addCategory(String string, String string2) throws NullPointerException {
        InvTweaksItemTreeCategory invTweaksItemTreeCategory = new InvTweaksItemTreeCategory(string2);
        this.addCategory(string, invTweaksItemTreeCategory);
        return invTweaksItemTreeCategory;
    }

    @Override
    public IItemTreeItem addItem(String string, String string2, int n, int n2, int n3) throws NullPointerException {
        InvTweaksItemTreeItem invTweaksItemTreeItem = new InvTweaksItemTreeItem(string2, n, n2, n3);
        this.addItem(string, invTweaksItemTreeItem);
        return invTweaksItemTreeItem;
    }

    @Override
    public void addCategory(String string, IItemTreeCategory iItemTreeCategory) throws NullPointerException {
        this.categories.get(string.toLowerCase()).addCategory(iItemTreeCategory);
        this.categories.put(iItemTreeCategory.getName(), iItemTreeCategory);
    }

    @Override
    public void addItem(String string, IItemTreeItem iItemTreeItem) throws NullPointerException {
        Vector<IItemTreeItem> vector;
        this.categories.get(string.toLowerCase()).addItem(iItemTreeItem);
        if (this.itemsByName.containsKey(iItemTreeItem.getName())) {
            this.itemsByName.get(iItemTreeItem.getName()).add(iItemTreeItem);
        } else {
            vector = new Vector<IItemTreeItem>();
            vector.add(iItemTreeItem);
            this.itemsByName.put(iItemTreeItem.getName(), vector);
        }
        if (this.itemsById.containsKey(iItemTreeItem.getId())) {
            this.itemsById.get(iItemTreeItem.getId()).add(iItemTreeItem);
        } else {
            vector = new Vector();
            vector.add(iItemTreeItem);
            this.itemsById.put(iItemTreeItem.getId(), vector);
        }
    }

    private void log(IItemTreeCategory iItemTreeCategory, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        log.info(string + iItemTreeCategory.getName());
        for (IItemTreeCategory object : iItemTreeCategory.getSubCategories()) {
            this.log(object, n + 1);
        }
        for (List list : iItemTreeCategory.getItems()) {
            for (IItemTreeItem iItemTreeItem : list) {
                log.info(string + "  " + iItemTreeItem + " " + iItemTreeItem.getId() + " " + iItemTreeItem.getDamage());
            }
        }
    }

    @Override
    public void registerOre(String string, String string2, String string3, int n) {
        for (ItemStack itemStack : OreDictionary.getOres((String)string3)) {
            this.addItem(string, new InvTweaksItemTreeItem(string2, itemStack.field_77993_c, itemStack.func_77960_j(), n));
        }
        this.oresRegistered.add(new OreDictInfo(string, string2, string3, n));
    }

    @ForgeSubscribe
    public void oreRegistered(OreDictionary.OreRegisterEvent oreRegisterEvent) {
        for (OreDictInfo oreDictInfo : this.oresRegistered) {
            if (!oreDictInfo.oreName.equals(oreRegisterEvent.Name)) continue;
            this.addItem(oreDictInfo.category, new InvTweaksItemTreeItem(oreDictInfo.name, oreRegisterEvent.Ore.field_77993_c, oreRegisterEvent.Ore.func_77960_j(), oreDictInfo.order));
        }
    }

    private class OreDictInfo {
        String category;
        String name;
        String oreName;
        int order;

        OreDictInfo(String string, String string2, String string3, int n) {
            this.category = string;
            this.name = string2;
            this.oreName = string3;
            this.order = n;
        }
    }
}

