/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.core.CommonUtils;
import codechicken.core.featurehack.GameDataManipulator;
import codechicken.core.inventory.ItemKey;
import codechicken.lib.lang.LangUtil;
import codechicken.nei.InfiniteStackSizeHandler;
import codechicken.nei.InfiniteToolHandler;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.MultiItemRange;
import codechicken.nei.PopupInputHandler;
import codechicken.nei.SpawnerRenderer;
import codechicken.nei.api.API;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.config.ArrayDumper;
import codechicken.nei.config.ItemPanelDumper;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.RecipeItemInputHandler;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IShearable;

public class ItemInfo {
    public static final HashMap<Layout, ArrayList<IHighlightHandler>> highlightHandlers = new HashMap();
    public static final HashMap<ItemKey, String> fallbackNames = new HashMap();
    public static final HashSet<Integer> excludeIds = new HashSet();
    public static final HashSet<Integer> nonUnlimitedIds = new HashSet();
    public static final HashMap<Integer, ArrayList<int[]>> damageVariants = new HashMap();
    public static final ArrayList<int[]> defaultDamageRange = new ArrayList();
    public static final HashMap<Integer, ArrayList<yd>> itemcompounds = new HashMap();
    public static final LinkedList<IInfiniteItemHandler> infiniteHandlers = new LinkedList();
    public static final HashMap<Integer, ArrayList<IHighlightHandler>> highlightIdentifiers = new HashMap();
    public static final HashSet<Class<? extends wd>> fastTransferExemptions = new HashSet();
    public static final String[] itemOwners = new String[yb.g.length];

    static {
        Layout[] layoutArray = Layout.values();
        int n = layoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layout layout = layoutArray[n2];
            highlightHandlers.put(layout, new ArrayList());
            ++n2;
        }
    }

    public static boolean isHidden(int itemID) {
        return excludeIds.contains(itemID);
    }

    public static ArrayList<int[]> getItemDamageVariants(int itemID) {
        ArrayList<int[]> damages = damageVariants.get(itemID);
        return damages == null ? defaultDamageRange : damages;
    }

    public static String getOverrideName(int itemID, int itemDamage) {
        ItemKey itemhash = new ItemKey(itemID, itemDamage);
        return fallbackNames.get(itemhash);
    }

    public static boolean canItemBeUnlimited(int itemID) {
        return !nonUnlimitedIds.contains(itemID);
    }

    public static ArrayList<yd> getItemCompounds(int itemID) {
        return itemcompounds.get(itemID);
    }

    public static void load(abv world) {
        int[] nArray = new int[2];
        nArray[1] = 15;
        defaultDamageRange.add(nArray);
        ItemInfo.addVanillaBlockProperties();
        ItemInfo.addDefaultDropDowns();
        ItemInfo.searchItems();
        ItemInfo.parseModItems();
        ItemInfo.addMobSpawnerItem(world);
        ItemInfo.addSpawnEggs();
        new BrewingRecipeHandler().searchPotions();
        ItemInfo.addInfiniteHandlers();
        ItemInfo.addInputHandlers();
        ItemInfo.addIDDumps();
    }

    private static void addIDDumps() {
        API.addOption(new ArrayDumper<yb>("tools.dump.item"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Block/Item", "Mod", "Unlocalised name", "Class"};
            }

            @Override
            public String[] dump(int i, yb item) {
                aqw block = i < aqw.s.length ? aqw.s[i] : null;
                return new String[]{Integer.toString(i), block != null ? "Block" : "Item", itemOwners[i], block != null ? block.a() : item.a(), (block != null ? block : item).getClass().getCanonicalName()};
            }

            public yb[] array() {
                return yb.g;
            }
        });
        API.addOption(new ArrayDumper<nh>("tools.dump.potion"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Unlocalised name", "Class"};
            }

            @Override
            public String[] dump(int i, nh potion) {
                return new String[]{Integer.toString(i), potion.a(), potion.getClass().getCanonicalName()};
            }

            public nh[] array() {
                return nh.a;
            }
        });
        API.addOption(new ArrayDumper<aat>("tools.dump.enchantment"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Unlocalised name", "Type", "Min Level", "Max Level", "Class"};
            }

            @Override
            public String[] dump(int i, aat ench) {
                return new String[]{Integer.toString(i), ench.a(), ench.A.toString(), Integer.toString(ench.d()), Integer.toString(ench.b()), ench.getClass().getCanonicalName()};
            }

            public aat[] array() {
                return aat.b;
            }
        });
        API.addOption(new ArrayDumper<acp>("tools.dump.biome"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Name", "Temperature", "Rainfall", "Spawn Chance", "Min Height", "Max Height", "Types", "Class"};
            }

            @Override
            public String[] dump(int i, acp biome) {
                BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((acp)biome);
                StringBuilder s_types = new StringBuilder();
                BiomeDictionary.Type[] typeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    BiomeDictionary.Type t = typeArray[n2];
                    if (s_types.length() > 0) {
                        s_types.append(", ");
                    }
                    s_types.append(t.name());
                    ++n2;
                }
                return new String[]{Integer.toString(i), biome.y, Float.toString(biome.j()), Float.toString(biome.i()), Float.toString(biome.f()), Float.toString(biome.D), Float.toString(biome.E), s_types.toString(), biome.getClass().getCanonicalName()};
            }

            public acp[] array() {
                return acp.a;
            }
        });
        API.addOption(new ItemPanelDumper("tools.dump.itempanel"));
    }

    private static void parseModItems() {
        cf itemDataList = new cf();
        GameData.writeItemData((cf)itemDataList);
        HashMap<String, MultiItemRange> modRangeMap = new HashMap<String, MultiItemRange>();
        int i = 0;
        while (i < itemDataList.c()) {
            ItemData itemData = new ItemData((bx)itemDataList.b(i));
            MultiItemRange itemRange = (MultiItemRange)modRangeMap.get(itemData.getModId());
            if (itemRange == null) {
                itemRange = new MultiItemRange();
                modRangeMap.put(itemData.getModId(), itemRange);
            }
            ItemInfo.itemOwners[itemData.getItemId()] = itemData.getModId();
            itemRange.add(itemData.getItemId());
            ++i;
        }
        for (Map.Entry entry : modRangeMap.entrySet()) {
            String modID = (String)entry.getKey();
            ModContainer mod = CommonUtils.findModContainer((String)modID);
            String modname = mod == null ? modID : mod.getName();
            API.addSetRange("Mod." + modname, (MultiItemRange)entry.getValue());
        }
    }

    private static void addInputHandlers() {
        GuiContainerManager.addInputHandler(new RecipeItemInputHandler());
        GuiContainerManager.addInputHandler(new PopupInputHandler());
    }

    private static void addMobSpawnerItem(final abv world) {
        yb.g[aqw.ax.cF] = null;
        GameDataManipulator.createHiddenItem((Runnable)new Runnable(){

            @Override
            public void run() {
                new ItemMobSpawner(world);
            }
        });
        MinecraftForgeClient.registerItemRenderer((int)aqw.ax.cF, (IItemRenderer)new SpawnerRenderer());
    }

    private static void addInfiniteHandlers() {
        API.addInfiniteItemHandler(new InfiniteStackSizeHandler());
        API.addInfiniteItemHandler(new InfiniteToolHandler());
    }

    private static void addVanillaBlockProperties() {
        API.setOverrideName(aqw.F.cF, 0, "Water Source");
        API.setMaxDamageException(aqw.F.cF, 0);
        API.setOverrideName(aqw.G.cF, 0, "Water Still");
        API.setMaxDamageException(aqw.G.cF, 0);
        API.setOverrideName(aqw.H.cF, 0, "Lava Source");
        API.setMaxDamageException(aqw.H.cF, 0);
        API.setOverrideName(aqw.I.cF, 0, "Lava Still");
        API.setMaxDamageException(aqw.I.cF, 0);
        API.setOverrideName(aqw.bq.cF, 0, "Silverfish Stone");
        API.setOverrideName(aqw.bM.cF, 0, "End Portal");
        API.setOverrideName(aqw.bN.cF, 0, "End Portal Frame");
        API.hideItem(aqw.af.cF);
        API.hideItem(aqw.ah.cF);
        API.hideItem(aqw.by.cF);
        API.hideItem(aqw.bx.cF);
        API.hideItem(aqw.X.cF);
        API.hideItem(aqw.aA.cF);
        API.hideItem(aqw.aE.cF);
        API.hideItem(aqw.aI.cF);
        API.hideItem(aqw.aJ.cF);
        API.hideItem(aqw.aN.cF);
        API.hideItem(aqw.aQ.cF);
        API.hideItem(aqw.aT.cF);
        API.hideItem(aqw.aU.cF);
        API.hideItem(aqw.bc.cF);
        API.hideItem(aqw.bm.cF);
        API.hideItem(aqw.bn.cF);
        API.hideItem(aqw.bL.cF);
        API.hideItem(aqw.bI.cF);
        API.hideItem(aqw.bK.cF);
        API.hideItem(aqw.aH.cF);
        API.hideItem(aqw.bR.cF);
        API.hideItem(aqw.ch.cF);
        API.hideItem(aqw.ci.cF);
        API.hideItem(aqw.cj.cF);
        API.hideItem(aqw.cl.cF);
        API.hideItem(aqw.bZ.cF);
    }

    private static void addDefaultDropDowns() {
        API.addSetRange("Blocks", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, bx compound) {
                if (item < aqw.s.length && aqw.s[item] != null && aqw.s[item].cU != ajz.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Items", new MultiItemRange("[0-32000]"){

            @Override
            public void addItemIfInRange(int item, int damage, bx compound) {
                if (item >= aqw.s.length || aqw.s[item] == null || aqw.s[item].cU == ajz.a) {
                    super.addItemIfInRange(item, damage, compound);
                }
            }
        });
        API.addSetRange("Blocks.MobSpawners", new MultiItemRange("[52]"));
    }

    private static void searchItems() {
        wv tab;
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange picks = new MultiItemRange();
        MultiItemRange shovels = new MultiItemRange();
        MultiItemRange axes = new MultiItemRange();
        MultiItemRange hoes = new MultiItemRange();
        MultiItemRange swords = new MultiItemRange();
        MultiItemRange chest = new MultiItemRange();
        MultiItemRange helmets = new MultiItemRange();
        MultiItemRange legs = new MultiItemRange();
        MultiItemRange boots = new MultiItemRange();
        MultiItemRange other = new MultiItemRange();
        MultiItemRange ranged = new MultiItemRange();
        MultiItemRange food = new MultiItemRange();
        MultiItemRange potioningredients = new MultiItemRange();
        MultiItemRange[] creativeTabRanges = new MultiItemRange[wv.a.length];
        wv[] wvArray = wv.a;
        int n = wv.a.length;
        int n2 = 0;
        while (n2 < n) {
            tab = wvArray[n2];
            creativeTabRanges[tab.a()] = new MultiItemRange();
            ++n2;
        }
        wvArray = yb.g;
        n = yb.g.length;
        n2 = 0;
        while (n2 < n) {
            wv item = wvArray[n2];
            if (item != null) {
                wv itemTab = item.y();
                if (itemTab != null) {
                    creativeTabRanges[itemTab.a()].add((yb)item);
                }
                if (item.p()) {
                    tools.add((yb)item);
                    if (item instanceof ym) {
                        picks.add((yb)item);
                    } else if (item instanceof yx) {
                        shovels.add((yb)item);
                    } else if (item instanceof xz) {
                        axes.add((yb)item);
                    } else if (item instanceof ya) {
                        hoes.add((yb)item);
                    } else if (item instanceof zk) {
                        swords.add((yb)item);
                    } else if (item instanceof wg) {
                        switch (((wg)item).b) {
                            case 0: {
                                helmets.add((yb)item);
                                break;
                            }
                            case 1: {
                                chest.add((yb)item);
                                break;
                            }
                            case 2: {
                                legs.add((yb)item);
                                break;
                            }
                            case 3: {
                                boots.add((yb)item);
                            }
                        }
                    } else if (item == yb.n || item == yb.m) {
                        ranged.add((yb)item);
                    } else if (item == yb.aT || item == yb.k || item == yb.bg) {
                        other.add((yb)item);
                    }
                }
                if (item instanceof xw) {
                    food.add((yb)item);
                }
                if (item.x()) {
                    BrewingRecipeHandler.ingredientIDs.add(item.cv);
                    potioningredients.add((yb)item);
                }
            }
            ++n2;
        }
        API.addSetRange("Items.Tools.Pickaxes", picks);
        API.addSetRange("Items.Tools.Shovels", shovels);
        API.addSetRange("Items.Tools.Axes", axes);
        API.addSetRange("Items.Tools.Hoes", hoes);
        API.addSetRange("Items.Tools.Other", other);
        API.addSetRange("Items.Weapons.Swords", swords);
        API.addSetRange("Items.Weapons.Ranged", ranged);
        API.addSetRange("Items.Armor.ChestPlates", chest);
        API.addSetRange("Items.Armor.Leggings", legs);
        API.addSetRange("Items.Armor.Helmets", helmets);
        API.addSetRange("Items.Armor.Boots", boots);
        API.addSetRange("Items.Food", food);
        API.addSetRange("Items.Potions.Ingredients", potioningredients);
        wvArray = wv.a;
        n = wv.a.length;
        n2 = 0;
        while (n2 < n) {
            tab = wvArray[n2];
            if (creativeTabRanges[tab.a()].ranges.size() > 0) {
                API.addSetRange("CreativeTabs." + LangUtil.translateG((String)tab.c(), (Object[])new Object[0]), creativeTabRanges[tab.a()]);
            }
            ++n2;
        }
    }

    private static void addSpawnEggs() {
        ArrayList<Integer> damages = new ArrayList<Integer>();
        try {
            HashMap classToIDMapping = (HashMap)ns.e;
            damages.add((Integer)classToIDMapping.get(rv.class));
            damages.add((Integer)classToIDMapping.get(tq.class));
            damages.add((Integer)classToIDMapping.get(te.class));
            damages.add((Integer)classToIDMapping.get(tr.class));
            damages.add((Integer)classToIDMapping.get(tv.class));
            damages.add((Integer)classToIDMapping.get(ts.class));
            damages.add((Integer)classToIDMapping.get(rp.class));
            damages.add((Integer)classToIDMapping.get(td.class));
            damages.add((Integer)classToIDMapping.get(rq.class));
            damages.add((Integer)classToIDMapping.get(tf.class));
            damages.add((Integer)classToIDMapping.get(se.class));
            damages.add((Integer)classToIDMapping.get(tm.class));
            damages.add((Integer)classToIDMapping.get(sb.class));
            damages.add((Integer)classToIDMapping.get(ti.class));
            damages.add((Integer)classToIDMapping.get(tk.class));
            damages.add((Integer)classToIDMapping.get(ry.class));
            damages.add((Integer)classToIDMapping.get(tc.class));
            damages.add((Integer)classToIDMapping.get(ua.class));
            damages.add((Integer)classToIDMapping.get(tp.class));
            damages.add((Integer)classToIDMapping.get(rx.class));
            damages.add((Integer)classToIDMapping.get(rw.class));
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(sa.class), 0xEEFFFF, 16753185);
            ItemInfo.addEntityEgg(damages, (Integer)classToIDMapping.get(sc.class), 12960449, 16769484);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        API.setItemDamageVariants(yb.bE.cv, damages);
    }

    private static void addEntityEgg(ArrayList<Integer> damages, Integer ID, int i, int j) {
        damages.add(ID);
        ns.a.put(ID, new nt(ID.intValue(), i, j));
    }

    public static ArrayList<yd> getIdentifierItems(abv world, ue player, asx hit) {
        IShearable shearable;
        int x = hit.b;
        int y = hit.c;
        int z = hit.d;
        aqw mouseoverBlock = aqw.s[world.a(x, y, z)];
        ArrayList<yd> items = new ArrayList<yd>();
        ArrayList handlers = new ArrayList();
        if (highlightIdentifiers.get(0) != null) {
            handlers.addAll(highlightIdentifiers.get(0));
        }
        if (highlightIdentifiers.get(mouseoverBlock.cF) != null) {
            handlers.addAll(highlightIdentifiers.get(mouseoverBlock.cF));
        }
        for (IHighlightHandler ident : handlers) {
            yd item = ident.identifyHighlight(world, player, hit);
            if (item == null) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            return items;
        }
        yd pick = mouseoverBlock.getPickBlock(hit, world, x, y, z);
        if (pick != null) {
            items.add(pick);
        }
        try {
            items.addAll(mouseoverBlock.getBlockDropped(world, x, y, z, world.h(x, y, z), 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new yd((yb)yb.bg), world, x, y, z)) {
            items.addAll(shearable.onSheared(new yd((yb)yb.bg), world, x, y, z, 0));
        }
        if (items.size() == 0) {
            items.add(0, new yd(mouseoverBlock, 1, world.h(x, y, z)));
        }
        return items;
    }

    public static void registerHighlightHandler(IHighlightHandler handler, Layout ... layouts) {
        Layout[] layoutArray = layouts;
        int n = layouts.length;
        int n2 = 0;
        while (n2 < n) {
            Layout layout = layoutArray[n2];
            highlightHandlers.get((Object)layout).add(handler);
            ++n2;
        }
    }

    public static List<String> getText(yd itemStack, abv world, ue player, asx mop) {
        List<String> retString = new ArrayList<String>();
        Layout[] layoutArray = Layout.values();
        int n = layoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layout layout = layoutArray[n2];
            for (IHighlightHandler handler : highlightHandlers.get((Object)layout)) {
                retString = handler.handleTextData(itemStack, world, player, mop, retString, layout);
            }
            ++n2;
        }
        return retString;
    }

    public static enum Layout {
        HEADER,
        BODY,
        FOOTER;

    }
}

