/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.generator.container.ContainerGeoGenerator;
import ic2.core.block.generator.gui.GuiGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityGeoGenerator
extends TileEntityBaseGenerator
implements IFluidTank {
    public int maxLava = 24000;
    public final InvSlotConsumableLiquid fuelSlot = new InvSlotConsumableLiquid((TileEntityInventory)this, "fuel", 1, 1, FluidRegistry.LAVA);

    public TileEntityGeoGenerator() {
        super(IC2.energyGeneratorGeo, Math.max(IC2.energyGeneratorGeo, 32));
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxLava;
    }

    @Override
    public boolean gainFuel() {
        if (this.fuel + 1000 > this.maxLava) {
            return false;
        }
        ItemStack liquid = this.fuelSlot.consume(1);
        if (liquid == null) {
            return false;
        }
        this.fuel += 1000;
        return true;
    }

    public boolean gainFuelSub(ItemStack stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxLava;
    }

    public int distributeLava(int amount) {
        int need = this.maxLava - this.fuel;
        if (need > amount) {
            need = amount;
        }
        this.fuel += need / 2;
        return amount -= need;
    }

    @Override
    public String func_70303_b() {
        if (IC2.platform.isRendering()) {
            return "Geothermal Generator";
        }
        return "Geoth. Generator";
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerGeoGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiGeoGenerator(new ContainerGeoGenerator(entityPlayer, this));
    }

    @Override
    public void onBlockBreak(int a, int b) {
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(new FluidStack(FluidRegistry.LAVA, 1000), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public FluidStack getFluid() {
        return this.fuel > 0 ? new FluidStack(FluidRegistry.LAVA, this.fuel) : null;
    }

    public int getFluidAmount() {
        return this.fuel;
    }

    public int getCapacity() {
        return this.maxLava;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.getFluid() != FluidRegistry.LAVA) {
            return 0;
        }
        int toAdd = Math.min(resource.amount, this.maxLava - this.fuel);
        if (doFill) {
            this.fuel += toAdd;
            FluidStack fluid = new FluidStack(resource, toAdd);
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(fluid, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, (IFluidTank)this));
        }
        return toAdd;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }
}

