/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.ITickCallback;
import ic2.core.WorldData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;

public final class EnergyNet {
    public static final double minConductionLoss = 1.0E-4;
    private static final Direction[] directions = Direction.values();
    private final Map<IEnergySource, List<EnergyPath>> energySourceToEnergyPathMap = new HashMap<IEnergySource, List<EnergyPath>>();
    private final Map<EntityLivingBase, Integer> entityLivingToShockEnergyMap = new HashMap<EntityLivingBase, Integer>();
    private final Map<ChunkCoordinates, TileEntity> registeredTileEntities = new HashMap<ChunkCoordinates, TileEntity>();
    private static int apiDemandsErrorCooldown = 0;
    private static int apiEmitErrorCooldown = 0;

    public static void initialize() {
        new EventHandler();
    }

    public static EnergyNet getForWorld(World world) {
        WorldData worldData = WorldData.get(world);
        return worldData.energyNet;
    }

    public static void onTick(World world) {
        IC2.platform.profilerStartSection("Shocking");
        EnergyNet energyNet = EnergyNet.getForWorld(world);
        for (Map.Entry<EntityLivingBase, Integer> entry : energyNet.entityLivingToShockEnergyMap.entrySet()) {
            EntityLivingBase target = entry.getKey();
            int damage = (entry.getValue() + 63) / 64;
            if (!target.func_70089_S()) continue;
            target.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
        }
        energyNet.entityLivingToShockEnergyMap.clear();
        if (world.field_73011_w.field_76574_g == 0) {
            if (apiDemandsErrorCooldown > 0) {
                --apiDemandsErrorCooldown;
            }
            if (apiEmitErrorCooldown > 0) {
                --apiEmitErrorCooldown;
            }
        }
        IC2.platform.profilerEndSection();
    }

    protected EnergyNet() {
    }

    public void addTileEntity(TileEntity te) {
        if (!IC2.platform.isSimulating()) {
            IC2.log.warning("EnergyNet.addTileEntity: called for " + te + " client-side, aborting");
            return;
        }
        if (!(te instanceof IEnergyTile)) {
            IC2.log.warning("EnergyNet.addTileEntity: " + te + " doesn't implement IEnergyTile, aborting");
            return;
        }
        if (te.func_70320_p()) {
            IC2.log.warning("EnergyNet.addTileEntity: " + te + " is invalid (TileEntity.isInvalid()), aborting");
            return;
        }
        ChunkCoordinates coords = new ChunkCoordinates(te.field_70329_l, te.field_70330_m, te.field_70327_n);
        if (this.registeredTileEntities.containsKey(coords)) {
            IC2.log.warning("EnergyNet.addTileEntity: " + te + " is already added, aborting");
            return;
        }
        if (!te.field_70331_k.func_72899_e(te.field_70329_l, te.field_70330_m, te.field_70327_n)) {
            IC2.log.warning("EnergyNet.addTileEntity: " + te + " was added too early, postponing");
            IC2.addSingleTickCallback(te.field_70331_k, new PostPonedAddCallback(te));
            return;
        }
        this.registeredTileEntities.put(coords, te);
        if (te instanceof IEnergyAcceptor) {
            List<EnergyPath> reverseEnergyPaths = this.discover(te, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                this.energySourceToEnergyPathMap.remove(energySource);
            }
        }
        if (te instanceof IEnergySource) {
            // empty if block
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int x = te.field_70329_l + dir.offsetX;
            int y = te.field_70330_m + dir.offsetY;
            int z = te.field_70327_n + dir.offsetZ;
            if (!te.field_70331_k.func_72899_e(x, y, z)) continue;
            te.field_70331_k.func_72821_m(x, y, z, te.func_70311_o().field_71990_ca);
        }
    }

    public void removeTileEntity(TileEntity te) {
        if (!IC2.platform.isSimulating()) {
            IC2.log.warning("EnergyNet.removeTileEntity: called for " + te + " client-side, aborting");
            return;
        }
        if (!(te instanceof IEnergyTile)) {
            IC2.log.warning("EnergyNet.removeTileEntity: " + te + " doesn't implement IEnergyTile, aborting");
            return;
        }
        ChunkCoordinates coords = new ChunkCoordinates(te.field_70329_l, te.field_70330_m, te.field_70327_n);
        if (!this.registeredTileEntities.containsKey(coords)) {
            IC2.log.warning("EnergyNet.removeTileEntity: " + te + " is already removed, aborting");
            return;
        }
        if (te instanceof IEnergyAcceptor) {
            List<EnergyPath> reverseEnergyPaths = this.discover(te, true, Integer.MAX_VALUE);
            block0: for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                if (te instanceof IEnergyConductor) {
                    this.energySourceToEnergyPathMap.remove(energySource);
                    continue;
                }
                Iterator<EnergyPath> it = this.energySourceToEnergyPathMap.get(energySource).iterator();
                while (it.hasNext()) {
                    if (it.next().target != te) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
        if (te instanceof IEnergySource) {
            this.energySourceToEnergyPathMap.remove(te);
        }
        this.registeredTileEntities.remove(coords);
        if (te.field_70331_k.func_72899_e(te.field_70329_l, te.field_70330_m, te.field_70327_n)) {
            Block block = te.func_70311_o();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int x = te.field_70329_l + dir.offsetX;
                int y = te.field_70330_m + dir.offsetY;
                int z = te.field_70327_n + dir.offsetZ;
                if (!te.field_70331_k.func_72899_e(x, y, z)) continue;
                te.field_70331_k.func_72821_m(x, y, z, block != null ? block.field_71990_ca : 0);
            }
        }
    }

    public int emitEnergyFrom(IEnergySource energySource, int amount) {
        if (!IC2.platform.isSimulating()) {
            if (apiEmitErrorCooldown == 0) {
                apiEmitErrorCooldown = 600;
                IC2.log.warning("EnergyNet.emitEnergyFrom: called for " + energySource + " client-side, aborting");
            }
            return amount;
        }
        if (!(energySource instanceof TileEntity)) {
            if (apiEmitErrorCooldown == 0) {
                apiEmitErrorCooldown = 600;
                IC2.log.warning("EnergyNet.emitEnergyFrom: " + energySource + " is no tile entity, aborting");
            }
            return amount;
        }
        TileEntity srcTe = (TileEntity)energySource;
        if (srcTe.func_70320_p()) {
            IC2.log.warning("EnergyNet.emitEnergyFrom: " + srcTe + " is invalid (TileEntity.isInvalid()), aborting");
            return amount;
        }
        if (!this.registeredTileEntities.containsKey(new ChunkCoordinates(srcTe.field_70329_l, srcTe.field_70330_m, srcTe.field_70327_n))) {
            if (apiEmitErrorCooldown == 0) {
                apiEmitErrorCooldown = 600;
                IC2.log.warning("EnergyNet.emitEnergyFrom: " + energySource + " is not added to the enet, aborting");
            }
            return amount;
        }
        if (!this.energySourceToEnergyPathMap.containsKey(energySource)) {
            this.energySourceToEnergyPathMap.put(energySource, this.discover((TileEntity)energySource, false, energySource.getMaxEnergyOutput()));
        }
        Vector<EnergyPath> activeEnergyPaths = new Vector<EnergyPath>();
        double totalInvLoss = 0.0;
        for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(energySource)) {
            assert (energyPath.target instanceof IEnergySink);
            IEnergySink energySink = (IEnergySink)energyPath.target;
            if (energySink.demandsEnergy() <= 0 || !(energyPath.loss < (double)amount)) continue;
            totalInvLoss += 1.0 / energyPath.loss;
            activeEnergyPaths.add(energyPath);
        }
        Collections.shuffle(activeEnergyPaths);
        for (int i = activeEnergyPaths.size() - amount; i > 0; --i) {
            EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
            totalInvLoss -= 1.0 / removedEnergyPath.loss;
        }
        HashMap<EnergyPath, Integer> suppliedEnergyPaths = new HashMap<EnergyPath, Integer>();
        new Vector();
        while (!activeEnergyPaths.isEmpty() && amount > 0) {
            int energyConsumed = 0;
            double newTotalInvLoss = 0.0;
            Vector<EnergyPath> currentActiveEnergyPaths = activeEnergyPaths;
            activeEnergyPaths = new Vector();
            activeEnergyPaths.iterator();
            for (EnergyPath energyPath : currentActiveEnergyPaths) {
                int energyLoss;
                IEnergySink energySink = (IEnergySink)energyPath.target;
                int energyProvided = (int)Math.floor((double)Math.round((double)amount / totalInvLoss / energyPath.loss * 100000.0) / 100000.0);
                if (energyProvided > (energyLoss = (int)Math.floor(energyPath.loss))) {
                    int energyReturned = energySink.injectEnergy(energyPath.targetDirection, energyProvided - energyLoss);
                    if (energyReturned == 0 && energySink.demandsEnergy() > 0) {
                        activeEnergyPaths.add(energyPath);
                        newTotalInvLoss += 1.0 / energyPath.loss;
                    } else if (energyReturned >= energyProvided - energyLoss) {
                        energyReturned = energyProvided - energyLoss;
                        if (apiDemandsErrorCooldown == 0) {
                            apiDemandsErrorCooldown = 600;
                            String c = "not a tile entity";
                            if (energySink instanceof TileEntity) {
                                TileEntity te = (TileEntity)energySink;
                                c = (te.field_70331_k == null ? "unknown" : Integer.valueOf(te.field_70331_k.field_73011_w.field_76574_g)) + ":" + te.field_70329_l + "," + te.field_70330_m + "," + te.field_70327_n;
                            }
                            IC2.log.warning("API ERROR: " + energySink + " (" + c + ") didn't implement demandsEnergy() properly, no energy from injectEnergy accepted (" + energyReturned + ") although demandsEnergy() requested " + (energyProvided - energyLoss) + ".");
                        }
                    }
                    energyConsumed += energyProvided - energyReturned;
                    int energyInjected = energyProvided - energyLoss - energyReturned;
                    if (!suppliedEnergyPaths.containsKey(energyPath)) {
                        suppliedEnergyPaths.put(energyPath, energyInjected);
                        continue;
                    }
                    suppliedEnergyPaths.put(energyPath, energyInjected + (Integer)suppliedEnergyPaths.get(energyPath));
                    continue;
                }
                activeEnergyPaths.add(energyPath);
                newTotalInvLoss += 1.0 / energyPath.loss;
            }
            if (energyConsumed == 0 && !activeEnergyPaths.isEmpty()) {
                EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
                newTotalInvLoss -= 1.0 / removedEnergyPath.loss;
            }
            totalInvLoss = newTotalInvLoss;
            amount -= energyConsumed;
        }
        for (Map.Entry entry : suppliedEnergyPaths.entrySet()) {
            EnergyPath energyPath = (EnergyPath)entry.getKey();
            int energyInjected = (Integer)entry.getValue();
            energyPath.totalEnergyConducted += (long)energyInjected;
            if (energyInjected > energyPath.minInsulationEnergyAbsorption) {
                List entitiesNearEnergyPath = ((TileEntity)energySource).field_70331_k.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(energyPath.minX - 1), (double)(energyPath.minY - 1), (double)(energyPath.minZ - 1), (double)(energyPath.maxX + 2), (double)(energyPath.maxY + 2), (double)(energyPath.maxZ + 2)));
                for (EntityLivingBase entityLiving : entitiesNearEnergyPath) {
                    int maxShockEnergy = 0;
                    for (IEnergyConductor energyConductor : energyPath.conductors) {
                        TileEntity te = (TileEntity)energyConductor;
                        if (!entityLiving.field_70121_D.func_72326_a(AxisAlignedBB.func_72330_a((double)(te.field_70329_l - 1), (double)(te.field_70330_m - 1), (double)(te.field_70327_n - 1), (double)(te.field_70329_l + 2), (double)(te.field_70330_m + 2), (double)(te.field_70327_n + 2)))) continue;
                        int shockEnergy = energyInjected - energyConductor.getInsulationEnergyAbsorption();
                        if (shockEnergy > maxShockEnergy) {
                            maxShockEnergy = shockEnergy;
                        }
                        if (energyConductor.getInsulationEnergyAbsorption() != energyPath.minInsulationEnergyAbsorption) continue;
                        break;
                    }
                    if (this.entityLivingToShockEnergyMap.containsKey(entityLiving)) {
                        this.entityLivingToShockEnergyMap.put(entityLiving, this.entityLivingToShockEnergyMap.get(entityLiving) + maxShockEnergy);
                        continue;
                    }
                    this.entityLivingToShockEnergyMap.put(entityLiving, maxShockEnergy);
                }
                if (energyInjected >= energyPath.minInsulationBreakdownEnergy) {
                    for (IEnergyConductor energyConductor : energyPath.conductors) {
                        if (energyInjected < energyConductor.getInsulationBreakdownEnergy()) continue;
                        energyConductor.removeInsulation();
                        if (energyConductor.getInsulationEnergyAbsorption() >= energyPath.minInsulationEnergyAbsorption) continue;
                        energyPath.minInsulationEnergyAbsorption = energyConductor.getInsulationEnergyAbsorption();
                    }
                }
            }
            if (energyInjected < energyPath.minConductorBreakdownEnergy) continue;
            for (IEnergyConductor energyConductor : energyPath.conductors) {
                if (energyInjected < energyConductor.getConductorBreakdownEnergy()) continue;
                energyConductor.removeConductor();
            }
        }
        return amount;
    }

    @Deprecated
    public long getTotalEnergyConducted(TileEntity tileEntity) {
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(energySource)) {
                    if ((!(tileEntity instanceof IEnergySink) || energyPath.target != tileEntity) && (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tileEntity))) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tileEntity)) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tileEntity)) {
                ret += energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    public long getTotalEnergyEmitted(TileEntity tileEntity) {
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(energySource)) {
                    if (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tileEntity)) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tileEntity)) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tileEntity)) {
                ret += energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    public long getTotalEnergySunken(TileEntity tileEntity) {
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || (double)energySource.getMaxEnergyOutput() <= reverseEnergyPath.loss) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(energySource)) {
                    if ((!(tileEntity instanceof IEnergySink) || energyPath.target != tileEntity) && (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tileEntity))) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        return ret;
    }

    public TileEntity getTileEntity(int x, int y, int z) {
        return this.registeredTileEntities.get(new ChunkCoordinates(x, y, z));
    }

    public TileEntity getNeighbor(TileEntity te, Direction dir) {
        ChunkCoordinates coords;
        switch (dir) {
            case XN: {
                coords = new ChunkCoordinates(te.field_70329_l - 1, te.field_70330_m, te.field_70327_n);
                break;
            }
            case XP: {
                coords = new ChunkCoordinates(te.field_70329_l + 1, te.field_70330_m, te.field_70327_n);
                break;
            }
            case YN: {
                coords = new ChunkCoordinates(te.field_70329_l, te.field_70330_m - 1, te.field_70327_n);
                break;
            }
            case YP: {
                coords = new ChunkCoordinates(te.field_70329_l, te.field_70330_m + 1, te.field_70327_n);
                break;
            }
            case ZN: {
                coords = new ChunkCoordinates(te.field_70329_l, te.field_70330_m, te.field_70327_n - 1);
                break;
            }
            case ZP: {
                coords = new ChunkCoordinates(te.field_70329_l, te.field_70330_m, te.field_70327_n + 1);
                break;
            }
            default: {
                return null;
            }
        }
        return this.registeredTileEntities.get(coords);
    }

    private List<EnergyPath> discover(TileEntity emitter, boolean reverse, int lossLimit) {
        HashMap<TileEntity, EnergyBlockLink> reachedTileEntities = new HashMap<TileEntity, EnergyBlockLink>();
        LinkedList<TileEntity> tileEntitiesToCheck = new LinkedList<TileEntity>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            TileEntity currentTileEntity = (TileEntity)tileEntitiesToCheck.remove();
            if (currentTileEntity.func_70320_p()) continue;
            double currentLoss = 0.0;
            if (currentTileEntity != emitter) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)currentTileEntity)).loss;
            }
            List<EnergyTarget> validReceivers = this.getValidReceivers(currentTileEntity, reverse);
            for (EnergyTarget validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                double additionalLoss = 0.0;
                if (validReceiver.tileEntity instanceof IEnergyConductor) {
                    additionalLoss = ((IEnergyConductor)validReceiver.tileEntity).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= (double)lossLimit) continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tileEntity) && !(((EnergyBlockLink)reachedTileEntities.get((Object)validReceiver.tileEntity)).loss > currentLoss + additionalLoss)) continue;
                reachedTileEntities.put(validReceiver.tileEntity, new EnergyBlockLink(validReceiver.direction, currentLoss + additionalLoss));
                if (!(validReceiver.tileEntity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.remove(validReceiver.tileEntity);
                tileEntitiesToCheck.add(validReceiver.tileEntity);
            }
        }
        LinkedList<EnergyPath> energyPaths = new LinkedList<EnergyPath>();
        block2: for (Map.Entry entry : reachedTileEntities.entrySet()) {
            TileEntity tileEntity = (TileEntity)entry.getKey();
            if ((reverse || !(tileEntity instanceof IEnergySink)) && (!reverse || !(tileEntity instanceof IEnergySource))) continue;
            EnergyBlockLink energyBlockLink = (EnergyBlockLink)entry.getValue();
            EnergyPath energyPath = new EnergyPath();
            energyPath.loss = energyBlockLink.loss > 0.1 ? energyBlockLink.loss : 0.1;
            energyPath.target = tileEntity;
            energyPath.targetDirection = energyBlockLink.direction;
            if (!reverse && emitter instanceof IEnergySource) {
                while ((tileEntity = this.getNeighbor(tileEntity, energyBlockLink.direction)) != emitter) {
                    if (tileEntity instanceof IEnergyConductor) {
                        IEnergyConductor energyConductor = (IEnergyConductor)tileEntity;
                        if (tileEntity.field_70329_l < energyPath.minX) {
                            energyPath.minX = tileEntity.field_70329_l;
                        }
                        if (tileEntity.field_70330_m < energyPath.minY) {
                            energyPath.minY = tileEntity.field_70330_m;
                        }
                        if (tileEntity.field_70327_n < energyPath.minZ) {
                            energyPath.minZ = tileEntity.field_70327_n;
                        }
                        if (tileEntity.field_70329_l > energyPath.maxX) {
                            energyPath.maxX = tileEntity.field_70329_l;
                        }
                        if (tileEntity.field_70330_m > energyPath.maxY) {
                            energyPath.maxY = tileEntity.field_70330_m;
                        }
                        if (tileEntity.field_70327_n > energyPath.maxZ) {
                            energyPath.maxZ = tileEntity.field_70327_n;
                        }
                        energyPath.conductors.add(energyConductor);
                        if (energyConductor.getInsulationEnergyAbsorption() < energyPath.minInsulationEnergyAbsorption) {
                            energyPath.minInsulationEnergyAbsorption = energyConductor.getInsulationEnergyAbsorption();
                        }
                        if (energyConductor.getInsulationBreakdownEnergy() < energyPath.minInsulationBreakdownEnergy) {
                            energyPath.minInsulationBreakdownEnergy = energyConductor.getInsulationBreakdownEnergy();
                        }
                        if (energyConductor.getConductorBreakdownEnergy() < energyPath.minConductorBreakdownEnergy) {
                            energyPath.minConductorBreakdownEnergy = energyConductor.getConductorBreakdownEnergy();
                        }
                        if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tileEntity)) != null) continue;
                        IC2.platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + emitter + " (" + emitter.field_70329_l + "," + emitter.field_70330_m + "," + emitter.field_70327_n + ")\n" + "C: " + tileEntity + " (" + tileEntity.field_70329_l + "," + tileEntity.field_70330_m + "," + tileEntity.field_70327_n + ")\n" + "R: " + energyPath.target + " (" + energyPath.target.field_70329_l + "," + energyPath.target.field_70330_m + "," + energyPath.target.field_70327_n + ")");
                        continue;
                    }
                    if (tileEntity == null) continue block2;
                    IC2.log.warning("EnergyNet: EnergyBlockLink corrupted (" + energyPath.target + " [" + energyPath.target.field_70329_l + " " + energyPath.target.field_70330_m + " " + energyPath.target.field_70327_n + "] -> " + tileEntity + " [" + tileEntity.field_70329_l + " " + tileEntity.field_70330_m + " " + tileEntity.field_70327_n + "] -> " + emitter + " [" + emitter.field_70329_l + " " + emitter.field_70330_m + " " + emitter.field_70327_n + "])");
                    continue block2;
                }
            }
            energyPaths.add(energyPath);
        }
        return energyPaths;
    }

    private List<EnergyTarget> getValidReceivers(TileEntity emitter, boolean reverse) {
        LinkedList<EnergyTarget> validReceivers = new LinkedList<EnergyTarget>();
        for (Direction direction : directions) {
            TileEntity target = this.getNeighbor(emitter, direction);
            if (target == null) continue;
            Direction inverseDirection = direction.getInverse();
            if ((reverse || !(emitter instanceof IEnergyEmitter) || !((IEnergyEmitter)emitter).emitsEnergyTo(target, direction)) && (!reverse || !(emitter instanceof IEnergyAcceptor) || !((IEnergyAcceptor)emitter).acceptsEnergyFrom(target, direction)) || (reverse || !(target instanceof IEnergyAcceptor) || !((IEnergyAcceptor)target).acceptsEnergyFrom(emitter, inverseDirection)) && (!reverse || !(target instanceof IEnergyEmitter) || !((IEnergyEmitter)target).emitsEnergyTo(emitter, inverseDirection))) continue;
            validReceivers.add(new EnergyTarget(target, inverseDirection));
        }
        return validReceivers;
    }

    private static class PostPonedAddCallback
    implements ITickCallback {
        private final TileEntity te;

        public PostPonedAddCallback(TileEntity te) {
            this.te = te;
        }

        @Override
        public void tickCallback(World world) {
            if (world.func_72899_e(this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n) && !this.te.func_70320_p()) {
                EnergyNet.getForWorld(world).addTileEntity(this.te);
            } else {
                IC2.log.info("EnergyNet.addTileEntity: " + this.te + " unloaded, aborting");
            }
        }
    }

    static class EnergyTarget {
        TileEntity tileEntity;
        Direction direction;

        EnergyTarget(TileEntity tileEntity, Direction direction) {
            this.tileEntity = tileEntity;
            this.direction = direction;
        }
    }

    static class EnergyBlockLink {
        Direction direction;
        double loss;

        EnergyBlockLink(Direction direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    static class EnergyPath {
        TileEntity target = null;
        Direction targetDirection;
        Set<IEnergyConductor> conductors = new HashSet<IEnergyConductor>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        double loss = 0.0;
        int minInsulationEnergyAbsorption = Integer.MAX_VALUE;
        int minInsulationBreakdownEnergy = Integer.MAX_VALUE;
        int minConductorBreakdownEnergy = Integer.MAX_VALUE;
        long totalEnergyConducted = 0L;

        EnergyPath() {
        }
    }

    public static class EventHandler {
        public EventHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @ForgeSubscribe
        public void onEnergyTileLoad(EnergyTileLoadEvent event) {
            EnergyNet.getForWorld(event.world).addTileEntity((TileEntity)event.energyTile);
        }

        @ForgeSubscribe
        public void onEnergyTileUnload(EnergyTileUnloadEvent event) {
            EnergyNet.getForWorld(event.world).removeTileEntity((TileEntity)event.energyTile);
        }

        @ForgeSubscribe
        public void onEnergyTileSource(EnergyTileSourceEvent event) {
            event.amount = EnergyNet.getForWorld(event.world).emitEnergyFrom((IEnergySource)event.energyTile, event.amount);
        }
    }
}

