/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksItemTreeCategory;
import invtweaks.InvTweaksItemTreeItem;
import invtweaks.api.IItemTreeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.minecraftforge.common.MinecraftForge;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InvTweaksItemTreeLoader
extends DefaultHandler {
    private static final String ATTR_ID = "id";
    private static final String ATTR_DAMAGE = "damage";
    private static final String ATTR_RANGE_MIN = "min";
    private static final String ATTR_RANGE_MAX = "max";
    private static final String ATTR_RANGE_DMIN = "dmin";
    private static final String ATTR_RANGE_DMAX = "dmax";
    private static final String ATTR_OREDICT_NAME = "oreDictName";
    private static final String ATTR_TREE_VERSION = "treeVersion";
    private static InvTweaksItemTree tree;
    private static String treeVersion;
    private static int itemOrder;
    private static LinkedList<String> categoryStack;
    private static boolean treeLoaded;
    private static final List<IItemTreeListener> onLoadListeners;

    private static void init() {
        treeVersion = null;
        tree = new InvTweaksItemTree();
        itemOrder = 0;
        categoryStack = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized InvTweaksItemTree load(String string) throws Exception {
        InvTweaksItemTreeLoader.init();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(new File(string), (DefaultHandler)new InvTweaksItemTreeLoader());
        List<IItemTreeListener> list = onLoadListeners;
        synchronized (list) {
            treeLoaded = true;
            for (IItemTreeListener iItemTreeListener : onLoadListeners) {
                iItemTreeListener.onTreeLoaded(tree);
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)tree);
        return tree;
    }

    public static synchronized boolean isValidVersion(String string) throws Exception {
        InvTweaksItemTreeLoader.init();
        File file = new File(string);
        if (file.exists()) {
            treeVersion = null;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(file, (DefaultHandler)new InvTweaksItemTreeLoader());
            return "1.6.0".equals(treeVersion);
        }
        return false;
    }

    public static synchronized void addOnLoadListener(IItemTreeListener iItemTreeListener) {
        onLoadListeners.add(iItemTreeListener);
        if (treeLoaded) {
            iItemTreeListener.onTreeLoaded(tree);
        }
    }

    public static synchronized boolean removeOnLoadListener(IItemTreeListener iItemTreeListener) {
        return onLoadListeners.remove(iItemTreeListener);
    }

    @Override
    public synchronized void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = attributes.getValue(ATTR_RANGE_MIN);
        String string5 = attributes.getValue(ATTR_RANGE_DMIN);
        String string6 = attributes.getValue(ATTR_TREE_VERSION);
        String string7 = attributes.getValue(ATTR_OREDICT_NAME);
        if (attributes.getLength() == 0 || treeVersion == null || string4 != null || string5 != null) {
            if (treeVersion == null) {
                treeVersion = string6;
            }
            if (categoryStack.isEmpty()) {
                tree.setRootCategory(new InvTweaksItemTreeCategory(string3));
            } else {
                tree.addCategory(categoryStack.getLast(), new InvTweaksItemTreeCategory(string3));
            }
            if (string4 != null) {
                int n = Integer.parseInt(string4);
                int n2 = Integer.parseInt(attributes.getValue(ATTR_RANGE_MAX));
                for (int i = n; i <= n2; ++i) {
                    tree.addItem(string3, new InvTweaksItemTreeItem((string3 + i).toLowerCase(), i, Short.MAX_VALUE, itemOrder++));
                }
            } else if (string5 != null) {
                int n = Integer.parseInt(attributes.getValue(ATTR_ID));
                int n3 = Integer.parseInt(string5);
                int n4 = Integer.parseInt(attributes.getValue(ATTR_RANGE_DMAX));
                for (int i = n3; i <= n4; ++i) {
                    tree.addItem(string3, new InvTweaksItemTreeItem((string3 + n + "-" + i).toLowerCase(), n, i, itemOrder++));
                }
            }
            categoryStack.add(string3);
        } else if (attributes.getValue(ATTR_ID) != null) {
            int n = Integer.parseInt(attributes.getValue(ATTR_ID));
            int n5 = Short.MAX_VALUE;
            if (attributes.getValue(ATTR_DAMAGE) != null) {
                n5 = Integer.parseInt(attributes.getValue(ATTR_DAMAGE));
            }
            tree.addItem(categoryStack.getLast(), new InvTweaksItemTreeItem(string3.toLowerCase(), n, n5, itemOrder++));
        } else if (string7 != null) {
            tree.registerOre(categoryStack.getLast(), string3.toLowerCase(), string7, itemOrder++);
        }
    }

    @Override
    public synchronized void endElement(String string, String string2, String string3) throws SAXException {
        if (!categoryStack.isEmpty() && string3.equals(categoryStack.getLast())) {
            categoryStack.removeLast();
        }
    }

    static {
        treeLoaded = false;
        onLoadListeners = new ArrayList<IItemTreeListener>();
    }
}

