/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class BrewingRecipeHandler
extends TemplateRecipeHandler {
    public static final HashSet<Integer> ingredientIDs = new HashSet();
    public static final HashSet<CachedBrewingRecipe> apotions = new HashSet();

    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(58, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(92, 3, 14, 30), "brewing", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(68, 23, 28, 18), "brewing", new Object[0]));
    }

    @Override
    public Class<? extends awv> getGuiClass() {
        return axe.class;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.brewing", new Object[0]);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("brewing") && this.getClass() == BrewingRecipeHandler.class) {
            for (CachedBrewingRecipe recipe : apotions) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(yd result) {
        if (result.d != yb.bu.cv) {
            return;
        }
        int damage = result.k();
        for (CachedBrewingRecipe recipe : apotions) {
            if (recipe.result.item.k() != damage) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(yd ingredient) {
        if (ingredient.d != yb.bu.cv && !ingredientIDs.contains(ingredient.d)) {
            return;
        }
        for (CachedBrewingRecipe recipe : apotions) {
            if (!NEIServerUtils.areStacksSameType(recipe.ingredient.item, ingredient) && !NEIServerUtils.areStacksSameType(recipe.precursorPotion.item, ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/brewing_stand.png";
    }

    @Override
    public void drawExtras(int recipe) {
        this.drawProgressBar(92, 5, 176, 0, 8, 30, 120, 1);
        this.drawProgressBar(60, 1, 185, -2, 12, 30, 35, 3);
    }

    public void searchPotions() {
        HashSet<Integer> newPotions;
        TreeSet<Integer> allPotions = new TreeSet<Integer>();
        HashSet<Integer> nextLevelPotions = new HashSet<Integer>();
        nextLevelPotions.add(0);
        do {
            newPotions = new HashSet<Integer>();
            for (Integer basePotionID : nextLevelPotions) {
                if (yo.f((int)basePotionID)) continue;
                for (Integer ingredID : ingredientIDs) {
                    int result = zo.a((int)basePotionID, (String)yb.g[ingredID].w());
                    if (yo.f((int)result)) {
                        this.addPotion(ingredID, basePotionID, result, allPotions, newPotions);
                        continue;
                    }
                    List baseMods = yb.bu.c(basePotionID.intValue());
                    List newMods = yb.bu.c(result);
                    if (basePotionID > 0 && baseMods == newMods || baseMods != null && (baseMods.equals(newMods) || newMods == null) || basePotionID == result || this.levelModifierChanged(basePotionID, result)) continue;
                    this.addPotion(ingredID, basePotionID, result, allPotions, newPotions);
                }
            }
        } while ((nextLevelPotions = newPotions).size() > 0);
        allPotions.add(0);
        API.setItemDamageVariants(yb.bu.cv, allPotions);
        API.addSetRange("Items.Potions", new MultiItemRange().add((yb)yb.bu));
        API.addSetRange("Items.Potions.Splash", new MultiItemRange().add((yb)yb.bu, 16384, 32768));
        MultiItemRange positivepots = new MultiItemRange();
        MultiItemRange negativepots = new MultiItemRange();
        MultiItemRange neutralpots = new MultiItemRange();
        for (int potionID : allPotions) {
            Iterator iterator;
            List effectlist = yb.bu.c(potionID);
            int type = 0;
            if (effectlist != null && !effectlist.isEmpty() && (iterator = effectlist.iterator()).hasNext()) {
                ni potioneffect = (ni)iterator.next();
                type = nh.a[potioneffect.a()].f() ? -1 : 1;
            }
            if (type == 0) {
                neutralpots.add((yb)yb.bu, potionID, potionID);
                continue;
            }
            if (type == 1) {
                positivepots.add((yb)yb.bu, potionID, potionID);
                continue;
            }
            if (type != -1) continue;
            negativepots.add((yb)yb.bu, potionID, potionID);
        }
        API.addSetRange("Items.Potions.Positive", positivepots);
        API.addSetRange("Items.Potions.Negative", negativepots);
        API.addSetRange("Items.Potions.Neutral", neutralpots);
    }

    private boolean levelModifierChanged(int basePotionID, int result) {
        int basemod = basePotionID & 0xE0;
        int resultmod = result & 0xE0;
        return basemod != 0 && basemod != resultmod;
    }

    private void addPotion(int ingred, int basePotion, int result, TreeSet<Integer> allPotions, HashSet<Integer> newPotions) {
        apotions.add(new CachedBrewingRecipe(ingred, basePotion, result));
        if (allPotions.add(result)) {
            newPotions.add(result);
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "brewing";
    }

    public class CachedBrewingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        int hashcode;
        PositionedStack precursorPotion;
        PositionedStack result;
        PositionedStack ingredient;

        public CachedBrewingRecipe(int ingredID, int basePotionID, int resultDamage) {
            super(BrewingRecipeHandler.this);
            this.precursorPotion = new PositionedStack(new yd(yb.bu.cv, 1, basePotionID), 51, 35);
            this.ingredient = new PositionedStack(new yd(ingredID, 1, 0), 74, 6);
            this.result = new PositionedStack(new yd(yb.bu.cv, 1, resultDamage), 97, 35);
            this.calculateHashcode();
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.ingredient);
            recipestacks.add(this.precursorPotion);
            return recipestacks;
        }

        private void calculateHashcode() {
            this.hashcode = this.result.item.k() << 16 + this.precursorPotion.item.k();
            this.hashcode = 31 * this.hashcode + (this.ingredient.item.d << 16 + this.ingredient.item.k());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CachedBrewingRecipe)) {
                return false;
            }
            CachedBrewingRecipe recipe2 = (CachedBrewingRecipe)obj;
            return this.result.item.k() == recipe2.result.item.k() && this.precursorPotion.item.k() == recipe2.precursorPotion.item.k() && NEIServerUtils.areStacksSameType(this.ingredient.item, recipe2.ingredient.item);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

