/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.nei.api.GuiInfo;
import codechicken.nei.config.ConfigSet;
import codechicken.nei.config.GuiOptionList;
import codechicken.nei.config.IConfigSetHolder;
import codechicken.nei.config.Option;
import codechicken.nei.config.OptionButton;
import java.util.ArrayList;
import java.util.HashMap;

public class OptionList
extends OptionButton {
    public static final OptionList top = new OptionList(null);
    public ArrayList<Option> optionList = new ArrayList();
    public HashMap<String, Option> options = new HashMap();
    public IConfigSetHolder config;

    public static OptionList getOptionList(String fullName) {
        Option o = top.getOption(fullName);
        if (o == null) {
            o = new OptionList(fullName);
            top.addOption(o);
        }
        return (OptionList)o;
    }

    public static String parent(String fullName) {
        int i = fullName.indexOf(46);
        if (i < 0) {
            return fullName;
        }
        return fullName.substring(0, i);
    }

    public static String child(String fullName) {
        int i = fullName.indexOf(46);
        return fullName.substring(i + 1);
    }

    public OptionList(String name) {
        super(name);
    }

    public OptionList bindConfig(IConfigSetHolder config) {
        this.config = config;
        return this;
    }

    private OptionList subList(String fullName) {
        OptionList o = (OptionList)this.getOption(fullName);
        if (o == null) {
            o = new OptionList(fullName);
            this.addOption(o);
        }
        return o;
    }

    public Option getOption(String fullName) {
        if (fullName.contains(".")) {
            return this.subList(OptionList.parent(fullName)).getOption(OptionList.child(fullName));
        }
        return this.options.get(fullName);
    }

    public void addOption(Option o) {
        o.namespace = this.fullName();
        this.addOption(o, o.fullName(), o.name);
    }

    private void addOption(Option o, String fullName, String subName) {
        if (subName.contains(".")) {
            this.subList(OptionList.parent(subName)).addOption(o, fullName, OptionList.child(subName));
            return;
        }
        if (this.options.containsKey(subName)) {
            System.err.println("Warning, replacing option: " + fullName);
        }
        this.options.put(subName, o);
        this.addSorted(o);
        o.onAdded(this);
    }

    public void addSorted(Option o) {
        this.optionList.add(o);
    }

    public void expandOptionList(OptionList replacement) {
        this.addOption(replacement);
        OptionList base = (OptionList)this.getOption(replacement.name);
        replacement.options = base.options;
        replacement.optionList = base.optionList;
        this.options.remove(base.name);
        this.optionList.remove(base);
    }

    public void showGui(awb parent) {
        GuiInfo.switchGui((awb)new GuiOptionList(parent, this, false));
    }

    public void synthesizeEnvironment() {
        new GuiOptionList(null, this, false).addWidgets();
    }

    @Override
    public boolean onClick(int button) {
        GuiInfo.switchGui((awb)new GuiOptionList((awb)this.slot.getGui(), this, this.slot.getGui().worldConfig()));
        return true;
    }

    @Override
    public boolean showWorldSelector() {
        return false;
    }

    @Override
    public void onAdded(GuiOptionList.OptionScrollSlot slot) {
        super.onAdded(slot);
        this.globalConfigSet().config.getTag(this.configName()).useBraces();
        this.worldConfigSet().config.getTag(this.configName()).useBraces();
    }

    @Override
    public ConfigSet worldConfigSet() {
        return this.config != null ? this.config.worldConfigSet() : super.worldConfigSet();
    }

    @Override
    public ConfigSet globalConfigSet() {
        return this.config != null ? this.config.globalConfigSet() : super.globalConfigSet();
    }

    @Override
    public OptionList configBase() {
        return this.config != null ? this : super.configBase();
    }
}

