/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.NEIActions;
import codechicken.nei.NEISPH;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PlayerSave;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.List;

public class ServerHandler
implements ITickHandler,
IPlayerTracker {
    private static ServerHandler instance;

    public static void load() {
        instance = new ServerHandler();
        PacketCustom.assignHandler((String)"NEI", (int)0, (int)255, (PacketCustom.ICustomPacketHandler)new NEISPH());
        TickRegistry.registerTickHandler((ITickHandler)instance, (Side)Side.SERVER);
        GameRegistry.registerPlayerTracker((IPlayerTracker)instance);
        NEIActions.init();
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            this.processDisabledProperties((abv)tickData[0]);
        }
        if (type.contains(TickType.WORLDLOAD)) {
            NEIServerConfig.load((abv)tickData[0]);
        }
        if (type.contains(TickType.PLAYER)) {
            ju player = (ju)tickData[0];
            PlayerSave save = NEIServerConfig.forPlayer(player.bu);
            if (save == null) {
                return;
            }
            this.updateMagneticPlayer(player, save);
            save.updateOpChange(player);
            save.save();
        }
    }

    private void processDisabledProperties(abv world) {
        NEIServerUtils.advanceDisabledTimes(world);
        if (NEIServerUtils.isRaining(world) && NEIServerConfig.isActionDisabled(CommonUtils.getDimension((abv)world), "rain")) {
            NEIServerUtils.toggleRaining(world, false);
        }
    }

    private void updateMagneticPlayer(ju player, PlayerSave save) {
        if (!save.isActionEnabled("magnet") || player.M) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List items = player.q.a(sr.class, player.E.b((double)distancexz, (double)distancey, (double)distancexz));
        for (sr item : items) {
            double rationspeedy;
            if (item.b > 0 || !NEIServerUtils.canItemFitInInventory((ue)player, item.d())) continue;
            if (item.b == 0) {
                NEISPH.sendAddMagneticItemTo(player, item);
            }
            double dx = player.u - item.u;
            double dy = player.v + (double)player.f() - item.v;
            double dz = player.w - item.w;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz < 1.0) {
                item.b_((ue)player);
            }
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.x + speedxz * dx;
            double vy = item.y + speedy * dy;
            double vz = item.z + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            item.x = vx;
            item.y = vy;
            item.z = vz;
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD, TickType.PLAYER, TickType.WORLDLOAD);
    }

    public String getLabel() {
        return "NEI Server";
    }

    public void onPlayerLogin(ue player) {
        NEIServerConfig.loadPlayer(player);
        NEISPH.sendHasServerSideTo((ju)player);
    }

    public void onPlayerLogout(ue player) {
        NEIServerConfig.unloadPlayer(player);
    }

    public void onPlayerChangedDimension(ue player) {
        NEISPH.sendHasServerSideTo((ju)player);
    }

    public void onPlayerRespawn(ue player) {
        NEISPH.sendHasServerSideTo((ju)player);
    }
}

