/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.ToolRegistry;
import bspkrs.treecapitator.TreeRegistry;

public class RegistryNBTManager {
    private bx localTCSettings;
    private bx localTreeRegistry;
    private bx localToolRegistry;
    private bx remoteTCSettings;
    private bx remoteTreeRegistry;
    private bx remoteToolRegistry;

    public RegistryNBTManager(bx tcSettingsNBT, bx treeRegistryNBT, bx toolRegistryNBT) {
        this();
        this.setRemoteTCSettings(tcSettingsNBT);
        this.setRemoteTreeRegistry(treeRegistryNBT);
        this.setRemoteToolRegistry(toolRegistryNBT);
    }

    public RegistryNBTManager() {
        this.saveCurrentTCSettingsToLocal();
        this.saveCurrentTreeRegistryToLocal();
        this.saveCurrentToolRegistryToLocal();
        this.setRemoteTCSettings(this.localTCSettings);
        this.setRemoteTreeRegistry(this.localTreeRegistry);
        this.setRemoteToolRegistry(this.localToolRegistry);
    }

    protected RegistryNBTManager saveCurrentTCSettingsToLocal() {
        this.localTCSettings = new bx();
        TCSettings.instance().writeToNBT(this.localTCSettings);
        return this;
    }

    protected RegistryNBTManager saveCurrentTreeRegistryToLocal() {
        this.localTreeRegistry = new bx();
        TreeRegistry.instance().writeToNBT(this.localTreeRegistry);
        return this;
    }

    protected RegistryNBTManager saveCurrentToolRegistryToLocal() {
        this.localToolRegistry = new bx();
        ToolRegistry.instance().writeToNBT(this.localToolRegistry);
        return this;
    }

    public RegistryNBTManager setRemoteTCSettings(bx ntc) {
        this.remoteTCSettings = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteTreeRegistry(bx ntc) {
        this.remoteTreeRegistry = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteToolRegistry(bx ntc) {
        this.remoteToolRegistry = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteNBTs(bx set, bx tree, bx tool) {
        return this.setRemoteTCSettings(set).setRemoteTreeRegistry(tree).setRemoteToolRegistry(tool);
    }

    public void registerLocalInstances() {
        TCSettings.instance().readFromNBT(this.localTCSettings);
        TreeRegistry.instance().readFromNBT(this.localTreeRegistry);
        ToolRegistry.instance().readFromNBT(this.localToolRegistry);
    }

    public void registerRemoteInstances() {
        TCSettings.instance().readFromNBT(this.remoteTCSettings);
        TreeRegistry.instance().readFromNBT(this.remoteTreeRegistry);
        ToolRegistry.instance().readFromNBT(this.remoteToolRegistry);
    }

    public Object[] getPacketArray() {
        return new Object[]{this.localTCSettings, this.localTreeRegistry, this.localToolRegistry};
    }
}

