/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import extrabiomes.api.BiomeManager;
import extrabiomes.module.summa.worldgen.WorldGenOasis;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;

public class MountainRidgeGenerator
implements IWorldGenerator {
    private static final WorldGenerator oasisGen = new WorldGenOasis();
    private static final WorldGenerator silverfishGen = new WorldGenMinable(Block.field_72006_bl.field_71990_ca, 8);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase biome = world.func_72807_a(chunkX <<= 4, chunkZ <<= 4);
        if (BiomeManager.mountainridge.isPresent() && biome == BiomeManager.mountainridge.get()) {
            this.trimPondsInGrass(random, chunkX, chunkZ, world);
            this.generateEmeraldOre(random, chunkX, chunkZ, world);
        }
    }

    private void generateEmeraldOre(Random rand, int x, int z, World world) {
        int z1;
        int y1;
        int x1;
        int i;
        int veins = 3 + rand.nextInt(6);
        for (i = 0; i < veins; ++i) {
            x1 = x + rand.nextInt(16);
            int id = world.func_72798_a(x1, y1 = rand.nextInt(28) + 4, z1 = z + rand.nextInt(16));
            if (id == 0 || !Block.field_71973_m[id].isGenMineableReplaceable(world, x1, y1, z1, Block.field_71981_t.field_71990_ca)) continue;
            world.func_94575_c(x1, y1, z1, Block.field_72068_bR.field_71990_ca);
        }
        for (i = 0; i < 7; ++i) {
            x1 = x + rand.nextInt(16);
            y1 = rand.nextInt(64);
            z1 = z + rand.nextInt(16);
            silverfishGen.func_76484_a(world, rand, x1, y1, z1);
        }
    }

    private void trimPondsInGrass(Random rand, int x, int z, World world) {
        for (int i = 0; i < 1000; ++i) {
            int x1 = x + rand.nextInt(16) + 8;
            int z1 = z + rand.nextInt(16) + 8;
            int y1 = world.func_72825_h(x1, z1);
            oasisGen.func_76484_a(world, rand, x1, y1, z1);
        }
    }
}

