/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes;

import com.google.common.base.Optional;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import extrabiomes.Module;
import extrabiomes.PluginManager;
import extrabiomes.biomes.BiomeManagerImpl;
import extrabiomes.events.ModuleEvent;
import extrabiomes.events.ModulePreInitEvent;
import extrabiomes.handlers.BiomeHandler;
import extrabiomes.handlers.BlockHandler;
import extrabiomes.handlers.ConfigurationHandler;
import extrabiomes.handlers.ItemHandler;
import extrabiomes.handlers.RecipeHandler;
import extrabiomes.helpers.LogHelper;
import extrabiomes.localization.LocalizationHandler;
import extrabiomes.module.fabrica.recipe.RecipeManager;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.utility.CreativeTab;
import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.EventBus;

@Mod(modid="ExtrabiomesXL", name="ExtrabiomesXL", version="3.13.6")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class Extrabiomes {
    @Mod.Instance(value="ExtrabiomesXL")
    public static Extrabiomes instance;
    @SidedProxy(clientSide="extrabiomes.proxy.ClientProxy", serverSide="extrabiomes.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs tabsEBXL;
    private static final String LOG_MESSAGE_INITIALIZING = "log.message.initializing";
    private static final String LOG_MESSAGE_LOAD_SUCCESS = "log.message.load.success";
    public static final String TEXTURE_PATH;
    private static Optional<EventBus> initBus;

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) throws InstantiationException, IllegalAccessException {
        proxy.registerRenderInformation();
        Module.postEvent(new ModuleEvent.ModuleInitEvent());
        Extrabiomes.sendTCIMC();
    }

    public static void sendTCIMC() {
        if (Loader.isModLoaded((String)"TreeCapitator")) {
            NBTTagCompound tpModCfg = new NBTTagCompound();
            tpModCfg.func_74778_a("modID", "ExtrabiomesXL");
            tpModCfg.func_74778_a("configPath", "extrabiomes/extrabiomes.cfg");
            tpModCfg.func_74778_a("blockConfigKeys", "block:customlog.id; block:quarterlog0.id; block:quarterlog1.id; block:quarterlog2.id; block:quarterlog3.id; block:autumnleaves.id; block:greenleaves.id");
            tpModCfg.func_74778_a("itemConfigKeys", "");
            tpModCfg.func_74778_a("axeIDList", "");
            tpModCfg.func_74778_a("shearsIDList", "");
            tpModCfg.func_74757_a("useShiftedItemID", true);
            NBTTagList treeList = new NBTTagList();
            NBTTagCompound tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "vanilla_oak");
            tree.func_74778_a("logConfigKeys", "<block:quarterlog0.id>,2; <block:quarterlog1.id>,2; <block:quarterlog2.id>,2; <block:quarterlog3.id>,2;");
            tree.func_74778_a("leafConfigKeys", "<block:autumnleaves.id>");
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "vanilla_spruce");
            tree.func_74778_a("logConfigKeys", "");
            tree.func_74778_a("leafConfigKeys", "<block:autumnleaves.id>");
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "fir");
            tree.func_74778_a("logConfigKeys", "<block:customlog.id>,0; <block:quarterlog0.id>,1; <block:quarterlog1.id>,1; <block:quarterlog2.id>,1; <block:quarterlog3.id>,1");
            tree.func_74778_a("leafConfigKeys", "<block:greenleaves.id>,0; <block:greenleaves.id>,8");
            tree.func_74768_a("maxHorLeafBreakDist", 10);
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "redwood");
            tree.func_74778_a("logConfigKeys", "<block:quarterlog0.id>,0; <block:quarterlog1.id>,0; <block:quarterlog2.id>,0; <block:quarterlog3.id>,0");
            tree.func_74778_a("leafConfigKeys", "<block:greenleaves.id>,1; <block:greenleaves.id>,9");
            tree.func_74768_a("maxHorLeafBreakDist", 10);
            tree.func_74757_a("requireLeafDecayCheck", false);
            treeList.func_74742_a((NBTBase)tree);
            tree = new NBTTagCompound();
            tree.func_74778_a("treeName", "acacia");
            tree.func_74778_a("logConfigKeys", "<block:customlog.id>,1");
            tree.func_74778_a("leafConfigKeys", "<block:greenleaves.id>,2");
            treeList.func_74742_a((NBTBase)tree);
            tpModCfg.func_74782_a("trees", (NBTBase)treeList);
            FMLInterModComms.sendMessage((String)"TreeCapitator", (String)"ExtrabiomesXL", (NBTTagCompound)tpModCfg);
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        PluginManager.activatePlugins();
        RecipeHandler.init();
        initBus = Optional.absent();
        Module.releaseStaticResources();
        LogHelper.info("Successfully Loaded.", new Object[0]);
    }

    public static boolean postInitEvent(Event event) {
        return initBus.isPresent() ? ((EventBus)initBus.get()).post(event) : false;
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) throws Exception {
        LogHelper.info("Intializing.", new Object[0]);
        LocalizationHandler.loadLanguages();
        ConfigurationHandler.init(new File(event.getModConfigurationDirectory(), "/extrabiomes/extrabiomes.cfg"));
        BiomeHandler.init();
        BiomeManagerImpl.populateAPIBiomes();
        new BiomeManagerImpl();
        Extrabiomes.registerInitEventHandler(new RecipeManager());
        BlockHandler.createBlocks();
        ItemHandler.createItems();
        BiomeHandler.registerWorldGenerators();
        BiomeHandler.enableBiomes();
        BiomeManagerImpl.buildWeightedFloraLists();
        Module.registerModules();
        Module.postEvent(new ModulePreInitEvent());
        proxy.addStringLocalization("itemGroup.extrabiomesTab", "en_US", "ExtrabiomesXL");
    }

    public static void registerInitEventHandler(Object target) {
        if (initBus.isPresent()) {
            ((EventBus)initBus.get()).register(target);
        }
    }

    static {
        tabsEBXL = new CreativeTab("extrabiomesTab");
        TEXTURE_PATH = "ExtrabiomesXL".toLowerCase() + ":";
        initBus = Optional.of((Object)new EventBus());
    }
}

