/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.lib;

import extrabiomes.utility.EnhancedConfiguration;
import net.minecraftforge.common.Property;

public enum BlockSettings {
    AUTUMNLEAVES(2200),
    CATTAIL(2201),
    CRACKEDSAND(255),
    FLOWER(2202),
    GRASS(2203),
    GREENLEAVES(2204),
    LEAFPILE(2205),
    REDROCK(254),
    SAPLING(2207),
    CUSTOMLOG(2208),
    QUARTERLOG0(2209),
    QUARTERLOG1(2211),
    QUARTERLOG2(2212),
    QUARTERLOG3(2213),
    QUICKSAND(2214),
    PLANKS(2215),
    WOODSLAB(2216),
    DOUBLEWOODSLAB(2217),
    REDWOODSTAIRS(2218),
    FIRSTAIRS(2219),
    ACACIASTAIRS(2220),
    REDROCKSLAB(2206),
    DOUBLEREDROCKSLAB(2222),
    REDCOBBLESTAIRS(2223),
    REDROCKBRICKSTAIRS(2221),
    WALL(2210);

    private int blockID;
    private final int defaultID;
    private static boolean clearedQuarterLogs;
    static boolean clearedWoodSlabs;

    private BlockSettings(int defaultID) {
        this.blockID = this.defaultID = defaultID;
    }

    public int getID() {
        return this.blockID;
    }

    private String idKey() {
        return this.toString() + ".id";
    }

    private boolean isQuarterLog() {
        return this == QUARTERLOG0 || this == QUARTERLOG1 || this == QUARTERLOG2 || this == QUARTERLOG3;
    }

    public void load(EnhancedConfiguration configuration) {
        BlockSettings[] settings;
        Property property;
        switch (this) {
            case CRACKEDSAND: 
            case REDROCK: {
                property = configuration.getTerrainBlock("block", this.idKey(), this.defaultID, String.format("%s is used in terrain generation. Its id must be less than 256.", this.toString()));
                break;
            }
            default: {
                property = configuration.getBlock(this.idKey(), this.defaultID);
            }
        }
        this.blockID = property.getInt(0);
        if (this.isQuarterLog() && this.blockID == 0 && !clearedQuarterLogs) {
            for (BlockSettings setting : settings = new BlockSettings[]{QUARTERLOG0, QUARTERLOG1, QUARTERLOG2, QUARTERLOG3}) {
                setting.setToZero(configuration);
            }
            clearedQuarterLogs = true;
        }
        if (this == PLANKS && this.blockID == 0) {
            for (BlockSettings setting : settings = new BlockSettings[]{WOODSLAB, DOUBLEWOODSLAB, FIRSTAIRS, REDWOODSTAIRS, ACACIASTAIRS}) {
                setting.setToZero(configuration);
            }
        }
        if (this == REDROCK && this.blockID == 0) {
            for (BlockSettings setting : settings = new BlockSettings[]{REDROCKSLAB, WALL}) {
                setting.setToZero(configuration);
            }
        }
        if (!(this != WOODSLAB && this != DOUBLEWOODSLAB || this.blockID != 0 || clearedWoodSlabs)) {
            for (BlockSettings setting : settings = new BlockSettings[]{WOODSLAB, DOUBLEWOODSLAB}) {
                setting.setToZero(configuration);
            }
            clearedWoodSlabs = true;
        }
        if (!(this != REDROCKSLAB && this != DOUBLEREDROCKSLAB || this.blockID != 0 || clearedWoodSlabs)) {
            for (BlockSettings setting : settings = new BlockSettings[]{REDROCKSLAB, DOUBLEREDROCKSLAB}) {
                setting.setToZero(configuration);
            }
            clearedWoodSlabs = true;
        }
    }

    private void setToZero(EnhancedConfiguration configuration) {
        Property property = configuration.getBlock(this.idKey(), 0);
        property.set(Integer.toString(0));
        this.blockID = 0;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    static {
        clearedQuarterLogs = false;
        clearedWoodSlabs = false;
    }
}

