/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.List;
import java.util.Random;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.world.MapGenTFMajorFeature;
import twilightforest.world.TFGenCaves;
import twilightforest.world.TFGenRavine;
import twilightforest.world.TFWorld;

public class ChunkProviderTwilightForest
implements adn {
    private Random rand;
    private ajq noiseGen1;
    private ajq noiseGen2;
    private ajq noiseGen3;
    private ajq noiseGen4;
    public ajq noiseGen5;
    public ajq noiseGen6;
    public ajq mobSpawnerNoise;
    private abv worldObj;
    private final boolean mapFeaturesEnabled;
    private double[] landMap;
    private double[] stoneNoise = new double[256];
    private TFGenCaves caveGenerator = new TFGenCaves();
    private TFGenRavine ravineGenerator;
    private acp[] biomesForGeneration;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] squareTable;
    int[][] unusedIntArray32x32;
    private MapGenTFMajorFeature majorFeatureGenerator = new MapGenTFMajorFeature();

    public ChunkProviderTwilightForest(abv world, long l, boolean flag) {
        this.ravineGenerator = new TFGenRavine();
        this.unusedIntArray32x32 = new int[32][32];
        this.worldObj = world;
        this.mapFeaturesEnabled = flag;
        this.rand = new Random(l);
        this.noiseGen1 = new ajq(this.rand, 16);
        this.noiseGen2 = new ajq(this.rand, 16);
        this.noiseGen3 = new ajq(this.rand, 8);
        this.noiseGen4 = new ajq(this.rand, 4);
        this.noiseGen5 = new ajq(this.rand, 10);
        this.noiseGen6 = new ajq(this.rand, 16);
        this.mobSpawnerNoise = new ajq(this.rand, 8);
    }

    public void generateTerrain(int par1, int par2, short[] par3ArrayofShort) {
        int byte0 = 4;
        int byte1 = 8;
        byte byte2 = (byte)TFWorld.SEALEVEL;
        int i = byte0 + 1;
        int byte3 = 9;
        int j = byte0 + 1;
        this.biomesForGeneration = this.worldObj.u().a(this.biomesForGeneration, par1 * 4 - 2, par2 * 4 - 2, i + 5, j + 5);
        this.landMap = this.makeLandPerBiome(this.landMap, par1 * byte0, 0, par2 * byte0, i, byte3, j);
        for (int k = 0; k < byte0; ++k) {
            for (int l = 0; l < byte0; ++l) {
                for (int i1 = 0; i1 < byte1; ++i1) {
                    double d = 0.125;
                    double d1 = this.landMap[((k + 0) * j + (l + 0)) * byte3 + (i1 + 0)];
                    double d2 = this.landMap[((k + 0) * j + (l + 1)) * byte3 + (i1 + 0)];
                    double d3 = this.landMap[((k + 1) * j + (l + 0)) * byte3 + (i1 + 0)];
                    double d4 = this.landMap[((k + 1) * j + (l + 1)) * byte3 + (i1 + 0)];
                    double d5 = (this.landMap[((k + 0) * j + (l + 0)) * byte3 + (i1 + 1)] - d1) * d;
                    double d6 = (this.landMap[((k + 0) * j + (l + 1)) * byte3 + (i1 + 1)] - d2) * d;
                    double d7 = (this.landMap[((k + 1) * j + (l + 0)) * byte3 + (i1 + 1)] - d3) * d;
                    double d8 = (this.landMap[((k + 1) * j + (l + 1)) * byte3 + (i1 + 1)] - d4) * d;
                    for (int j1 = 0; j1 < 8; ++j1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k1 = 0; k1 < 4; ++k1) {
                            int l1 = k1 + k * 4 << 11 | 0 + l * 4 << 7 | i1 * 8 + j1;
                            int c = 128;
                            l1 -= c;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            d15 -= d16;
                            for (int i2 = 0; i2 < 4; ++i2) {
                                double d17;
                                d15 += d16;
                                par3ArrayofShort[l1 += c] = d17 > 0.0 ? (short)aqw.y.cF : (i1 * 8 + j1 < byte2 ? (short)aqw.G.cF : (short)0);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, short[] blockArray4096, acp[] par4ArrayOfBiomeGenBase) {
        byte sealevel = (byte)TFWorld.SEALEVEL;
        double d = 0.03125;
        this.stoneNoise = this.noiseGen4.a(this.stoneNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                acp biomegenbase = par4ArrayOfBiomeGenBase[j + i * 16];
                if (biomegenbase == null) {
                    biomegenbase = TFBiomeBase.twilightForest;
                }
                float f = biomegenbase.j();
                int k = (int)(this.stoneNoise[i + j * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int l = -1;
                short top = biomegenbase.A;
                short filler = biomegenbase.B;
                for (int i1 = 127; i1 >= 0; --i1) {
                    int j1 = (j * 16 + i) * 128 + i1;
                    if (i1 <= 0 + this.rand.nextInt(5)) {
                        blockArray4096[j1] = (short)aqw.E.cF;
                        continue;
                    }
                    short currentBlock = blockArray4096[j1];
                    if (currentBlock != aqw.y.cF) continue;
                    if (l == -1) {
                        if (k <= 0) {
                            top = 0;
                            filler = (short)aqw.y.cF;
                        } else if (i1 >= sealevel - 4 && i1 <= sealevel + 1) {
                            top = biomegenbase.A;
                            filler = biomegenbase.B;
                        }
                        if (i1 < sealevel && top == 0) {
                            top = f < 0.15f ? (short)aqw.aY.cF : (short)aqw.G.cF;
                        }
                        l = k;
                        if (i1 >= sealevel - 1) {
                            blockArray4096[j1] = top;
                            continue;
                        }
                        blockArray4096[j1] = filler;
                        continue;
                    }
                    if (l <= 0) continue;
                    blockArray4096[j1] = filler;
                    if (--l != 0 || filler != aqw.J.cF) continue;
                    l = this.rand.nextInt(4);
                    filler = (short)aqw.V.cF;
                }
            }
        }
    }

    public adq c(int i, int j) {
        return this.d(i, j);
    }

    public adq d(int cx, int cz) {
        this.rand.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
        short[] blockStorage = new short[32768];
        byte[] metaStorage = new byte[32768];
        this.generateTerrain(cx, cz, blockStorage);
        this.biomesForGeneration = this.worldObj.u().b(this.biomesForGeneration, cx * 16, cz * 16, 16, 16);
        this.addGlaciers(cx, cz, blockStorage, metaStorage, this.biomesForGeneration);
        this.raiseHills(cx, cz, blockStorage);
        this.addDarkForestCanopy(cx, cz, blockStorage, metaStorage, this.biomesForGeneration);
        this.replaceBlocksForBiome(cx, cz, blockStorage, this.biomesForGeneration);
        this.addFeatureMarker(cx, cz, blockStorage, metaStorage);
        this.caveGenerator.generate(this, this.worldObj, cx, cz, blockStorage);
        this.ravineGenerator.generate(this, this.worldObj, cx, cz, blockStorage);
        byte[] fake = new byte[]{};
        this.majorFeatureGenerator.a(this, this.worldObj, cx, cz, fake);
        adq chunk = this.makeAChunk(this.worldObj, blockStorage, metaStorage, cx, cz);
        byte[] chunkBiomes = chunk.m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.biomesForGeneration[i].N;
        }
        chunk.b();
        return chunk;
    }

    protected adq makeAChunk(abv world, short[] ids, byte[] metadata, int chunkX, int chunkZ) {
        adq chunk = new adq(world, chunkX, chunkZ);
        adr[] storageArrays = chunk.i();
        int height = ids.length / 256;
        for (int x = 0; x < 16; ++x) {
            for (int z2 = 0; z2 < 16; ++z2) {
                for (int y = 0; y < height; ++y) {
                    int index = x << 11 | z2 << 7 | y;
                    int id = ids[index] & 0xFFF;
                    byte meta = metadata[index];
                    if (id <= 0) continue;
                    int storageIndex = y >> 4;
                    if (storageArrays[storageIndex] == null) {
                        storageArrays[storageIndex] = new adr(storageIndex << 4, true);
                    }
                    storageArrays[storageIndex].a(x, y & 0xF, z2, id);
                    storageArrays[storageIndex].b(x, y & 0xF, z2, (int)meta);
                }
            }
        }
        return chunk;
    }

    public void raiseHills(int cx, int cz, short[] storage) {
        TFFeature nearFeature = TFFeature.getNearestFeature(cx, cz, this.worldObj);
        if (nearFeature == TFFeature.nothing) {
            return;
        }
        int[] nearCenter = TFFeature.getNearestCenter(cx, cz, this.worldObj);
        double hdiam = (double)(nearFeature.size * 2 + 1) * 16.0;
        int hx = nearCenter[0];
        int hz = nearCenter[1];
        for (int x = 0; x < 16; ++x) {
            for (int z2 = 0; z2 < 16; ++z2) {
                int index;
                int y;
                int oldGround = -1;
                int newGround = -1;
                int dx = x - hx;
                int dz2 = z2 - hz;
                int dist = (int)Math.sqrt(dx * dx + dz2 * dz2);
                int hheight = (int)(Math.cos((double)dist / hdiam * Math.PI) * (hdiam / 3.0));
                if (nearFeature == TFFeature.hill1 || nearFeature == TFFeature.hill2 || nearFeature == TFFeature.hill3 || nearFeature == TFFeature.hydraLair) {
                    for (int y2 = 0; y2 <= 127; ++y2) {
                        int index2 = (x * 16 + z2) * TFWorld.WORLDHEIGHT + y2;
                        short currentTerrain = storage[index2];
                        if (currentTerrain != 0 && currentTerrain != aqw.aY.cF) continue;
                        if (newGround == -1) {
                            oldGround = y2;
                            newGround = oldGround + hheight;
                        }
                        if (y2 > newGround) continue;
                        storage[index2] = (short)aqw.y.cF;
                    }
                    int hollow = hheight - 4 - nearFeature.size;
                    if (nearFeature == TFFeature.hydraLair) {
                        int mx = dx + 16;
                        int mz = dz2 + 16;
                        int mdist = (int)Math.sqrt(mx * mx + mz * mz);
                        int mheight = (int)(Math.cos((double)mdist / (hdiam / 1.5) * Math.PI) * (hdiam / 1.5));
                        hollow = Math.max(mheight - 4, hollow);
                    }
                    if (hollow < 0) {
                        hollow = 0;
                    }
                    for (int y3 = 0; y3 <= 127; ++y3) {
                        int index3 = (x * 16 + z2) * TFWorld.WORLDHEIGHT + y3;
                        if (hheight > 0 && y3 < TFWorld.SEALEVEL && storage[index3] != aqw.y.cF) {
                            storage[index3] = (short)aqw.y.cF;
                        }
                        int hollowFloor = TFWorld.SEALEVEL - 3 - hollow / 8;
                        if (nearFeature == TFFeature.hydraLair) {
                            hollowFloor = TFWorld.SEALEVEL;
                        }
                        if (y3 <= hollowFloor || y3 >= hollowFloor + hollow) continue;
                        storage[index3] = 0;
                    }
                }
                if (nearFeature != TFFeature.hedgeMaze && nearFeature != TFFeature.nagaLair && nearFeature != TFFeature.questGrove) continue;
                float squishfactor = 0.0f;
                int mazeheight = TFWorld.SEALEVEL + 1;
                int FEATUREBOUNDRY = (nearFeature.size * 2 + 1) * 8 - 8;
                if (dx <= -FEATUREBOUNDRY) {
                    squishfactor = (float)(-dx - FEATUREBOUNDRY) / 8.0f;
                }
                if (dx >= FEATUREBOUNDRY) {
                    squishfactor = (float)(dx - FEATUREBOUNDRY) / 8.0f;
                }
                if (dz2 <= -FEATUREBOUNDRY) {
                    squishfactor = Math.max(squishfactor, (float)(-dz2 - FEATUREBOUNDRY) / 8.0f);
                }
                if (dz2 >= FEATUREBOUNDRY) {
                    squishfactor = Math.max(squishfactor, (float)(dz2 - FEATUREBOUNDRY) / 8.0f);
                }
                if (squishfactor > 0.0f) {
                    newGround = -1;
                    for (y = 0; y <= 127; ++y) {
                        index = (x * 16 + z2) * TFWorld.WORLDHEIGHT + y;
                        short currentTerrain = storage[index];
                        if (currentTerrain == aqw.y.cF || newGround != -1) continue;
                        oldGround = y;
                        mazeheight = (int)((float)mazeheight + (float)(oldGround - mazeheight) * squishfactor);
                        newGround = oldGround;
                    }
                }
                for (y = 0; y <= 127; ++y) {
                    index = (x * 16 + z2) * TFWorld.WORLDHEIGHT + y;
                    if (y < mazeheight && (storage[index] == 0 || storage[index] == aqw.G.cF)) {
                        storage[index] = (short)aqw.y.cF;
                    }
                    if (y < mazeheight || storage[index] == aqw.G.cF) continue;
                    storage[index] = 0;
                }
            }
        }
    }

    private double[] makeLandPerBiome(double[] ad2, int xx, int zero, int zz, int l, int i1, int j1) {
        if (ad2 == null) {
            ad2 = new double[l * i1 * j1];
        }
        if (this.squareTable == null) {
            this.squareTable = new float[25];
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    float f;
                    this.squareTable[k1 + 2 + (l1 + 2) * 5] = f = 10.0f / lr.c((float)((float)(k1 * k1 + l1 * l1) + 0.2f));
                }
            }
        }
        double d = 684.412;
        double d1 = 684.412;
        this.noise5 = this.noiseGen5.a(this.noise5, xx, zz, l, j1, 1.121, 1.121, 0.5);
        this.noise6 = this.noiseGen6.a(this.noise6, xx, zz, l, j1, 200.0, 200.0, 0.5);
        this.noise3 = this.noiseGen3.a(this.noise3, xx, zero, zz, l, i1, j1, d / 80.0, d1 / 160.0, d / 80.0);
        this.noise1 = this.noiseGen1.a(this.noise1, xx, zero, zz, l, i1, j1, d, d1, d);
        this.noise2 = this.noiseGen2.a(this.noise2, xx, zero, zz, l, i1, j1, d, d1, d);
        zz = 0;
        xx = 0;
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < l; ++k2) {
            for (int l2 = 0; l2 < j1; ++l2) {
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int byte0 = 2;
                acp biomegenbase = this.biomesForGeneration[k2 + 2 + (l2 + 2) * (l + 5)];
                for (int i3 = -byte0; i3 <= byte0; ++i3) {
                    for (int j3 = -byte0; j3 <= byte0; ++j3) {
                        acp biomegenbase1 = this.biomesForGeneration[k2 + i3 + 2 + (l2 + j3 + 2) * (l + 5)];
                        float f4 = this.squareTable[i3 + 2 + (j3 + 2) * 5] / (biomegenbase1.D + 2.0f);
                        if (biomegenbase1.D > biomegenbase.D) {
                            f4 /= 2.0f;
                        }
                        f1 += biomegenbase1.E * f4;
                        f2 += biomegenbase1.D * f4;
                        f3 += f4;
                    }
                }
                f1 /= f3;
                f2 /= f3;
                f1 = f1 * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d2 = this.noise6[j2] / 8000.0;
                if (d2 < 0.0) {
                    d2 = -d2 * 0.3;
                }
                if ((d2 = d2 * 3.0 - 2.0) < 0.0) {
                    if ((d2 /= 2.0) < -1.0) {
                        d2 = -1.0;
                    }
                    d2 /= 1.4;
                    d2 /= 2.0;
                } else {
                    if (d2 > 1.0) {
                        d2 = 1.0;
                    }
                    d2 /= 8.0;
                }
                ++j2;
                for (int k3 = 0; k3 < i1; ++k3) {
                    double d3 = f2;
                    double d4 = f1;
                    d3 += d2 * 0.2;
                    d3 = d3 * (double)i1 / 16.0;
                    double d5 = (double)i1 / 2.0 + d3 * 4.0;
                    double d6 = 0.0;
                    double d7 = ((double)k3 - d5) * 12.0 * 128.0 / (double)TFWorld.WORLDHEIGHT / d4;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.noise1[i2] / 512.0;
                    double d9 = this.noise2[i2] / 512.0;
                    double d10 = (this.noise3[i2] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k3 > i1 - 4) {
                        double d11 = (float)(k3 - (i1 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    ad2[i2] = d6;
                    ++i2;
                }
            }
        }
        return ad2;
    }

    private void addFeatureMarker(int cx, int cz, short[] blockStorage, byte[] metaStorage) {
        TFFeature feature = TFFeature.getFeatureDirectlyAt(cx, cz, this.worldObj);
        if (feature != TFFeature.nothing) {
            byte featureLowNibble = (byte)(feature.featureID & 0xF);
            byte featureHighNibble = (byte)((feature.featureID & 0xF0) >> 4);
            blockStorage[0] = (short)aqw.E.cF;
            blockStorage[1] = (short)aqw.E.cF;
            blockStorage[2] = (short)aqw.E.cF;
            metaStorage[0] = featureLowNibble;
            metaStorage[1] = featureHighNibble;
            metaStorage[2] = 1;
        }
    }

    public void addGlaciers(int chunkX, int chunkZ, short[] blocks, byte[] meta, acp[] biomes) {
        for (int x = 0; x < 16; ++x) {
            for (int z2 = 0; z2 < 16; ++z2) {
                acp biome = biomes[z2 + x * 16];
                if (biome != TFBiomeBase.glacier) continue;
                int topLevel = -1;
                for (int y = 127; y >= 0; --y) {
                    int index = (z2 * 16 + x) * 128 + y;
                    short cb = blocks[index];
                    if (cb != aqw.y.cF) continue;
                    topLevel = y;
                    blocks[index] = (short)aqw.K.cF;
                    break;
                }
                int gHeight = 32;
                int gTop = topLevel + gHeight + 1;
                for (int y = topLevel + 1; y <= gTop && y < 128; ++y) {
                    int index = (z2 * 16 + x) * 128 + y;
                    blocks[index] = (short)aqw.aY.cF;
                }
            }
        }
    }

    public void addDarkForestCanopy(int chunkX, int chunkZ, short[] blocks, byte[] meta, acp[] biomes) {
        double d = 0.03125;
        this.stoneNoise = this.noiseGen4.a(this.stoneNoise, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int x = 0; x < 16; ++x) {
            for (int z2 = 0; z2 < 16; ++z2) {
                int index;
                short currentBlock;
                boolean generateForest;
                acp biome = biomes[z2 + x * 16];
                boolean bl = generateForest = biome == TFBiomeBase.darkForest;
                if ((biome == TFBiomeBase.majorFeature || biome == TFBiomeBase.minorFeature) && z2 + 1 + x * 16 < biomes.length) {
                    boolean bl2 = generateForest = biomes[z2 + 1 + x * 16] == TFBiomeBase.darkForest;
                }
                if (!generateForest) continue;
                int topLevel = -1;
                for (int y = 127; y >= 0 && (currentBlock = blocks[index = (z2 * 16 + x) * 128 + y]) != aqw.G.cF; --y) {
                    if (currentBlock != aqw.y.cF) continue;
                    topLevel = y;
                    break;
                }
                if (topLevel == -1) continue;
                int noise = (int)(this.stoneNoise[x + z2 * 16] / 2.0);
                int treeBottom = topLevel + 7 - noise;
                int treeTop = treeBottom + 6 + noise;
                for (int y = treeBottom; y <= treeTop; ++y) {
                    int index2 = (z2 * 16 + x) * 128 + y;
                    blocks[index2] = (short)TFBlocks.hedge.cF;
                    meta[index2] = 1;
                }
            }
        }
    }

    public boolean a(int i, int j) {
        return true;
    }

    public void a(adn ichunkprovider, int chunkX, int chunkZ) {
        aop.c = true;
        int mapX = chunkX * 16;
        int mapY = chunkZ * 16;
        acp biomegenbase = this.worldObj.a(mapX + 16, mapY + 16);
        if (biomegenbase == TFBiomeBase.majorFeature || biomegenbase == TFBiomeBase.minorFeature) {
            biomegenbase = this.worldObj.a(mapX + 17, mapY + 17);
        }
        this.rand.setSeed(this.worldObj.H());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * l1 + (long)chunkZ * l2 ^ this.worldObj.H());
        boolean disableFeatures = false;
        disableFeatures |= this.majorFeatureGenerator.a(this.worldObj, this.rand, chunkX, chunkZ);
        if (!(disableFeatures |= !TFFeature.getNearestFeature((int)chunkX, (int)chunkZ, (abv)this.worldObj).chunkDecorationsEnabled) && this.rand.nextInt(4) == 0) {
            int i1 = mapX + this.rand.nextInt(16) + 8;
            int i2 = this.rand.nextInt(TFWorld.WORLDHEIGHT);
            int i3 = mapY + this.rand.nextInt(16) + 8;
            new afl(aqw.G.cF).a(this.worldObj, this.rand, i1, i2, i3);
        }
        if (!disableFeatures && this.rand.nextInt(32) == 0) {
            int j1 = mapX + this.rand.nextInt(16) + 8;
            int j2 = this.rand.nextInt(this.rand.nextInt(TFWorld.WORLDHEIGHT - 8) + 8);
            int j3 = mapY + this.rand.nextInt(16) + 8;
            if (j2 < TFWorld.SEALEVEL || this.rand.nextInt(10) == 0) {
                new afl(aqw.I.cF).a(this.worldObj, this.rand, j1, j2, j3);
            }
        }
        for (int k1 = 0; k1 < 8; ++k1) {
            int l3;
            int k3;
            int k2 = mapX + this.rand.nextInt(16) + 8;
            if (new afo().a(this.worldObj, this.rand, k2, k3 = this.rand.nextInt(TFWorld.WORLDHEIGHT), l3 = mapY + this.rand.nextInt(16) + 8)) continue;
        }
        biomegenbase.a(this.worldObj, this.rand, mapX, mapY);
        ach.a((abv)this.worldObj, (acp)biomegenbase, (int)(mapX + 8), (int)(mapY + 8), (int)16, (int)16, (Random)this.rand);
        mapX += 8;
        mapY += 8;
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                int j4 = this.worldObj.h(mapX + i2, mapY + j3);
                if (this.worldObj.x(i2 + mapX, j4 - 1, j3 + mapY)) {
                    this.worldObj.f(i2 + mapX, j4 - 1, j3 + mapY, aqw.aY.cF, 0, 2);
                }
                if (!this.worldObj.z(i2 + mapX, j4, j3 + mapY)) continue;
                this.worldObj.f(i2 + mapX, j4, j3 + mapY, aqw.aX.cF, 0, 2);
            }
        }
        aop.c = false;
    }

    public boolean a(boolean flag, lw iprogressupdate) {
        return true;
    }

    public boolean d() {
        return true;
    }

    public String e() {
        return "TwilightLevelSource";
    }

    public List<acq> a(og creatureType, int mapX, int mapY, int mapZ) {
        int spawnListIndex;
        TFFeature nearestFeature = TFFeature.getNearestFeatureIncludeMore(mapX >> 4, mapZ >> 4, this.worldObj);
        if (nearestFeature != TFFeature.nothing && (spawnListIndex = this.majorFeatureGenerator.getSpawnListIndexAt(mapX, mapY, mapZ)) >= 0) {
            return nearestFeature.getSpawnableList(creatureType, spawnListIndex);
        }
        if (mapY < TFWorld.SEALEVEL && creatureType == og.a) {
            return TFFeature.underground.getSpawnableList(creatureType);
        }
        acp biomegenbase = this.worldObj.a(mapX, mapZ);
        if (biomegenbase == null) {
            return null;
        }
        return biomegenbase.a(creatureType);
    }

    public acn a(abv par1World, String par2Str, int par3, int par4, int par5) {
        return null;
    }

    public int f() {
        return 0;
    }

    public void e(int var1, int var2) {
        this.majorFeatureGenerator.a(this, this.worldObj, var1, var2, null);
    }

    public boolean c() {
        return false;
    }

    public void b() {
    }
}

