/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import twilightforest.structures.stronghold.ComponentTFStrongholdAtrium;
import twilightforest.structures.stronghold.ComponentTFStrongholdBalconyRoom;
import twilightforest.structures.stronghold.ComponentTFStrongholdBossRoom;
import twilightforest.structures.stronghold.ComponentTFStrongholdCrossing;
import twilightforest.structures.stronghold.ComponentTFStrongholdDeadEnd;
import twilightforest.structures.stronghold.ComponentTFStrongholdFoundry;
import twilightforest.structures.stronghold.ComponentTFStrongholdLeftTurn;
import twilightforest.structures.stronghold.ComponentTFStrongholdRightTurn;
import twilightforest.structures.stronghold.ComponentTFStrongholdSmallHallway;
import twilightforest.structures.stronghold.ComponentTFStrongholdSmallStairs;
import twilightforest.structures.stronghold.ComponentTFStrongholdTrainingRoom;
import twilightforest.structures.stronghold.ComponentTFStrongholdTreasureCorridor;
import twilightforest.structures.stronghold.ComponentTFStrongholdTreasureRoom;
import twilightforest.structures.stronghold.StructureTFStrongholdComponent;
import twilightforest.structures.stronghold.TFStrongholdPieceWeight;

public class TFStrongholdPieces {
    private static final TFStrongholdPieceWeight[] pieceWeightArray = new TFStrongholdPieceWeight[]{new TFStrongholdPieceWeight(ComponentTFStrongholdSmallHallway.class, 40, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdLeftTurn.class, 20, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdCrossing.class, 10, 4), new TFStrongholdPieceWeight(ComponentTFStrongholdRightTurn.class, 20, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdDeadEnd.class, 5, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdBalconyRoom.class, 10, 3, 2), new TFStrongholdPieceWeight(ComponentTFStrongholdTrainingRoom.class, 10, 2), new TFStrongholdPieceWeight(ComponentTFStrongholdSmallStairs.class, 10, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdTreasureCorridor.class, 5, 0), new TFStrongholdPieceWeight(ComponentTFStrongholdAtrium.class, 5, 2, 3), new TFStrongholdPieceWeight(ComponentTFStrongholdFoundry.class, 5, 1, 4), new TFStrongholdPieceWeight(ComponentTFStrongholdTreasureRoom.class, 5, 1, 4), new TFStrongholdPieceWeight(ComponentTFStrongholdBossRoom.class, 10, 1, 4)};
    private List<TFStrongholdPieceWeight> pieceList;
    static int totalWeight = 0;
    private static Class lastPieceMade;

    public void prepareStructurePieces() {
        this.pieceList = new ArrayList<TFStrongholdPieceWeight>();
        for (TFStrongholdPieceWeight piece : pieceWeightArray) {
            piece.instancesSpawned = 0;
            this.pieceList.add(piece);
        }
    }

    public void markBossRoomUsed() {
        this.pieceList.remove(this.pieceList.size() - 1);
    }

    private boolean hasMoreLimitedPieces() {
        boolean flag = false;
        totalWeight = 0;
        for (TFStrongholdPieceWeight piece : this.pieceList) {
            totalWeight += piece.pieceWeight;
            if (piece.instancesLimit <= 0 || piece.instancesSpawned >= piece.instancesLimit) continue;
            flag = true;
        }
        return flag;
    }

    public StructureTFStrongholdComponent getNextComponent(aiq parent, List list, Random random, int index, int facing, int x, int y, int z2) {
        if (!this.hasMoreLimitedPieces()) {
            return null;
        }
        block0: for (int i = 0; i < 5; ++i) {
            int counter = random.nextInt(totalWeight);
            for (TFStrongholdPieceWeight piece : this.pieceList) {
                if ((counter -= piece.pieceWeight) >= 0) continue;
                if (!piece.isDeepEnough(index) || piece.pieceClass == lastPieceMade) continue block0;
                StructureTFStrongholdComponent component = TFStrongholdPieces.instantiateComponent(piece.pieceClass, index, facing, x, y, z2);
                if (aiq.a((List)list, (age)component.b()) != null) continue;
                ++piece.instancesSpawned;
                if (!piece.canSpawnMoreStructures()) {
                    this.pieceList.remove(piece);
                }
                lastPieceMade = piece.pieceClass;
                return component;
            }
        }
        ComponentTFStrongholdDeadEnd deadEnd = new ComponentTFStrongholdDeadEnd(index, facing, x, y, z2);
        if (aiq.a((List)list, (age)deadEnd.b()) == null) {
            return deadEnd;
        }
        return null;
    }

    private static StructureTFStrongholdComponent instantiateComponent(Class pieceClass, int index, int facing, int x, int y, int z2) {
        try {
            return (StructureTFStrongholdComponent)((Object)pieceClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(index, facing, x, y, z2));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }
}

