/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.world.TFGenCanopyTree;

public class TFMaze {
    public int width;
    public int depth;
    public int oddBias = 3;
    public int evenBias = 1;
    public int tall = 3;
    public int head = 0;
    public int roots = 0;
    public int worldX;
    public int worldY;
    public int worldZ;
    public int type;
    public int wallBlockID;
    public int wallBlockMeta;
    public int wallVar0ID;
    public int wallVar0Meta;
    public float wallVarRarity;
    public int headBlockID;
    public int headBlockMeta;
    public int rootBlockID;
    public int rootBlockMeta;
    public int pillarBlockID;
    public int pillarBlockMeta;
    public int doorBlockID;
    public int doorBlockMeta;
    public float doorRarity;
    public int torchBlockID;
    public int torchBlockMeta;
    public float torchRarity;
    protected int rawWidth;
    protected int rawDepth;
    protected int[] storage;
    public static final int OUT_OF_BOUNDS = Integer.MIN_VALUE;
    public static final int OOB = Integer.MIN_VALUE;
    public static final int ROOM = 5;
    public static final int DOOR = 6;
    Random rand;

    public TFMaze(int cellsWidth, int cellsDepth) {
        this.wallBlockID = TFBlocks.mazestone.cF;
        this.wallBlockMeta = 2;
        this.rootBlockID = TFBlocks.mazestone.cF;
        this.rootBlockMeta = 0;
        this.torchBlockID = aqw.av.cF;
        this.pillarBlockID = -1;
        this.torchBlockMeta = 0;
        this.torchRarity = 0.75f;
        this.doorRarity = 0.0f;
        this.width = cellsWidth;
        this.depth = cellsDepth;
        this.rawWidth = this.width * 2 + 1;
        this.rawDepth = this.depth * 2 + 1;
        this.storage = new int[this.rawWidth * this.rawDepth];
        this.rand = new Random();
    }

    public int getCell(int x, int z2) {
        return this.getRaw(x * 2 + 1, z2 * 2 + 1);
    }

    public void putCell(int x, int z2, int value) {
        this.putRaw(x * 2 + 1, z2 * 2 + 1, value);
    }

    public boolean cellEquals(int x, int z2, int value) {
        return this.getCell(x, z2) == value;
    }

    public int getWall(int sx, int sz, int dx, int dz2) {
        if (dx == sx + 1 && dz2 == sz) {
            return this.getRaw(sx * 2 + 2, sz * 2 + 1);
        }
        if (dx == sx - 1 && dz2 == sz) {
            return this.getRaw(sx * 2 + 0, sz * 2 + 1);
        }
        if (dx == sx && dz2 == sz + 1) {
            return this.getRaw(sx * 2 + 1, sz * 2 + 2);
        }
        if (dx == sx && dz2 == sz - 1) {
            return this.getRaw(sx * 2 + 1, sz * 2 + 0);
        }
        System.out.println("Wall check out of bounds; s = " + sx + ", " + sz + "; d = " + dx + ", " + dz2);
        return Integer.MIN_VALUE;
    }

    public void putWall(int sx, int sz, int dx, int dz2, int value) {
        if (dx == sx + 1 && dz2 == sz) {
            this.putRaw(sx * 2 + 2, sz * 2 + 1, value);
        }
        if (dx == sx - 1 && dz2 == sz) {
            this.putRaw(sx * 2 + 0, sz * 2 + 1, value);
        }
        if (dx == sx && dz2 == sz + 1) {
            this.putRaw(sx * 2 + 1, sz * 2 + 2, value);
        }
        if (dx == sx && dz2 == sz - 1) {
            this.putRaw(sx * 2 + 1, sz * 2 + 0, value);
        }
    }

    public boolean isWall(int sx, int sz, int dx, int dz2) {
        return this.getWall(sx, sz, dx, dz2) == 0;
    }

    public void putRaw(int rawx, int rawz, int value) {
        if (rawx >= 0 && rawx < this.rawWidth && rawz >= 0 && rawz < this.rawDepth) {
            this.storage[rawz * this.rawWidth + rawx] = value;
        }
    }

    protected int getRaw(int rawx, int rawz) {
        if (rawx < 0 || rawx >= this.rawWidth || rawz < 0 || rawz >= this.rawDepth) {
            return Integer.MIN_VALUE;
        }
        return this.storage[rawz * this.rawWidth + rawx];
    }

    public void setSeed(long newSeed) {
        this.rand.setSeed(newSeed);
    }

    public void copyToWorld(abv world, int dx, int dy, int dz2) {
        this.worldX = dx;
        this.worldY = dy;
        this.worldZ = dz2;
        for (int x = 0; x < this.rawWidth; ++x) {
            for (int z2 = 0; z2 < this.rawDepth; ++z2) {
                int y;
                int odd;
                int even;
                if (this.getRaw(x, z2) != 0) continue;
                int mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                int mdz = dz2 + z2 / 2 * (this.evenBias + this.oddBias);
                if (this.isEven(x) && this.isEven(z2)) {
                    if (this.type == 4 && this.shouldTree(x, z2)) {
                        new TFGenCanopyTree().a(world, this.rand, mdx, dy, mdz);
                    } else {
                        int y2;
                        for (y2 = 0; y2 < this.head; ++y2) {
                            this.putHeadBlock(world, mdx, dy + this.tall + y2, mdz);
                        }
                        for (y2 = 0; y2 < this.tall; ++y2) {
                            this.putWallBlock(world, mdx, dy + y2, mdz);
                        }
                        for (y2 = 1; y2 <= this.roots; ++y2) {
                            this.putRootBlock(world, mdx, dy - y2, mdz);
                        }
                    }
                }
                if (this.isEven(x) && !this.isEven(z2)) {
                    for (even = 0; even < this.evenBias; ++even) {
                        for (odd = 1; odd <= this.oddBias; ++odd) {
                            for (y = 0; y < this.head; ++y) {
                                this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + odd);
                            }
                            for (y = 0; y < this.tall; ++y) {
                                this.putWallBlock(world, mdx + even, dy + y, mdz + odd);
                            }
                            for (y = 1; y <= this.roots; ++y) {
                                this.putRootBlock(world, mdx + even, dy - y, mdz + odd);
                            }
                        }
                    }
                }
                if (this.isEven(x) || !this.isEven(z2)) continue;
                for (even = 0; even < this.evenBias; ++even) {
                    for (odd = 1; odd <= this.oddBias; ++odd) {
                        for (y = 0; y < this.head; ++y) {
                            this.putHeadBlock(world, mdx + odd, dy + this.tall + y, mdz + even);
                        }
                        for (y = 0; y < this.tall; ++y) {
                            this.putWallBlock(world, mdx + odd, dy + y, mdz + even);
                        }
                        for (y = 1; y <= this.roots; ++y) {
                            this.putRootBlock(world, mdx + odd, dy - y, mdz + even);
                        }
                    }
                }
            }
        }
        this.placeTorches(world);
    }

    public void carveToWorld(abv world, int dx, int dy, int dz2) {
        this.worldX = dx;
        this.worldY = dy;
        this.worldZ = dz2;
        for (int x = 0; x < this.rawWidth; ++x) {
            for (int z2 = 0; z2 < this.rawDepth; ++z2) {
                int y;
                int i;
                if (this.getRaw(x, z2) == 0) continue;
                int mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                int mdz = dz2 + z2 / 2 * (this.evenBias + this.oddBias);
                if (this.isEven(x) && this.isEven(z2)) {
                    for (int y2 = 0; y2 < this.tall; ++y2) {
                        this.carveBlock(world, mdx, dy + y2, mdz);
                    }
                    continue;
                }
                if (this.isEven(x) && !this.isEven(z2)) {
                    for (i = 1; i <= this.oddBias; ++i) {
                        for (y = 0; y < this.tall; ++y) {
                            this.carveBlock(world, mdx, dy + y, mdz + i);
                        }
                    }
                    continue;
                }
                if (!this.isEven(x) && this.isEven(z2)) {
                    for (i = 1; i <= this.oddBias; ++i) {
                        for (y = 0; y < this.tall; ++y) {
                            this.carveBlock(world, mdx + i, dy + y, mdz);
                        }
                    }
                    continue;
                }
                if (this.isEven(x) || this.isEven(z2)) continue;
                for (int mx = 1; mx <= this.oddBias; ++mx) {
                    for (int mz = 1; mz <= this.oddBias; ++mz) {
                        for (int y3 = 0; y3 < this.tall; ++y3) {
                            this.carveBlock(world, mdx + mx, dy + y3, mdz + mz);
                        }
                    }
                }
            }
        }
        this.placeTorches(world);
    }

    public void copyToStructure(abv world, int dx, int dy, int dz2, StructureTFComponent component, age sbb) {
        int mdx;
        int z2;
        int x;
        for (x = 0; x < this.rawWidth; ++x) {
            for (z2 = 0; z2 < this.rawDepth; ++z2) {
                int odd;
                int y;
                int even;
                int mdz;
                if (this.getRaw(x, z2) == 0) {
                    mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                    mdz = dz2 + z2 / 2 * (this.evenBias + this.oddBias);
                    if (this.evenBias > 1) {
                        --mdx;
                        --mdz;
                    }
                    if (this.isEven(x) && this.isEven(z2)) {
                        if (this.type == 4 && this.shouldTree(x, z2)) {
                            this.putCanopyTree(world, mdx, dy, mdz, component, sbb);
                        } else {
                            for (even = 0; even < this.evenBias; ++even) {
                                for (int even2 = 0; even2 < this.evenBias; ++even2) {
                                    for (y = 0; y < this.head; ++y) {
                                        this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + even2, component, sbb);
                                    }
                                    for (y = 0; y < this.tall; ++y) {
                                        if (this.shouldPillar(x, z2)) {
                                            this.putPillarBlock(world, mdx + even, dy + y, mdz + even2, component, sbb);
                                            continue;
                                        }
                                        this.putWallBlock(world, mdx + even, dy + y, mdz + even2, component, sbb);
                                    }
                                    for (y = 1; y <= this.roots; ++y) {
                                        this.putRootBlock(world, mdx + even, dy - y, mdz + even2, component, sbb);
                                    }
                                }
                            }
                        }
                    }
                    if (this.isEven(x) && !this.isEven(z2)) {
                        for (even = 0; even < this.evenBias; ++even) {
                            for (odd = 1; odd <= this.oddBias; ++odd) {
                                this.makeWallThing(world, dy, component, sbb, mdx, mdz, even, odd);
                            }
                        }
                    }
                    if (this.isEven(x) || !this.isEven(z2)) continue;
                    for (even = 0; even < this.evenBias; ++even) {
                        for (odd = 1; odd <= this.oddBias; ++odd) {
                            this.makeWallThing(world, dy, component, sbb, mdx, mdz, odd, even);
                        }
                    }
                    continue;
                }
                if (this.getRaw(x, z2) != 6) continue;
                mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                mdz = dz2 + z2 / 2 * (this.evenBias + this.oddBias);
                if (this.evenBias > 1) {
                    --mdx;
                    --mdz;
                }
                if (this.isEven(x) && !this.isEven(z2)) {
                    for (even = 0; even < this.evenBias; ++even) {
                        for (odd = 1; odd <= this.oddBias; ++odd) {
                            for (y = 0; y < this.head; ++y) {
                                this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + odd, component, sbb);
                            }
                            for (y = 0; y < this.tall; ++y) {
                                this.putDoorBlock(world, mdx + even, dy + y, mdz + odd, component, sbb);
                            }
                            for (y = 1; y <= this.roots; ++y) {
                                this.putRootBlock(world, mdx + even, dy - y, mdz + odd, component, sbb);
                            }
                        }
                    }
                }
                if (this.isEven(x) || !this.isEven(z2)) continue;
                for (even = 0; even < this.evenBias; ++even) {
                    for (odd = 1; odd <= this.oddBias; ++odd) {
                        for (y = 0; y < this.head; ++y) {
                            this.putHeadBlock(world, mdx + odd, dy + this.tall + y, mdz + even, component, sbb);
                        }
                        for (y = 0; y < this.tall; ++y) {
                            this.putDoorBlock(world, mdx + odd, dy + y, mdz + even, component, sbb);
                        }
                        for (y = 1; y <= this.roots; ++y) {
                            this.putRootBlock(world, mdx + odd, dy - y, mdz + even, component, sbb);
                        }
                    }
                }
            }
        }
        for (x = 0; x < this.rawWidth; ++x) {
            for (z2 = 0; z2 < this.rawDepth; ++z2) {
                if (this.getRaw(x, z2) != 0) continue;
                mdx = dx + x / 2 * (this.evenBias + this.oddBias);
                int mdy = dy + 1;
                int mdz = dz2 + z2 / 2 * (this.evenBias + this.oddBias);
                if (!this.isEven(x) || !this.isEven(z2) || !this.shouldTorch(x, z2) || component.a(world, mdx, mdy, mdz, sbb) != this.wallBlockID) continue;
                component.a(world, this.torchBlockID, this.torchBlockMeta, mdx, mdy, mdz, sbb);
            }
        }
    }

    protected void makeWallThing(abv world, int dy, StructureTFComponent component, age sbb, int mdx, int mdz, int even, int odd) {
        int y;
        for (y = 0; y < this.head; ++y) {
            this.putHeadBlock(world, mdx + even, dy + this.tall + y, mdz + odd, component, sbb);
        }
        for (y = 0; y < this.tall; ++y) {
            this.putWallBlock(world, mdx + even, dy + y, mdz + odd, component, sbb);
        }
        for (y = 1; y <= this.roots; ++y) {
            this.putRootBlock(world, mdx + even, dy - y, mdz + odd, component, sbb);
        }
    }

    protected void putPillarBlock(abv world, int x, int y, int z2, StructureTFComponent component, age sbb) {
        component.a(world, this.pillarBlockID, this.pillarBlockMeta, x, y, z2, sbb);
    }

    protected void putWallBlock(abv world, int x, int y, int z2) {
        world.f(x, y, z2, this.wallBlockID, this.wallBlockMeta, 2);
    }

    protected void putWallBlock(abv world, int x, int y, int z2, StructureTFComponent component, age sbb) {
        if (this.wallVarRarity > 0.0f && this.rand.nextFloat() < this.wallVarRarity) {
            component.a(world, this.wallVar0ID, this.wallVar0Meta, x, y, z2, sbb);
        } else {
            component.a(world, this.wallBlockID, this.wallBlockMeta, x, y, z2, sbb);
        }
    }

    protected void putDoorBlock(abv world, int x, int y, int z2, StructureTFComponent component, age sbb) {
        component.a(world, this.doorBlockID, this.doorBlockMeta, x, y, z2, sbb);
    }

    protected void carveBlock(abv world, int x, int y, int z2) {
        world.f(x, y, z2, 0, 0, 2);
    }

    protected void putHeadBlock(abv world, int x, int y, int z2) {
        world.f(x, y, z2, this.headBlockID, this.headBlockMeta, 2);
    }

    protected void putHeadBlock(abv world, int x, int y, int z2, StructureTFComponent component, age sbb) {
        component.a(world, this.headBlockID, this.headBlockMeta, x, y, z2, sbb);
    }

    protected void putRootBlock(abv world, int x, int y, int z2) {
        world.f(x, y, z2, this.rootBlockID, this.rootBlockMeta, 2);
    }

    protected void putRootBlock(abv world, int x, int y, int z2, StructureTFComponent component, age sbb) {
        component.a(world, this.rootBlockID, this.rootBlockMeta, x, y, z2, sbb);
    }

    protected void putCanopyTree(abv world, int x, int y, int z2, StructureTFComponent component, age sbb) {
        int wz;
        int wy;
        int wx = component.a(x, z2);
        if (sbb.b(wx, wy = component.a(y), wz = component.b(x, z2))) {
            new TFGenCanopyTree().a(world, this.rand, wx, wy, wz);
        }
    }

    public final boolean isEven(int n) {
        return n % 2 == 0;
    }

    public void placeTorches(abv world) {
        int torchHeight = 1;
        for (int x = 0; x < this.rawWidth; ++x) {
            for (int z2 = 0; z2 < this.rawDepth; ++z2) {
                if (this.getRaw(x, z2) != 0) continue;
                int mdx = this.worldX + x / 2 * (this.evenBias + this.oddBias);
                int mdy = this.worldY + torchHeight;
                int mdz = this.worldZ + z2 / 2 * (this.evenBias + this.oddBias);
                if (!this.isEven(x) || !this.isEven(z2) || !this.shouldTorch(x, z2) || world.a(mdx, mdy, mdz) != this.wallBlockID) continue;
                world.f(mdx, mdy, mdz, this.torchBlockID, this.torchBlockMeta, 2);
            }
        }
    }

    public boolean shouldTorch(int rx2, int rz) {
        if (this.getRaw(rx2 + 1, rz) == Integer.MIN_VALUE || this.getRaw(rx2 - 1, rz) == Integer.MIN_VALUE || this.getRaw(rx2, rz + 1) == Integer.MIN_VALUE || this.getRaw(rx2, rz - 1) == Integer.MIN_VALUE) {
            return false;
        }
        if (this.getRaw(rx2 + 1, rz) == 0 && this.getRaw(rx2 - 1, rz) == 0 || this.getRaw(rx2, rz + 1) == 0 && this.getRaw(rx2, rz - 1) == 0) {
            return false;
        }
        return this.rand.nextFloat() <= this.torchRarity;
    }

    public boolean shouldPillar(int rx2, int rz) {
        if (this.pillarBlockID == -1) {
            return false;
        }
        if (this.getRaw(rx2 + 1, rz) == Integer.MIN_VALUE || this.getRaw(rx2 - 1, rz) == Integer.MIN_VALUE || this.getRaw(rx2, rz + 1) == Integer.MIN_VALUE || this.getRaw(rx2, rz - 1) == Integer.MIN_VALUE) {
            return false;
        }
        return (this.getRaw(rx2 + 1, rz) != 0 || this.getRaw(rx2 - 1, rz) != 0) && (this.getRaw(rx2, rz + 1) != 0 || this.getRaw(rx2, rz - 1) != 0);
    }

    public boolean shouldTree(int rx2, int rz) {
        if (!(rx2 != 0 && rx2 != this.rawWidth - 1 || this.getRaw(rx2, rz + 1) == 0 && this.getRaw(rx2, rz - 1) == 0)) {
            return true;
        }
        if (!(rz != 0 && rz != this.rawDepth - 1 || this.getRaw(rx2 + 1, rz) == 0 && this.getRaw(rx2 - 1, rz) == 0)) {
            return true;
        }
        return this.rand.nextInt(50) == 0;
    }

    int getWorldX(int x) {
        return this.worldX + x * (this.evenBias + this.oddBias) + 1;
    }

    int getWorldZ(int z2) {
        return this.worldZ + z2 * (this.evenBias + this.oddBias) + 1;
    }

    public void carveRoom0(int cx, int cz) {
        this.putCell(cx, cz, 5);
        this.putCell(cx + 1, cz, 5);
        this.putWall(cx, cz, cx + 1, cz, 5);
        this.putCell(cx - 1, cz, 5);
        this.putWall(cx, cz, cx - 1, cz, 5);
        this.putCell(cx, cz + 1, 5);
        this.putWall(cx, cz, cx, cz + 1, 5);
        this.putCell(cx, cz - 1, 5);
        this.putWall(cx, cz, cx, cz - 1, 5);
    }

    public void carveRoom1(int cx, int cz) {
        int rx2 = cx * 2 + 1;
        int rz = cz * 2 + 1;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                this.putRaw(rx2 + i, rz + j, 5);
            }
        }
        this.putCell(rx2, rz + 1, 0);
        this.putCell(rx2, rz - 1, 0);
        this.putCell(rx2 + 1, rz, 0);
        this.putCell(rx2 - 1, rz, 0);
        if (this.getRaw(rx2, rz + 4) != Integer.MIN_VALUE) {
            this.putRaw(rx2, rz + 3, 5);
        }
        if (this.getRaw(rx2, rz - 4) != Integer.MIN_VALUE) {
            this.putRaw(rx2, rz - 3, 5);
        }
        if (this.getRaw(rx2 + 4, rz) != Integer.MIN_VALUE) {
            this.putRaw(rx2 + 3, rz, 5);
        }
        if (this.getRaw(rx2 - 4, rz) != Integer.MIN_VALUE) {
            this.putRaw(rx2 - 3, rz, 5);
        }
    }

    public void add4Exits() {
        int hx = this.rawWidth / 2 + 1;
        int hz = this.rawDepth / 2 + 1;
        this.putRaw(hx, 0, 5);
        this.putRaw(hx, this.rawDepth - 1, 5);
        this.putRaw(0, hz, 5);
        this.putRaw(this.rawWidth - 1, hz, 5);
    }

    public void generateRecursiveBacktracker(int sx, int sz) {
        this.rbGen(sx, sz);
    }

    public void rbGen(int sx, int sz) {
        this.putCell(sx, sz, 1);
        int unvisited = 0;
        if (this.cellEquals(sx + 1, sz, 0)) {
            ++unvisited;
        }
        if (this.cellEquals(sx - 1, sz, 0)) {
            ++unvisited;
        }
        if (this.cellEquals(sx, sz + 1, 0)) {
            ++unvisited;
        }
        if (this.cellEquals(sx, sz - 1, 0)) {
            ++unvisited;
        }
        if (unvisited == 0) {
            return;
        }
        int rn2 = this.rand.nextInt(unvisited);
        int dz2 = 0;
        int dx = 0;
        if (this.cellEquals(sx + 1, sz, 0)) {
            if (rn2 == 0) {
                dx = sx + 1;
                dz2 = sz;
            }
            --rn2;
        }
        if (this.cellEquals(sx - 1, sz, 0)) {
            if (rn2 == 0) {
                dx = sx - 1;
                dz2 = sz;
            }
            --rn2;
        }
        if (this.cellEquals(sx, sz + 1, 0)) {
            if (rn2 == 0) {
                dx = sx;
                dz2 = sz + 1;
            }
            --rn2;
        }
        if (this.cellEquals(sx, sz - 1, 0) && rn2 == 0) {
            dx = sx;
            dz2 = sz - 1;
        }
        if (this.rand.nextFloat() <= this.doorRarity) {
            this.putWall(sx, sz, dx, dz2, 6);
        } else {
            this.putWall(sx, sz, dx, dz2, 2);
        }
        this.rbGen(dx, dz2);
        this.rbGen(sx, sz);
        this.rbGen(sx, sz);
    }
}

