/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.forge.asm.compatibility;

import invtweaks.forge.asm.compatibility.ContainerInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompatibilityConfigLoader
extends DefaultHandler {
    private Map<String, ContainerInfo> config;

    public CompatibilityConfigLoader(Map<String, ContainerInfo> map) {
        this.config = map;
    }

    public static Map<String, ContainerInfo> load(String string) throws Exception {
        HashMap<String, ContainerInfo> hashMap = new HashMap<String, ContainerInfo>();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(new File(string), (DefaultHandler)new CompatibilityConfigLoader(hashMap));
        return hashMap;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("chest".equals(string3) || "inventory".equals(string3)) {
            ContainerInfo containerInfo = new ContainerInfo();
            String string4 = attributes.getValue("class");
            if (string4 == null) {
                return;
            }
            if ("chest".equals(string3)) {
                containerInfo.validChest = true;
                String string5 = attributes.getValue("row_size");
                if (string5 != null) {
                    containerInfo.rowSize = Short.parseShort(string5);
                }
                containerInfo.largeChest = Boolean.parseBoolean(attributes.getValue("large_chest"));
            } else if ("inventory".equals(string3)) {
                containerInfo.validInventory = true;
                containerInfo.standardInventory = !Boolean.parseBoolean(attributes.getValue("disable_buttons"));
            }
            this.config.put(string4, containerInfo);
        }
    }
}

