/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.forge.asm;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import invtweaks.forge.asm.ASMHelper;
import invtweaks.forge.asm.FMLPlugin;
import invtweaks.forge.asm.compatibility.CompatibilityConfigLoader;
import invtweaks.forge.asm.compatibility.ContainerInfo;
import invtweaks.forge.asm.compatibility.MethodInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ContainerTransformer
implements IClassTransformer {
    public static final String VALID_INVENTORY_METHOD = "invtweaks$validInventory";
    public static final String VALID_CHEST_METHOD = "invtweaks$validChest";
    public static final String LARGE_CHEST_METHOD = "invtweaks$largeChest";
    public static final String STANDARD_INVENTORY_METHOD = "invtweaks$standardInventory";
    public static final String ROW_SIZE_METHOD = "invtweaks$rowSize";
    public static final String SLOT_MAP_METHOD = "invtweaks$slotMap";
    public static final String CONTAINER_CLASS_INTERNAL = "net/minecraft/inventory/Container";
    public static final String SLOT_MAPS_VANILLA_CLASS = "invtweaks/containers/VanillaSlotMaps";
    public static final String SLOT_MAPS_MODCOMPAT_CLASS = "invtweaks/containers/CompatibilitySlotMaps";
    public static final String ANNOTATION_CHEST_CONTAINER = "Linvtweaks/api/container/ChestContainer;";
    public static final String ANNOTATION_CHEST_CONTAINER_ROW_CALLBACK = "Linvtweaks/api/container/ChestContainer$RowSizeCallback;";
    public static final String ANNOTATION_INVENTORY_CONTAINER = "Linvtweaks/api/container/InventoryContainer;";
    public static final String ANNOTATION_CONTAINER_SECTION_CALLBACK = "Linvtweaks/api/container/ContainerSectionCallback;";
    private static Map<String, ContainerInfo> standardClasses = new HashMap<String, ContainerInfo>();
    private static Map<String, ContainerInfo> compatibilityClasses = new HashMap<String, ContainerInfo>();
    private static Map<String, ContainerInfo> configClasses = new HashMap<String, ContainerInfo>();
    private static String containerClassName;

    private void lateInit() {
        standardClasses.put("net.minecraft.inventory.ContainerPlayer", new ContainerInfo(true, true, false, ContainerTransformer.getVanillaSlotMapInfo("containerPlayerSlots")));
        standardClasses.put("net.minecraft.inventory.ContainerMerchant", new ContainerInfo(true, true, false));
        standardClasses.put("net.minecraft.inventory.ContainerRepair", new ContainerInfo(true, true, false, ContainerTransformer.getVanillaSlotMapInfo("containerPlayerSlots")));
        standardClasses.put("net.minecraft.inventory.ContainerHopper", new ContainerInfo(true, true, false));
        standardClasses.put("net.minecraft.inventory.ContainerBeacon", new ContainerInfo(true, true, false));
        standardClasses.put("net.minecraft.inventory.ContainerBrewingStand", new ContainerInfo(true, true, false, ContainerTransformer.getVanillaSlotMapInfo("containerBrewingSlots")));
        standardClasses.put("net.minecraft.inventory.ContainerWorkbench", new ContainerInfo(true, true, false, ContainerTransformer.getVanillaSlotMapInfo("containerWorkbenchSlots")));
        standardClasses.put("net.minecraft.inventory.ContainerEnchantment", new ContainerInfo(true, true, false, ContainerTransformer.getVanillaSlotMapInfo("containerEnchantmentSlots")));
        standardClasses.put("net.minecraft.inventory.ContainerFurnace", new ContainerInfo(true, true, false, ContainerTransformer.getVanillaSlotMapInfo("containerFurnaceSlots")));
        standardClasses.put("net.minecraft.inventory.ContainerDispenser", new ContainerInfo(false, false, true, 3, ContainerTransformer.getVanillaSlotMapInfo("containerChestDispenserSlots")));
        standardClasses.put("net.minecraft.inventory.ContainerChest", new ContainerInfo(false, false, true, ContainerTransformer.getVanillaSlotMapInfo("containerChestDispenserSlots")));
        ContainerInfo containerInfo = new ContainerInfo(false, false, true, true);
        compatibilityClasses.put("cpw.mods.ironchest.ContainerIronChestBase", containerInfo);
        compatibilityClasses.put("com.pahimar.ee3.inventory.ContainerAlchemicalBag", new ContainerInfo(false, false, true, true, 13));
        compatibilityClasses.put("com.pahimar.ee3.inventory.ContainerAlchemicalChest", new ContainerInfo(false, false, true, true, 13));
        compatibilityClasses.put("com.pahimar.ee3.inventory.ContainerPortableCrafting", new ContainerInfo(true, true, false, ContainerTransformer.getCompatiblitySlotMapInfo("ee3PortableCraftingSlots")));
        compatibilityClasses.put("codechicken.enderstorage.storage.item.ContainerEnderItemStorage", new ContainerInfo(false, false, true));
        compatibilityClasses.put("micdoodle8.mods.galacticraft.core.inventory.GCCoreContainerPlayer", new ContainerInfo(true, true, false, ContainerTransformer.getCompatiblitySlotMapInfo("galacticraftPlayerSlots")));
        try {
            configClasses = CompatibilityConfigLoader.load("config/InvTweaksCompatibility.xml");
        }
        catch (Exception exception) {
            configClasses = new HashMap<String, ContainerInfo>();
        }
    }

    public byte[] transform(String string, String string2, byte[] byArray) {
        if (containerClassName == null) {
            containerClassName = FMLPlugin.runtimeDeobfEnabled ? FMLDeobfuscatingRemapper.INSTANCE.unmap(CONTAINER_CLASS_INTERNAL) : CONTAINER_CLASS_INTERNAL;
            this.lateInit();
        }
        ClassReader classReader = new ClassReader(byArray);
        ClassNode classNode = new ClassNode(262144);
        ClassWriter classWriter = new ClassWriter(3);
        classReader.accept((ClassVisitor)classNode, 0);
        if ("net.minecraft.inventory.Container".equals(string2)) {
            FMLRelaunchLog.info((String)"InvTweaks: %s", (Object[])new Object[]{string2});
            ContainerTransformer.transformBaseContainer(classNode);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if ("net.minecraft.client.gui.inventory.ContainerCreative".equals(string2)) {
            FMLRelaunchLog.info((String)"InvTweaks: %s", (Object[])new Object[]{string2});
            ContainerTransformer.transformCreativeContainer(classNode);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        ContainerInfo containerInfo = standardClasses.get(string2);
        if (containerInfo != null) {
            FMLRelaunchLog.info((String)"InvTweaks: %s", (Object[])new Object[]{string2});
            ContainerTransformer.transformContainer(classNode, containerInfo);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if ("invtweaks.InvTweaksObfuscation".equals(string2)) {
            FMLRelaunchLog.info((String)"InvTweaks: %s", (Object[])new Object[]{string2});
            Type type = Type.getObjectType((String)containerClassName);
            for (MethodNode methodNode : classNode.methods) {
                if ("isValidChest".equals(methodNode.name)) {
                    ASMHelper.replaceSelfForwardingMethod(methodNode, VALID_CHEST_METHOD, type);
                    continue;
                }
                if ("isValidInventory".equals(methodNode.name)) {
                    ASMHelper.replaceSelfForwardingMethod(methodNode, VALID_INVENTORY_METHOD, type);
                    continue;
                }
                if ("isStandardInventory".equals(methodNode.name)) {
                    ASMHelper.replaceSelfForwardingMethod(methodNode, STANDARD_INVENTORY_METHOD, type);
                    continue;
                }
                if ("getSpecialChestRowSize".equals(methodNode.name)) {
                    ASMHelper.replaceSelfForwardingMethod(methodNode, ROW_SIZE_METHOD, type);
                    continue;
                }
                if ("getContainerSlotMap".equals(methodNode.name)) {
                    ASMHelper.replaceSelfForwardingMethod(methodNode, SLOT_MAP_METHOD, type);
                    continue;
                }
                if (!"isLargeChest".equals(methodNode.name)) continue;
                ASMHelper.replaceSelfForwardingMethod(methodNode, LARGE_CHEST_METHOD, type);
            }
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        containerInfo = configClasses.get(string2);
        if (containerInfo != null) {
            FMLRelaunchLog.info((String)"InvTweaks: %s", (Object[])new Object[]{string2});
            ContainerTransformer.transformContainer(classNode, containerInfo);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : classNode.visibleAnnotations) {
                Object object;
                String string3;
                short n;
                short s;
                if (annotationNode == null) continue;
                ContainerInfo containerInfo2 = null;
                if (ANNOTATION_CHEST_CONTAINER.equals(annotationNode.desc)) {
                    s = 9;
                    n = 0;
                    if (annotationNode.values != null) {
                        for (int i = 0; i < annotationNode.values.size(); i += 2) {
                            string3 = (String)annotationNode.values.get(i);
                            Object e = annotationNode.values.get(i + 1);
                            if ("rowSize".equals(string3)) {
                                s = (short)((Integer)e).intValue();
                                continue;
                            }
                            if (!"isLargeChest".equals(string3)) continue;
                            n = ((Boolean)e).booleanValue() ? 1 : 0;
                        }
                    }
                    containerInfo2 = new ContainerInfo(false, false, true, n != 0, s);
                    object = this.findAnnotatedMethod(classNode, ANNOTATION_CHEST_CONTAINER_ROW_CALLBACK);
                    if (object != null) {
                        containerInfo2.rowSizeMethod = new MethodInfo(Type.getMethodType((String)object.desc), Type.getObjectType((String)classNode.name), object.name);
                    }
                } else if (ANNOTATION_INVENTORY_CONTAINER.equals(annotationNode.desc)) {
                    s = 1;
                    if (annotationNode.values != null) {
                        for (n = 0; n < annotationNode.values.size(); n += 2) {
                            object = (String)annotationNode.values.get(n);
                            string3 = annotationNode.values.get(n + 1);
                            if (!"showOptions".equals(object)) continue;
                            s = ((Boolean)((Object)string3)).booleanValue() ? 1 : 0;
                        }
                    }
                    containerInfo2 = new ContainerInfo(s != 0, true, false);
                }
                if (containerInfo2 == null) continue;
                MethodNode methodNode = this.findAnnotatedMethod(classNode, ANNOTATION_CONTAINER_SECTION_CALLBACK);
                if (methodNode != null) {
                    containerInfo2.slotMapMethod = new MethodInfo(Type.getMethodType((String)methodNode.desc), Type.getObjectType((String)classNode.name), methodNode.name);
                }
                ContainerTransformer.transformContainer(classNode, containerInfo2);
                classNode.accept((ClassVisitor)classWriter);
                return classWriter.toByteArray();
            }
        }
        if ((containerInfo = compatibilityClasses.get(string2)) != null) {
            FMLRelaunchLog.info((String)"InvTweaks: %s", (Object[])new Object[]{string2});
            ContainerTransformer.transformContainer(classNode, containerInfo);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        if ("net.minecraft.client.gui.GuiTextField".equals(string2)) {
            FMLRelaunchLog.info((String)"InvTweaks: %s", (Object[])new Object[]{string2});
            ContainerTransformer.transformTextField(classNode);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return byArray;
    }

    private MethodNode findAnnotatedMethod(ClassNode classNode, String string) {
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode.visibleAnnotations == null) continue;
            for (AnnotationNode annotationNode : methodNode.visibleAnnotations) {
                if (!string.equals(annotationNode.desc)) continue;
                return methodNode;
            }
        }
        return null;
    }

    public static void transformContainer(ClassNode classNode, ContainerInfo containerInfo) {
        ASMHelper.generateBooleanMethodConst(classNode, STANDARD_INVENTORY_METHOD, containerInfo.standardInventory);
        ASMHelper.generateBooleanMethodConst(classNode, VALID_INVENTORY_METHOD, containerInfo.validInventory);
        ASMHelper.generateBooleanMethodConst(classNode, VALID_CHEST_METHOD, containerInfo.validChest);
        ASMHelper.generateBooleanMethodConst(classNode, LARGE_CHEST_METHOD, containerInfo.largeChest);
        if (containerInfo.rowSizeMethod != null) {
            if (containerInfo.rowSizeMethod.isStatic) {
                ASMHelper.generateForwardingToStaticMethod(classNode, ROW_SIZE_METHOD, containerInfo.rowSizeMethod.methodName, containerInfo.rowSizeMethod.methodType.getReturnType(), containerInfo.rowSizeMethod.methodClass, containerInfo.rowSizeMethod.methodType.getArgumentTypes()[0]);
            } else {
                ASMHelper.generateSelfForwardingMethod(classNode, ROW_SIZE_METHOD, containerInfo.rowSizeMethod.methodName, containerInfo.rowSizeMethod.methodType.getReturnType());
            }
        } else {
            ASMHelper.generateIntegerMethodConst(classNode, ROW_SIZE_METHOD, containerInfo.rowSize);
        }
        if (containerInfo.slotMapMethod.isStatic) {
            ASMHelper.generateForwardingToStaticMethod(classNode, SLOT_MAP_METHOD, containerInfo.slotMapMethod.methodName, containerInfo.slotMapMethod.methodType.getReturnType(), containerInfo.slotMapMethod.methodClass, containerInfo.slotMapMethod.methodType.getArgumentTypes()[0]);
        } else {
            ASMHelper.generateSelfForwardingMethod(classNode, SLOT_MAP_METHOD, containerInfo.slotMapMethod.methodName, containerInfo.slotMapMethod.methodType.getReturnType());
        }
    }

    public static void transformBaseContainer(ClassNode classNode) {
        ASMHelper.generateBooleanMethodConst(classNode, STANDARD_INVENTORY_METHOD, false);
        ASMHelper.generateBooleanMethodConst(classNode, VALID_INVENTORY_METHOD, false);
        ASMHelper.generateBooleanMethodConst(classNode, VALID_CHEST_METHOD, false);
        ASMHelper.generateBooleanMethodConst(classNode, LARGE_CHEST_METHOD, false);
        ASMHelper.generateIntegerMethodConst(classNode, ROW_SIZE_METHOD, (short)9);
        ASMHelper.generateForwardingToStaticMethod(classNode, SLOT_MAP_METHOD, "unknownContainerSlots", Type.getObjectType((String)"java/util/Map"), Type.getObjectType((String)SLOT_MAPS_VANILLA_CLASS));
    }

    public static void transformCreativeContainer(ClassNode classNode) {
        ASMHelper.generateForwardingToStaticMethod(classNode, STANDARD_INVENTORY_METHOD, "containerCreativeIsInventory", Type.BOOLEAN_TYPE, Type.getObjectType((String)SLOT_MAPS_VANILLA_CLASS));
        ASMHelper.generateForwardingToStaticMethod(classNode, VALID_INVENTORY_METHOD, "containerCreativeIsInventory", Type.BOOLEAN_TYPE, Type.getObjectType((String)SLOT_MAPS_VANILLA_CLASS));
        ASMHelper.generateBooleanMethodConst(classNode, VALID_CHEST_METHOD, false);
        ASMHelper.generateBooleanMethodConst(classNode, LARGE_CHEST_METHOD, false);
        ASMHelper.generateIntegerMethodConst(classNode, ROW_SIZE_METHOD, (short)9);
        ASMHelper.generateForwardingToStaticMethod(classNode, SLOT_MAP_METHOD, "containerCreativeSlots", Type.getObjectType((String)"java/util/Map"), Type.getObjectType((String)SLOT_MAPS_VANILLA_CLASS));
    }

    private static void transformTextField(ClassNode classNode) {
        for (MethodNode methodNode : classNode.methods) {
            String string = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(classNode.name, methodNode.name, methodNode.desc);
            String string2 = FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(methodNode.desc);
            if (!"func_73796_b".equals(string) || !"(Z)V".equals(string2)) continue;
            InsnList insnList = methodNode.instructions;
            AbstractInsnNode abstractInsnNode = null;
            for (AbstractInsnNode abstractInsnNode2 : insnList) {
                if (abstractInsnNode2.getOpcode() != 177) continue;
                abstractInsnNode = abstractInsnNode2;
                break;
            }
            if (abstractInsnNode != null) {
                insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new VarInsnNode(21, 1));
                insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "invtweaks/forge/InvTweaksMod", "setTextboxModeStatic", "(Z)V"));
                FMLRelaunchLog.info((String)"InvTweaks: successfully transformed setFocused/func_73796_b", (Object[])new Object[0]);
                continue;
            }
            FMLRelaunchLog.severe((String)"InvTweaks: unable to find return in setFocused/func_73796_b", (Object[])new Object[0]);
        }
    }

    public static MethodInfo getCompatiblitySlotMapInfo(String string) {
        return ContainerTransformer.getSlotMapInfo(Type.getObjectType((String)SLOT_MAPS_MODCOMPAT_CLASS), string, true);
    }

    public static MethodInfo getVanillaSlotMapInfo(String string) {
        return ContainerTransformer.getSlotMapInfo(Type.getObjectType((String)SLOT_MAPS_VANILLA_CLASS), string, true);
    }

    public static MethodInfo getSlotMapInfo(Type type, String string, boolean bl) {
        return new MethodInfo(Type.getMethodType((Type)Type.getObjectType((String)"java/util/Map"), (Type[])new Type[]{Type.getObjectType((String)containerClassName)}), type, string, bl);
    }
}

