/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.tool.ItemToolWrench;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemToolWrenchElectric
extends ItemToolWrench
implements IElectricItem {
    public ItemToolWrenchElectric(Configuration config, InternalName internalName) {
        super(config, internalName);
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(entityplayer)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
            boolean newValue = !nbtData.func_74767_n("losslessMode");
            nbtData.func_74757_a("losslessMode", newValue);
            if (newValue) {
                IC2.platform.messagePlayer(entityplayer, "Lossless wrench mode enabled", new Object[0]);
            } else {
                IC2.platform.messagePlayer(entityplayer, "Lossless wrench mode disabled", new Object[0]);
            }
        }
        return itemstack;
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (IC2.keyboard.isModeSwitchKeyDown(entityPlayer)) {
            return false;
        }
        return super.onItemUseFirst(itemstack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean canTakeDamage(ItemStack stack, int amount) {
        return ElectricItem.manager.discharge(stack, amount *= 50, Integer.MAX_VALUE, true, true) == amount;
    }

    @Override
    public void damage(ItemStack itemStack, int amount, EntityPlayer player) {
        ElectricItem.manager.use(itemStack, 50 * amount, (EntityLivingBase)player);
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack) {
        return 12000;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 1;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack) {
        return 250;
    }

    public void func_77633_a(int i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @Override
    public boolean overrideWrenchSuccessRate(ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        return nbtData.func_74767_n("losslessMode");
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }
}

