/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.Resource;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class BlockTextureStitched
extends TextureAtlasSprite {
    private BufferedImage comparisonImage;
    private TextureAtlasSprite mappedTexture;
    private final int subIndex;
    private static Map<String, BufferedImage> cachedImages = new HashMap<String, BufferedImage>();
    private static Map<Integer, List<BlockTextureStitched>> existingTextures = new HashMap<Integer, List<BlockTextureStitched>>();

    public BlockTextureStitched(String name, int subIndex) {
        super(name);
        this.subIndex = subIndex;
    }

    public void func_94217_a(TextureAtlasSprite textureStitched) {
        if (textureStitched.func_94215_i().equals("missingno") && this.mappedTexture != null) {
            super.func_94217_a(this.mappedTexture);
        } else {
            super.func_94217_a(textureStitched);
        }
    }

    public void func_94219_l() {
    }

    public boolean load(ResourceManager manager, ResourceLocation location) throws IOException {
        String name = location.func_110623_a();
        int index = name.indexOf(58);
        if (index != -1) {
            int extStart = name.lastIndexOf(46);
            location = new ResourceLocation(location.func_110624_b(), name.substring(0, index) + name.substring(extStart));
        }
        return this.loadSubImage(manager.func_110536_a(location));
    }

    public boolean loadSubImage(Resource res) throws IOException {
        String name = this.func_94215_i();
        BufferedImage bufferedImage = cachedImages.get(name);
        if (bufferedImage == null) {
            bufferedImage = ImageIO.read(res.func_110527_b());
            cachedImages.put(name, bufferedImage);
        }
        int size = bufferedImage.getHeight();
        int count = bufferedImage.getWidth() / size;
        int index = this.subIndex;
        if (count == 1 || count == 6 || count == 12) {
            index %= count;
        } else if (count == 2) {
            index /= 6;
        } else {
            IC2.log.warning("texture " + name + " is not properly sized");
            throw new IOException();
        }
        this.field_130223_c = size;
        this.field_130224_d = size;
        this.comparisonImage = bufferedImage.getSubimage(index * size, 0, size, size);
        int[] rgbaData = new int[size * size];
        this.comparisonImage.getRGB(0, 0, size, size, rgbaData, 0, size);
        int hash = Arrays.hashCode(rgbaData);
        List<BlockTextureStitched> matchingTextures = existingTextures.get(hash);
        if (matchingTextures != null) {
            int[] rgbaData2 = new int[size * size];
            for (BlockTextureStitched matchingTexture : matchingTextures) {
                if (matchingTexture.comparisonImage.getWidth() != size) continue;
                matchingTexture.comparisonImage.getRGB(0, 0, size, size, rgbaData2, 0, size);
                if (!Arrays.equals(rgbaData, rgbaData2)) continue;
                this.mappedTexture = matchingTexture;
                return false;
            }
            matchingTextures.add(this);
        } else {
            matchingTextures = new ArrayList<BlockTextureStitched>();
            matchingTextures.add(this);
            existingTextures.put(hash, matchingTextures);
        }
        this.field_110976_a.add(rgbaData);
        return true;
    }

    public Icon getRealTexture() {
        return this.mappedTexture == null ? this : this.mappedTexture;
    }

    public static void onPostStitch() {
        for (List<BlockTextureStitched> textures : existingTextures.values()) {
            for (BlockTextureStitched texture : textures) {
                texture.comparisonImage = null;
            }
        }
        cachedImages.clear();
        existingTextures.clear();
    }
}

